/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.io.serialization.human;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;
import xaero.pac.common.server.io.serialization.human.HumanReadableStringConverter;

public class HumanReadableSerializedDataFileIO<S, I>
implements SerializedDataFileIO<S, I> {
    private final HumanReadableStringConverter<S, I> converter;

    public HumanReadableSerializedDataFileIO(HumanReadableStringConverter<S, I> converter) {
        this.converter = converter;
    }

    @Override
    public S read(I id, BufferedInputStream fileInput) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileInput, "UTF8"));){
            StringBuilder stringBuilder = new StringBuilder();
            reader.lines().forEach(line -> {
                stringBuilder.append((String)line);
                stringBuilder.append('\n');
            });
            S s = this.converter.convert(id, stringBuilder.toString());
            return s;
        }
    }

    @Override
    public void write(BufferedOutputStream fileOutput, S serializedData) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutput, StandardCharsets.UTF_8);){
            writer.write((String)this.converter.convert((Object)serializedData));
            writer.close();
        }
    }
}

