/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.class_9139;
import xaero.pac.common.packet.ClientPacketHandlerFabric;
import xaero.pac.common.packet.PacketHandlerFull;
import xaero.pac.common.packet.ServerPacketReceiverFabric;
import xaero.pac.common.packet.payload.PacketPayload;
import xaero.pac.common.packet.payload.PacketPayloadCodec;
import xaero.pac.common.packet.type.PacketTypeManager;

public class PacketHandlerFabric
extends PacketHandlerFull {
    private ClientPacketHandlerFabric clientPacketHandlerFabric;

    private PacketHandlerFabric(PacketTypeManager packetTypeManager) {
        super(packetTypeManager);
    }

    private void setClientPacketHandlerFabric(ClientPacketHandlerFabric clientPacketHandlerFabric) {
        this.clientPacketHandlerFabric = clientPacketHandlerFabric;
    }

    public void registerOnClient() {
        this.clientPacketHandlerFabric.registerOnClient();
    }

    public void registerCommon() {
        PacketPayloadCodec payloadCodec = new PacketPayloadCodec();
        PayloadTypeRegistry.playS2C().register(PacketPayload.TYPE, (class_9139)payloadCodec);
        PayloadTypeRegistry.playC2S().register(PacketPayload.TYPE, (class_9139)payloadCodec);
        ServerPlayNetworking.registerGlobalReceiver(PacketPayload.TYPE, (ServerPlayNetworking.PlayPayloadHandler)new ServerPacketReceiverFabric(this));
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.clientPacketHandlerFabric.sendToServer(packet);
    }

    @Override
    public <T> void sendToPlayer(class_3222 player, T packet) {
        ServerPlayNetworking.send((class_3222)player, this.createPayload(packet));
    }

    public static class Builder
    extends PacketHandlerFull.Builder {
        private Builder() {
        }

        @Override
        public Builder setDefault() {
            return this;
        }

        @Override
        public PacketHandlerFabric build() {
            return (PacketHandlerFabric)super.build();
        }

        @Override
        protected PacketHandlerFull buildInternal(PacketTypeManager packetTypeManager) {
            PacketHandlerFabric result = new PacketHandlerFabric(packetTypeManager);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                result.setClientPacketHandlerFabric(new ClientPacketHandlerFabric(result));
            }
            return result;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

