/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.util.list;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ListUniqueAdder<T>
implements List<T> {
    private List<T> destinationList;
    private Set<T> checkingSet = new HashSet<T>();

    public ListUniqueAdder<T> setDestinationList(List<T> destinationList) {
        this.destinationList = destinationList;
        this.checkingSet.clear();
        this.checkingSet.addAll(destinationList);
        return this;
    }

    @Override
    public int size() {
        return this.destinationList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.destinationList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.checkingSet.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.destinationList.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.destinationList.forEach(action);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.destinationList.toArray();
    }

    @Override
    @Nonnull
    public <A> A[] toArray(@Nonnull A[] a) {
        return this.destinationList.toArray(a);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.destinationList.toArray(generator);
    }

    @Override
    public boolean add(T element) {
        if (!this.checkingSet.add(element)) {
            return false;
        }
        if (!this.destinationList.add(element)) {
            this.checkingSet.remove(element);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.checkingSet.containsAll(c);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        boolean result = false;
        for (T element : c) {
            if (!this.add(element)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> c) {
        int currentIndex = index;
        for (T element : c) {
            if (!this.checkingSet.add(element)) continue;
            this.add(currentIndex, element);
            ++currentIndex;
        }
        return currentIndex != index;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.destinationList.sort(c);
    }

    @Override
    public void clear() {
        this.checkingSet.clear();
        this.destinationList.clear();
    }

    @Override
    public T get(int index) {
        return this.destinationList.get(index);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        if (!this.checkingSet.add(element)) {
            return;
        }
        this.destinationList.add(index, element);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.destinationList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.destinationList.lastIndexOf(o);
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.destinationList.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.destinationList.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.destinationList.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.destinationList.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.destinationList.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.destinationList.parallelStream();
    }

    @Override
    public void addFirst(T element) {
        this.add(0, element);
    }

    @Override
    public void addLast(T element) {
        this.add(element);
    }

    @Override
    public T getFirst() {
        return this.destinationList.getFirst();
    }

    @Override
    public T getLast() {
        return this.destinationList.getLast();
    }

    @Override
    public T removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> reversed() {
        return this.destinationList.reversed();
    }
}

