/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.claims.api.IClientClaimsManagerAPI;
import xaero.pac.client.claims.player.IClientPlayerClaimInfo;
import xaero.pac.client.command.util.CommandUtil;
import xaero.pac.client.controls.keybinding.IKeyBindingHelper;
import xaero.pac.client.gui.ConfigMenu;
import xaero.pac.client.gui.XPACScreen;
import xaero.pac.client.gui.component.CachedComponentSupplier;
import xaero.pac.client.parties.party.IClientParty;
import xaero.pac.client.parties.party.IClientPartyAllyInfo;
import xaero.pac.client.parties.party.IClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.client.world.capability.ClientWorldMainCapability;
import xaero.pac.client.world.capability.api.ClientWorldCapabilityTypes;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.packet.LazyPacketsConfirmationPacket;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.player.config.PlayerConfig;

public class MainMenu
extends XPACScreen {
    public static final Component NO_HANDSHAKE = Component.m_237115_((String)"gui.xaero_pac_ui_handshake_not_received");
    public static final Component NO_PARTIES = Component.m_237115_((String)"gui.xaero_pac_ui_parties_disabled");
    public static final Component NO_CLAIMS = Component.m_237115_((String)"gui.xaero_pac_ui_claims_disabled");
    public static final Component PARTY_SYNCING = Component.m_237115_((String)"gui.xaero_pac_ui_party_syncing");
    public static final Component CLAIMS_SYNCING = Component.m_237115_((String)"gui.xaero_pac_ui_claims_syncing");
    private static final Component ABOUT_PARTY_COMMAND = Component.m_237113_((String)"/openpac-parties about");
    public static final Component CLAIM = Component.m_237115_((String)"gui.xaero_pac_ui_claim");
    public static final Component UNCLAIM = Component.m_237115_((String)"gui.xaero_pac_ui_unclaim");
    private static final Component CLAIM_COMMAND = Component.m_237113_((String)"/openpac-claims claim");
    private static final Component UNCLAIM_COMMAND = Component.m_237113_((String)"/openpac-claims unclaim");
    public static final Component FORCELOAD = Component.m_237115_((String)"gui.xaero_pac_ui_forceload");
    public static final Component UNFORCELOAD = Component.m_237115_((String)"gui.xaero_pac_ui_unforceload");
    private static final Component FORCELOAD_COMMAND = Component.m_237113_((String)"/openpac-claims forceload");
    private static final Component UNFORCELOAD_COMMAND = Component.m_237113_((String)"/openpac-claims unforceload");
    private static final CachedComponentSupplier partyNameSupplier = new CachedComponentSupplier(args -> {
        String currentPartyName = (String)args[0];
        return Component.m_237110_((String)"gui.xaero_pac_ui_party_name", (Object[])new Object[]{Component.m_237113_((String)currentPartyName).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier ownerNameSupplier = new CachedComponentSupplier(args -> {
        String currentOwnerName = (String)args[0];
        return Component.m_237110_((String)"gui.xaero_pac_ui_party_owner", (Object[])new Object[]{Component.m_237113_((String)currentOwnerName).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier memberCountSupplier = new CachedComponentSupplier(args -> {
        int currentMemberCount = (Integer)args[0];
        int currentMemberLimit = (Integer)args[1];
        return Component.m_237110_((String)"gui.xaero_pac_ui_party_member_count", (Object[])new Object[]{Component.m_237113_((String)(currentMemberCount + " / " + currentMemberLimit)).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier allyCountSupplier = new CachedComponentSupplier(args -> {
        int currentAllyCount = (Integer)args[0];
        int currentAllyLimit = (Integer)args[1];
        return Component.m_237110_((String)"gui.xaero_pac_ui_party_ally_count", (Object[])new Object[]{Component.m_237113_((String)(currentAllyCount + " / " + currentAllyLimit)).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier inviteCountSupplier = new CachedComponentSupplier(args -> {
        int currentInviteCount = (Integer)args[0];
        int currentInviteLimit = (Integer)args[1];
        return Component.m_237110_((String)"gui.xaero_pac_ui_party_invite_count", (Object[])new Object[]{Component.m_237113_((String)(currentInviteCount + " / " + currentInviteLimit)).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier claimsNameSupplier = new CachedComponentSupplier(args -> {
        String currentClaimsName = (String)args[0];
        MutableComponent nameComponent = Component.m_237113_((String)currentClaimsName).m_130938_(s -> s.m_178520_(-5592406));
        return Component.m_237110_((String)"gui.xaero_pac_ui_claims_name", (Object[])new Object[]{nameComponent});
    });
    private static final CachedComponentSupplier claimCountSupplier = new CachedComponentSupplier(args -> {
        int currentClaimCount = (Integer)args[0];
        int currentClaimLimit = (Integer)args[1];
        MutableComponent numbers = Component.m_237113_((String)(currentClaimCount + " / " + currentClaimLimit)).m_130938_(s -> s.m_178520_(-5592406));
        return Component.m_237110_((String)"gui.xaero_pac_ui_claim_count", (Object[])new Object[]{numbers});
    });
    private static final CachedComponentSupplier forceloadCountSupplier = new CachedComponentSupplier(args -> {
        int currentForceloadCount = (Integer)args[0];
        int currentForceloadLimit = (Integer)args[1];
        return Component.m_237110_((String)"gui.xaero_pac_ui_forceload_count", (Object[])new Object[]{Component.m_237113_((String)(currentForceloadCount + " / " + currentForceloadLimit)).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier claimsColorSupplier = new CachedComponentSupplier(args -> {
        int currentClaimColor = (Integer)args[0];
        MutableComponent colorComponent = Component.m_237113_((String)Integer.toUnsignedString(currentClaimColor, 16).toUpperCase()).m_130938_(s -> s.m_178520_(currentClaimColor));
        return Component.m_237110_((String)"gui.xaero_pac_ui_claims_color", (Object[])new Object[]{colorComponent});
    });
    private boolean serverHasMod;
    private boolean serverHasClaimsEnabled;
    private boolean serverHasPartiesEnabled;
    private Button configsButton;
    private Button aboutPartyButton;
    private Button claimButton;
    private Button forceloadButton;
    public static boolean TEST_TOGGLE;

    public MainMenu(Screen escape, Screen parent) {
        super(escape, parent, (Component)Component.m_237115_((String)"gui.xaero_pac_ui_main_menu"));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.configsButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_pac_ui_config_menu"), this::onConfigsButton).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 8, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.configsButton);
        this.aboutPartyButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_pac_ui_about_party"), this::onAboutPartyButton).m_257505_(Tooltip.m_257550_((Component)ABOUT_PARTY_COMMAND)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 40, 70, 20).m_253136_();
        this.claimButton = Button.m_253074_((Component)CLAIM, this::onClaimButton).m_257505_(Tooltip.m_257550_((Component)CLAIM_COMMAND)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 112, 70, 20).m_253136_();
        this.forceloadButton = Button.m_253074_((Component)FORCELOAD, this::onForceloadButton).m_257505_(Tooltip.m_257550_((Component)FORCELOAD_COMMAND)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 136, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_pac_back"), this::onBackButton).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 200, 20).m_253136_());
        this.updateButtons();
        if (this.serverHasPartiesEnabled) {
            this.m_142416_((GuiEventListener)this.aboutPartyButton);
        }
        if (this.serverHasClaimsEnabled) {
            this.m_142416_((GuiEventListener)this.claimButton);
            this.m_142416_((GuiEventListener)this.forceloadButton);
        }
    }

    private void onTestToggle(Button button) {
        boolean bl = TEST_TOGGLE = !TEST_TOGGLE;
        if (!TEST_TOGGLE) {
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new LazyPacketsConfirmationPacket());
        }
        OpenPartiesAndClaims.LOGGER.info("test toggle set to " + TEST_TOGGLE);
    }

    private void updateButtons() {
        ClientWorldMainCapability mainCap = (ClientWorldMainCapability)OpenPartiesAndClaims.INSTANCE.getCapabilityHelper().getCapability(this.f_96541_.f_91073_, ClientWorldCapabilityTypes.MAIN_CAP);
        this.serverHasMod = this.configsButton.f_93623_ = mainCap.getClientWorldData().serverHasMod();
        this.serverHasClaimsEnabled = mainCap.getClientWorldData().serverHasClaimsEnabled();
        this.serverHasPartiesEnabled = mainCap.getClientWorldData().serverHasPartiesEnabled();
        this.aboutPartyButton.f_93623_ = this.serverHasMod && OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null;
        this.forceloadButton.f_93623_ = false;
        this.claimButton.f_93623_ = false;
        if (this.serverHasMod && !OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
            IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
            boolean adminMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isAdminMode();
            boolean serverMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isServerMode();
            UUID claimTargetUUID = serverMode ? PlayerConfig.SERVER_CLAIM_UUID : this.f_96541_.f_91074_.m_20148_();
            this.claimButton.f_93623_ = adminMode || currentClaim == null || currentClaim.getPlayerId().equals(claimTargetUUID);
            boolean wouldClaim = this.wouldClaim(currentClaim);
            this.claimButton.m_93666_(wouldClaim ? CLAIM : UNCLAIM);
            this.claimButton.m_257544_(Tooltip.m_257550_((Component)(wouldClaim ? CLAIM_COMMAND : UNCLAIM_COMMAND)));
            this.forceloadButton.f_93623_ = adminMode || currentClaim != null && currentClaim.getPlayerId().equals(claimTargetUUID);
            boolean wouldForceload = currentClaim == null || !currentClaim.isForceloadable();
            this.forceloadButton.m_93666_(wouldForceload ? FORCELOAD : UNFORCELOAD);
            this.forceloadButton.m_257544_(Tooltip.m_257550_((Component)(wouldForceload ? FORCELOAD_COMMAND : UNFORCELOAD_COMMAND)));
        }
    }

    private void onConfigsButton(Button b) {
        this.f_96541_.m_91152_((Screen)new ConfigMenu(this.escape, this));
    }

    private void onAboutPartyButton(Button b) {
        CommandUtil.sendCommand(this.f_96541_, ABOUT_PARTY_COMMAND.getString().substring(1));
        this.f_96541_.m_91152_(null);
    }

    private boolean wouldClaim(IPlayerChunkClaim currentClaim) {
        if (currentClaim == null) {
            return true;
        }
        IPlayerChunkClaim potentialClaimReflection = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().getPotentialClaimStateReflection();
        return !currentClaim.isSameClaimType(potentialClaimReflection);
    }

    private void onClaimButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
        if (this.wouldClaim(currentClaim)) {
            CommandUtil.sendCommand(this.f_96541_, CLAIM_COMMAND.getString().substring(1));
        } else {
            CommandUtil.sendCommand(this.f_96541_, UNCLAIM_COMMAND.getString().substring(1));
        }
        this.m_7379_();
    }

    private void onForceloadButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
        if (currentClaim == null) {
            return;
        }
        if (!currentClaim.isForceloadable()) {
            CommandUtil.sendCommand(this.f_96541_, FORCELOAD_COMMAND.getString().substring(1));
        } else {
            CommandUtil.sendCommand(this.f_96541_, UNFORCELOAD_COMMAND.getString().substring(1));
        }
        this.m_7379_();
    }

    private void onBackButton(Button b) {
        this.goBack();
    }

    private void drawPartyInfo(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        IClientPartyStorage<IClientPartyAllyInfo, IClientParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>, IClientPartyMemberDynamicInfoSyncableStorage<IPartyMemberDynamicInfoSyncable>> partyStorage = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage();
        String actualPartyName = partyStorage.getPartyName();
        if (actualPartyName == null || actualPartyName.isEmpty()) {
            actualPartyName = "N/A";
        }
        MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)partyNameSupplier.get(actualPartyName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 42), (int)-1);
        if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null) {
            String actualOwnerName = partyStorage.getParty().getOwner().getUsername();
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)ownerNameSupplier.get(actualOwnerName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 54), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)memberCountSupplier.get(partyStorage.getUIMemberCount(), partyStorage.getMemberLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 66), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)allyCountSupplier.get(partyStorage.getUIAllyCount(), partyStorage.getAllyLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 78), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)inviteCountSupplier.get(partyStorage.getUIInviteCount(), partyStorage.getInviteLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 90), (int)-1);
        }
    }

    private void drawClaimsInfo(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        IClientClaimsManagerAPI claimsManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager();
        if (claimsManager.hasPlayerInfo(this.f_96541_.f_91074_.m_20148_())) {
            IClientPlayerClaimInfo playerInfo = (IClientPlayerClaimInfo)claimsManager.getPlayerInfo(this.f_96541_.f_91074_.m_20148_());
            boolean shouldUseLoadingValues = claimsManager.isLoading() || claimsManager.getAlwaysUseLoadingValues();
            int claimCount = shouldUseLoadingValues ? claimsManager.getLoadingClaimCount() : playerInfo.getClaimCount();
            int claimLimit = claimsManager.getClaimLimit();
            int forceloadCount = shouldUseLoadingValues ? claimsManager.getLoadingForceloadCount() : playerInfo.getForceloadCount();
            int forceloadLimit = claimsManager.getForceloadLimit();
            int currentSubConfigIndex = claimsManager.getCurrentSubConfigIndex();
            Object claimsName = playerInfo.getClaimsName(currentSubConfigIndex);
            if (claimsName == null && currentSubConfigIndex != -1) {
                claimsName = playerInfo.getClaimsName();
            }
            if (claimsName == null || ((String)claimsName).isEmpty()) {
                claimsName = "N/A";
            }
            claimsName = (String)claimsName + " (" + claimsManager.getCurrentSubConfigId() + ")";
            Integer claimsColor = playerInfo.getClaimsColor(currentSubConfigIndex);
            if (claimsColor == null && currentSubConfigIndex != -1) {
                claimsColor = playerInfo.getClaimsColor();
            }
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimCountSupplier.get(claimCount, claimLimit), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 114), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)forceloadCountSupplier.get(forceloadCount, forceloadLimit), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 126), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimsNameSupplier.get(claimsName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 138), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimsColorSupplier.get(claimsColor), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 150), (int)-1);
        }
    }

    @Override
    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        this.updateButtons();
        this.m_7333_(poseStack);
        MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)16, (int)-1);
        super.m_86412_(poseStack, mouseX, mouseY, partial);
        if (!this.serverHasMod) {
            MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_HANDSHAKE, (int)(this.f_96543_ / 2), (int)27, (int)-43691);
        } else {
            if (this.serverHasPartiesEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().isLoading()) {
                    MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)PARTY_SYNCING, (int)(this.f_96543_ / 2 - 104 - this.f_96547_.m_92852_((FormattedText)PARTY_SYNCING)), (int)(this.f_96544_ / 7 + 42), (int)-1);
                }
                this.drawPartyInfo(poseStack, mouseX, mouseY, partial);
            } else {
                MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_PARTIES, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 42), (int)-5592406);
            }
            if (this.serverHasClaimsEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
                    MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)CLAIMS_SYNCING, (int)(this.f_96543_ / 2 - 104 - this.f_96547_.m_92852_((FormattedText)CLAIMS_SYNCING)), (int)(this.f_96544_ / 7 + 114), (int)-1);
                }
                this.drawClaimsInfo(poseStack, mouseX, mouseY, partial);
            } else {
                MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_CLAIMS, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 114), (int)-5592406);
            }
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.m_7222_() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84868_() == InputConstants.Type.KEYSYM && p_96552_ == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_96552_, p_96553_, p_96554_);
    }

    @Override
    public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.m_7222_() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84868_() == InputConstants.Type.MOUSE && p_94697_ == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(p_94695_, p_94696_, p_94697_);
    }
}

