/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;

public class ClientboundModesPacket {
    private final boolean adminMode;
    private final boolean serverMode;

    public ClientboundModesPacket(boolean adminMode, boolean serverMode) {
        this.adminMode = adminMode;
        this.serverMode = serverMode;
    }

    public static class ClientHandler
    implements Consumer<ClientboundModesPacket> {
        @Override
        public void accept(ClientboundModesPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimModes(t.adminMode, t.serverMode);
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundModesPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ClientboundModesPacket> {
        @Override
        public ClientboundModesPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                boolean adminMode = tag.m_128471_("am");
                boolean serverMode = tag.m_128471_("sm");
                return new ClientboundModesPacket(adminMode, serverMode);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }

        @Override
        public void accept(ClientboundModesPacket t, FriendlyByteBuf u) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("am", t.adminMode);
            tag.m_128379_("sm", t.serverMode);
            u.m_130079_(tag);
        }
    }
}

