/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server;

import java.util.LinkedHashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.ServerStartingCallback;
import xaero.pac.common.server.ServerTickHandler;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.ServerClaimsPermissionHandler;
import xaero.pac.common.server.claims.forceload.ForceLoadTicketManager;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.claims.player.expiration.ServerPlayerClaimsExpirationHandler;
import xaero.pac.common.server.claims.player.io.PlayerClaimInfoManagerIO;
import xaero.pac.common.server.claims.player.io.serialization.nbt.PlayerClaimInfoNbtSerializer;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.ExceptionElementType;
import xaero.pac.common.server.claims.protection.WildcardResolver;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroupLoader;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.config.ServerConfigUpdater;
import xaero.pac.common.server.expiration.task.ObjectExpirationCheckSpreadoutTask;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.info.ServerInfoHolder;
import xaero.pac.common.server.info.io.ServerInfoHolderIO;
import xaero.pac.common.server.io.FileIOHelper;
import xaero.pac.common.server.io.IOThreadWorker;
import xaero.pac.common.server.io.ObjectManagerIO;
import xaero.pac.common.server.io.ObjectManagerLiveSaver;
import xaero.pac.common.server.io.serialization.SimpleSerializationHandler;
import xaero.pac.common.server.io.serialization.human.HumanReadableSerializedDataFileIO;
import xaero.pac.common.server.io.serialization.human.SimpleHumanReadableStringConverter;
import xaero.pac.common.server.io.serialization.nbt.SimpleNBTSerializedDataFileIO;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.PartyManagerFixer;
import xaero.pac.common.server.parties.party.PartyPlayerInfoUpdater;
import xaero.pac.common.server.parties.party.PlayerLogInPartyAssigner;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.expiration.PartyExpirationHandler;
import xaero.pac.common.server.parties.party.io.PartyManagerIO;
import xaero.pac.common.server.parties.party.io.serialization.nbt.PartyNbtSerializer;
import xaero.pac.common.server.parties.party.task.PartyRemovalSpreadoutTask;
import xaero.pac.common.server.parties.system.PlayerPartySystemManager;
import xaero.pac.common.server.player.PlayerLoginHandler;
import xaero.pac.common.server.player.PlayerLogoutHandler;
import xaero.pac.common.server.player.PlayerTickHandler;
import xaero.pac.common.server.player.PlayerWorldJoinHandler;
import xaero.pac.common.server.player.config.PlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.io.PlayerConfigIO;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.permission.PlayerPermissionChangeHandler;
import xaero.pac.common.server.player.permission.PlayerPermissionSystemManager;
import xaero.pac.common.server.task.ServerSpreadoutQueuedTaskHandler;
import xaero.pac.common.server.task.ServerSpreadoutTaskHandler;
import xaero.pac.common.server.task.player.ServerPlayerSpreadoutTaskHandler;

public class ServerDataInitializer {
    public ServerData init(OpenPartiesAndClaims modMain, MinecraftServer server) {
        try {
            ServerInfo serverInfo;
            IOThreadWorker ioThreadWorker = new IOThreadWorker();
            ioThreadWorker.begin();
            FileIOHelper fileIOHelper = new FileIOHelper();
            ServerInfoHolder serverInfoHolder = new ServerInfoHolder();
            ServerInfoHolderIO serverInfoIO = ((ServerInfoHolderIO.Builder)((ServerInfoHolderIO.Builder)((ServerInfoHolderIO.Builder)((ServerInfoHolderIO.Builder)ServerInfoHolderIO.Builder.begin().setServer(server)).setFileIOHelper(fileIOHelper)).setIoThreadWorker(ioThreadWorker)).setManager(serverInfoHolder)).build();
            serverInfoIO.load();
            if (serverInfoHolder.getServerInfo() == null) {
                serverInfo = new ServerInfo(0L, 1);
                serverInfoHolder.setObject(serverInfo);
                serverInfo.setDirty(true);
                serverInfoIO.save();
            } else {
                serverInfo = serverInfoHolder.getServerInfo();
            }
            if (serverInfo.getLoadedVersion() < 1) {
                new ServerConfigUpdater().update(serverInfo);
            }
            ServerTickHandler serverTickHandler = ServerTickHandler.Builder.begin().setServer(server).build();
            ServerSpreadoutTaskHandler claimReplaceTaskHandler = ((ServerSpreadoutQueuedTaskHandler.Builder)((ServerSpreadoutQueuedTaskHandler.Builder)ServerSpreadoutQueuedTaskHandler.Builder.begin().setPerTickLimit(256)).setPerTickPerTaskLimit(32)).build();
            serverTickHandler.registerSpreadoutTaskHandler(claimReplaceTaskHandler);
            ServerSpreadoutTaskHandler objectExpirationCheckTaskHandler = ((ServerSpreadoutQueuedTaskHandler.Builder)((ServerSpreadoutQueuedTaskHandler.Builder)ServerSpreadoutQueuedTaskHandler.Builder.begin().setPerTickLimit(512)).setPerTickPerTaskLimit(Integer.MAX_VALUE)).build();
            serverTickHandler.registerSpreadoutTaskHandler(objectExpirationCheckTaskHandler);
            ServerSpreadoutTaskHandler playerConfigSyncTaskHandler = ((ServerPlayerSpreadoutTaskHandler.FinalBuilder)((ServerPlayerSpreadoutTaskHandler.FinalBuilder)((ServerPlayerSpreadoutTaskHandler.FinalBuilder)ServerPlayerSpreadoutTaskHandler.FinalBuilder.begin().setPerTickLimit(128)).setPerTickPerTaskLimit(1)).setPlayerTaskGetter(ServerPlayerData::getConfigSyncSpreadoutTask)).build();
            serverTickHandler.registerSpreadoutTaskHandler(playerConfigSyncTaskHandler);
            ServerSpreadoutTaskHandler partyRemovalTaskHandler = ((ServerSpreadoutQueuedTaskHandler.Builder)((ServerSpreadoutQueuedTaskHandler.Builder)ServerSpreadoutQueuedTaskHandler.Builder.begin().setPerTickLimit(8192)).setPerTickPerTaskLimit(512)).build();
            serverTickHandler.registerSpreadoutTaskHandler(partyRemovalTaskHandler);
            PartyPlayerInfoUpdater partyMemberInfoUpdater = new PartyPlayerInfoUpdater();
            PartyManager partyManager = PartyManager.Builder.begin().setServer(server).setPartyRemovalTaskHandler((ServerSpreadoutQueuedTaskHandler<PartyRemovalSpreadoutTask>)partyRemovalTaskHandler).build();
            PartyExpirationHandler partyExpirationHandler = ((PartyExpirationHandler.Builder)((PartyExpirationHandler.Builder)PartyExpirationHandler.Builder.begin().setManager(partyManager)).setServer(server).setServerInfo(serverInfo)).build();
            partyManager.setExpirationHandler(partyExpirationHandler);
            SimpleSerializationHandler<CompoundTag, String, ServerParty, PartyManager> partySerializationHandler = new SimpleSerializationHandler<CompoundTag, String, ServerParty, PartyManager>(PartyNbtSerializer.Builder.begin().build());
            ObjectManagerIO partyManagerIO = ((PartyManagerIO.Builder)((PartyManagerIO.Builder)((PartyManagerIO.Builder)((PartyManagerIO.Builder)((PartyManagerIO.Builder)((PartyManagerIO.Builder)((PartyManagerIO.Builder)PartyManagerIO.Builder.begin().setFileExtension(".nbt")).setSerializationHandler(partySerializationHandler)).setSerializedDataFileIO(new SimpleNBTSerializedDataFileIO())).setIoThreadWorker(ioThreadWorker)).setServer(server)).setManager(partyManager)).setFileIOHelper(fileIOHelper)).build();
            partyManager.setIo((PartyManagerIO<?>)partyManagerIO);
            PlayerLogInPartyAssigner playerPartyAssigner = new PlayerLogInPartyAssigner();
            PlayerTickHandler playerTickHandler = PlayerTickHandler.Builder.begin().build();
            PlayerLoginHandler playerLoginHandler = new PlayerLoginHandler();
            PlayerLogoutHandler playerLogoutHandler = new PlayerLogoutHandler();
            PlayerPermissionChangeHandler playerPermissionChangeHandler = new PlayerPermissionChangeHandler();
            PlayerWorldJoinHandler playerWorldJoinHandler = new PlayerWorldJoinHandler();
            long autosaveInterval = (Integer)ServerConfig.CONFIG.autosaveInterval.get() * 60000;
            ObjectManagerLiveSaver partyLiveSaver = new ObjectManagerLiveSaver(partyManagerIO, autosaveInterval, 0L);
            WildcardResolver wildcardResolver = new WildcardResolver();
            LinkedHashMap<String, ChunkProtectionExceptionGroup<Block>> blockExceptionGroups = new LinkedHashMap<String, ChunkProtectionExceptionGroup<Block>>();
            LinkedHashMap entityExceptionGroups = new LinkedHashMap();
            LinkedHashMap<String, ChunkProtectionExceptionGroup<Item>> itemExceptionGroups = new LinkedHashMap<String, ChunkProtectionExceptionGroup<Item>>();
            LinkedHashMap entityBarrierGroups = new LinkedHashMap();
            LinkedHashMap blockAccessEntityGroups = new LinkedHashMap();
            LinkedHashMap entityAccessEntityGroups = new LinkedHashMap();
            LinkedHashMap droppedItemAccessEntityGroups = new LinkedHashMap();
            ChunkProtectionExceptionGroupLoader exceptionGroupLoader = new ChunkProtectionExceptionGroupLoader();
            ExceptionElementType.updateAllIterables(server);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.blockProtectionOptionalExceptionGroups, ExceptionElementType.BLOCK, Block.class, true, wildcardResolver, blockExceptionGroups, ChunkProtectionExceptionType.INTERACTION, t -> t != ChunkProtectionExceptionType.BARRIER, PlayerConfigOptionCategory.BLOCK_PROTECTION);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.entityProtectionOptionalExceptionGroups, ExceptionElementType.ENTITY_TYPE, EntityType.class, true, wildcardResolver, entityExceptionGroups, ChunkProtectionExceptionType.INTERACTION, t -> t != ChunkProtectionExceptionType.BARRIER, PlayerConfigOptionCategory.ENTITY_PROTECTION);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.itemUseProtectionOptionalExceptionGroups, ExceptionElementType.ITEM, Item.class, true, wildcardResolver, itemExceptionGroups, ChunkProtectionExceptionType.INTERACTION, t -> t == ChunkProtectionExceptionType.INTERACTION, PlayerConfigOptionCategory.PROTECTION_FROM_ITEMS);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.entityClaimBarrierOptionalGroups, ExceptionElementType.ENTITY_TYPE, LevelChunk.class, false, wildcardResolver, entityBarrierGroups, ChunkProtectionExceptionType.BARRIER, t -> t == ChunkProtectionExceptionType.BARRIER, PlayerConfigOptionCategory.MOVEMENT);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.blockAccessEntityGroups, ExceptionElementType.ENTITY_TYPE, Block.class, false, wildcardResolver, blockAccessEntityGroups, ChunkProtectionExceptionType.FULL, t -> t != ChunkProtectionExceptionType.BARRIER, PlayerConfigOptionCategory.BLOCK_PROTECTION);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.entityAccessEntityGroups, ExceptionElementType.ENTITY_TYPE, EntityType.class, false, wildcardResolver, entityAccessEntityGroups, ChunkProtectionExceptionType.FULL, t -> t != ChunkProtectionExceptionType.BARRIER, PlayerConfigOptionCategory.ENTITY_PROTECTION);
            exceptionGroupLoader.load(server, ServerConfig.CONFIG.droppedItemAccessEntityGroups, ExceptionElementType.ENTITY_TYPE, Item.class, false, wildcardResolver, droppedItemAccessEntityGroups, ChunkProtectionExceptionType.FULL, t -> t == ChunkProtectionExceptionType.FULL, PlayerConfigOptionCategory.PICKUP_PROTECTION);
            PlayerConfigManager<ServerParty, ServerClaimsManager> playerConfigs = PlayerConfigManager.Builder.begin().setServer(server).setPartyManager(partyManager).setBlockExceptionGroups(blockExceptionGroups).setEntityExceptionGroups(entityExceptionGroups).setItemExceptionGroups(itemExceptionGroups).setEntityBarrierGroups(entityBarrierGroups).setBlockAccessEntityGroups(blockAccessEntityGroups).setEntityAccessEntityGroups(entityAccessEntityGroups).setDroppedItemAccessEntityGroups(droppedItemAccessEntityGroups).build();
            partyManager.setPlayerConfigs(playerConfigs);
            ObjectManagerIO playerConfigsIO = ((PlayerConfigIO.Builder)((PlayerConfigIO.Builder)((PlayerConfigIO.Builder)((PlayerConfigIO.Builder)((PlayerConfigIO.Builder)PlayerConfigIO.Builder.begin().setServer(server)).setIoThreadWorker(ioThreadWorker)).setFileIOHelper(fileIOHelper)).setManager(playerConfigs)).setSerializedDataFileIO(new HumanReadableSerializedDataFileIO(new SimpleHumanReadableStringConverter()))).build();
            ObjectManagerLiveSaver playerConfigLiveSaver = new ObjectManagerLiveSaver(playerConfigsIO, autosaveInterval, autosaveInterval / 3L);
            ((PlayerConfigIO)playerConfigsIO).load();
            if (((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
                ((PartyManagerIO)partyManagerIO).load();
                new PartyManagerFixer().fix(partyManager);
            }
            ForceLoadTicketManager forceLoadManager = playerConfigs.getForceLoadTicketManager();
            ClaimsManagerSynchronizer claimsSynchronizer = ClaimsManagerSynchronizer.Builder.begin().setServer(server).build();
            ServerClaimsPermissionHandler serverClaimsPermissionHandler = new ServerClaimsPermissionHandler();
            ServerClaimsManager serverClaimsManager = ServerClaimsManager.Builder.begin().setServer(server).setTicketManager(forceLoadManager).setConfigManager(playerConfigs).setClaimsManagerSynchronizer(claimsSynchronizer).setClaimReplaceTaskHandler((ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask>)claimReplaceTaskHandler).setPermissionHandler(serverClaimsPermissionHandler).build();
            forceLoadManager.setClaimsManager(serverClaimsManager);
            playerConfigs.setClaimsManager(serverClaimsManager);
            ObjectManagerIO playerClaimInfoManagerIO = ((PlayerClaimInfoManagerIO.Builder)((PlayerClaimInfoManagerIO.Builder)((PlayerClaimInfoManagerIO.Builder)((PlayerClaimInfoManagerIO.Builder)((PlayerClaimInfoManagerIO.Builder)((PlayerClaimInfoManagerIO.Builder)PlayerClaimInfoManagerIO.Builder.begin().setServerClaimsManager(serverClaimsManager).setFileExtension(".nbt")).setSerializationHandler(new SimpleSerializationHandler<CompoundTag, UUID, ServerPlayerClaimInfo, ServerPlayerClaimInfoManager>(PlayerClaimInfoNbtSerializer.Builder.begin().build()))).setSerializedDataFileIO(new SimpleNBTSerializedDataFileIO())).setIoThreadWorker(ioThreadWorker)).setFileIOHelper(fileIOHelper)).setServer(server)).build();
            serverClaimsManager.setIo((PlayerClaimInfoManagerIO<?>)playerClaimInfoManagerIO);
            ServerPlayerClaimsExpirationHandler claimsExpirationHandler = ((ServerPlayerClaimsExpirationHandler.Builder)serverClaimsManager.beginExpirationHandlerBuilder().setServer(server).setServerInfo(serverInfo)).build();
            serverClaimsManager.setExpirationHandler(claimsExpirationHandler);
            PlayerPermissionSystemManager playerPermissionSystemManager = PlayerPermissionSystemManager.Builder.begin(LinkedHashMap::new).build();
            PlayerPartySystemManager playerPartySystemManager = PlayerPartySystemManager.Builder.begin(LinkedHashMap::new).build();
            ObjectManagerLiveSaver playerClaimInfoLiveSaver = new ObjectManagerLiveSaver(playerClaimInfoManagerIO, autosaveInterval, autosaveInterval / 3L * 2L);
            ChunkProtection<ServerClaimsManager> chunkProtection = ChunkProtection.Builder.begin().setServer(server).setClaimsManager(serverClaimsManager).setPlayerPartySystemManager(playerPartySystemManager).setBlockExceptionGroups(blockExceptionGroups).setEntityExceptionGroups(entityExceptionGroups).setItemExceptionGroups(itemExceptionGroups).setEntityBarrierGroups(entityBarrierGroups).setBlockAccessEntityGroups(blockAccessEntityGroups).setEntityAccessEntityGroups(entityAccessEntityGroups).setDroppedItemAccessEntityGroups(droppedItemAccessEntityGroups).build();
            chunkProtection.updateTagExceptions(server);
            ServerStartingCallback serverLoadCallback = new ServerStartingCallback((PlayerClaimInfoManagerIO<?>)playerClaimInfoManagerIO);
            ServerData serverData = new ServerData(server, partyManager, (PartyManagerIO<?>)partyManagerIO, playerPartyAssigner, partyMemberInfoUpdater, partyExpirationHandler, serverTickHandler, playerTickHandler, playerLoginHandler, playerLogoutHandler, playerPermissionChangeHandler, partyLiveSaver, ioThreadWorker, playerConfigs, (PlayerConfigIO<ServerParty, ServerClaimsManager>)playerConfigsIO, playerConfigLiveSaver, (PlayerClaimInfoManagerIO<?>)playerClaimInfoManagerIO, playerClaimInfoLiveSaver, serverClaimsManager, chunkProtection, serverLoadCallback, forceLoadManager, playerWorldJoinHandler, serverInfo, serverInfoIO, claimsExpirationHandler, (ServerSpreadoutQueuedTaskHandler<ObjectExpirationCheckSpreadoutTask<?>>)objectExpirationCheckTaskHandler, playerPermissionSystemManager, playerPartySystemManager);
            partyManager.getPartySynchronizer().setServerData(serverData);
            claimsSynchronizer.setServerData(serverData);
            serverData.onServerResourcesReload(server.m_177941_());
            chunkProtection.setServerData(serverData);
            serverClaimsPermissionHandler.setServerData(serverData);
            ExceptionElementType.clearAllIterables();
            return serverData;
        }
        catch (Throwable t2) {
            modMain.startupCrashHandler.crash(t2);
            return null;
        }
    }
}

