/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.IPacketHandler;
import xaero.pac.common.packet.PacketConsumerForge;

public class PacketHandlerForge
implements IPacketHandler {
    private static final int PROTOCOL_VERSION = 1004000;
    public static final SimpleChannel NETWORK = ChannelBuilder.named((ResourceLocation)OpenPartiesAndClaims.MAIN_CHANNEL_LOCATION).networkProtocolVersion(1004000).optional().simpleChannel();

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerForge<P> consumer = new PacketConsumerForge<P>(serverHandler, clientHandler);
        if (serverHandler == null != (clientHandler == null)) {
            NETWORK.messageBuilder(type, index, clientHandler != null ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
        } else {
            NETWORK.messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
        }
    }

    public void sendToServer(Object packet) {
        NETWORK.send(packet, PacketDistributor.SERVER.noArg());
    }

    public void sendToPlayer(ServerPlayer player, Object packet) {
        NETWORK.send(packet, PacketDistributor.PLAYER.with((Object)player));
    }
}

