/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimStatesPacket
extends LazyPacket<ClientboundClaimStatesPacket> {
    public static final int MAX_STATES = 128;
    public static final LazyPacket.Encoder<ClientboundClaimStatesPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final List<PlayerChunkClaim> claimStates;

    public ClientboundClaimStatesPacket(List<PlayerChunkClaim> claimStates) {
        this.claimStates = claimStates;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundClaimStatesPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf dest) {
        CompoundTag nbt = new CompoundTag();
        ListTag stateListTag = new ListTag();
        for (int i = 0; i < this.claimStates.size(); ++i) {
            PlayerChunkClaim state = this.claimStates.get(i);
            CompoundTag claimStateNbt = new CompoundTag();
            claimStateNbt.m_128362_("p", state.getPlayerId());
            claimStateNbt.m_128405_("s", state.getSubConfigIndex());
            claimStateNbt.m_128379_("f", state.isForceloadable());
            claimStateNbt.m_128405_("i", state.getSyncIndex());
            stateListTag.add((Object)claimStateNbt);
        }
        nbt.m_128365_("l", (Tag)stateListTag);
        dest.m_130079_((Tag)nbt);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimStatesPacket> {
        @Override
        public ClientboundClaimStatesPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.m_130081_(NbtAccounter.m_301669_());
                if (nbt == null) {
                    return null;
                }
                ListTag stateListTag = nbt.m_128437_("l", 10);
                if (stateListTag.size() > 128) {
                    OpenPartiesAndClaims.LOGGER.info("Received claim state list is too large!");
                    return null;
                }
                ArrayList<PlayerChunkClaim> claimStates = new ArrayList<PlayerChunkClaim>(stateListTag.size());
                for (int i = 0; i < stateListTag.size(); ++i) {
                    CompoundTag claimStateNbt = stateListTag.m_128728_(i);
                    UUID playerId = claimStateNbt.m_128342_("p");
                    int subConfigIndex = claimStateNbt.m_128451_("s");
                    boolean forceloadable = claimStateNbt.m_128471_("f");
                    int syncIndex = claimStateNbt.m_128451_("i");
                    claimStates.add(new PlayerChunkClaim(playerId, subConfigIndex, forceloadable, syncIndex));
                }
                return new ClientboundClaimStatesPacket(claimStates);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimStatesPacket> {
        @Override
        public void handle(ClientboundClaimStatesPacket t) {
            for (PlayerChunkClaim claimState : t.claimStates) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimState(claimState);
            }
        }
    }
}

