/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPlayerClaimsDimensionPacket
extends LazyPacket<ClientboundPlayerClaimsDimensionPacket> {
    public static final LazyPacket.Encoder<ClientboundPlayerClaimsDimensionPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final ResourceLocation dimension;

    public ClientboundPlayerClaimsDimensionPacket(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundPlayerClaimsDimensionPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        if (this.dimension != null) {
            nbt.m_128359_("d", this.dimension.toString());
        }
        u.m_130079_((Tag)nbt);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundPlayerClaimsDimensionPacket> {
        @Override
        public ClientboundPlayerClaimsDimensionPacket apply(FriendlyByteBuf input) {
            try {
                String dimensionString;
                if (input.readableBytes() > 524288) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.m_130081_(NbtAccounter.m_301669_());
                if (nbt == null) {
                    return null;
                }
                String string = dimensionString = nbt.m_128441_("d") ? nbt.m_128461_("d") : "";
                if (dimensionString.length() > 2048) {
                    return null;
                }
                return new ClientboundPlayerClaimsDimensionPacket(dimensionString.isEmpty() ? null : new ResourceLocation(dimensionString));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPlayerClaimsDimensionPacket> {
        @Override
        public void handle(ClientboundPlayerClaimsDimensionPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onDimension(t.dimension);
        }
    }
}

