/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class InviteAcceptPartyCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<class_2168> requirement = commandRequirementProvider.getNonMemberRequirement(p -> true);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"join").requires(requirement)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3222 casterPlayer = ((class_2168)context.getSource()).method_9207();
            class_2487 data = Services.PLATFORM.getEntityAccess().getPersistentData((class_1297)casterPlayer);
            Stream lastInviteId = data.method_10545("xaero_OPAC_LastInviteId") ? Stream.of(XaeroNbtUtil.getUUID(data, "xaero_OPAC_LastInviteId").get().toString()) : Stream.empty();
            return class_2172.method_9264(lastInviteId, (SuggestionsBuilder)builder);
        }).executes(context -> {
            UUID targetPartyId;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerId);
            if (playerParty != null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_already_in_one", new Object[0]));
                return 0;
            }
            String targetPartyStringId = (String)context.getArgument("id", String.class);
            try {
                targetPartyId = UUID.fromString(targetPartyStringId);
            }
            catch (IllegalArgumentException iae) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_invalid_id", new Object[0]));
                return 0;
            }
            IServerPartyAPI targetParty = partyManager.getPartyById(targetPartyId);
            if (targetParty == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_not_exist", new Object[0]));
                return 0;
            }
            if (!targetParty.isInvited(playerId)) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_not_invited", new Object[0]));
                return 0;
            }
            if (targetParty.getMemberCount() >= (Integer)ServerConfig.CONFIG.maxPartyMembers.get()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_member_limit", new Object[0]));
                return 0;
            }
            IPartyMemberAPI addedPartyMember = targetParty.addMember(playerId, null, player.method_7334().getName());
            if (addedPartyMember == null) {
                return 0;
            }
            player.method_64398((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_success", targetParty.getDefaultName()));
            new PartyOnCommandUpdater().update(playerId, serverData, targetParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_join_success_info", (Object[])new Object[]{class_2561.method_43470((String)addedPartyMember.getUsername()).method_27694(s -> s.method_10977(class_124.field_1077))}));
            server.method_3734().method_9241(player);
            return 1;
        })));
        dispatcher.register(command);
    }
}

