/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimLimitsPacket
extends LazyPacket<ClientboundClaimLimitsPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimLimitsPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int loadingClaimCount;
    private final int loadingForceloadCount;
    private final int claimLimit;
    private final int forceloadLimit;
    private final int maxClaimDistance;
    private final boolean alwaysUseLoadingValues;

    public ClientboundClaimLimitsPacket(int loadingClaimCount, int loadingForceloadCount, int claimLimit, int forceloadLimit, int maxClaimDistance, boolean alwaysUseLoadingValues) {
        this.loadingClaimCount = loadingClaimCount;
        this.loadingForceloadCount = loadingForceloadCount;
        this.claimLimit = claimLimit;
        this.forceloadLimit = forceloadLimit;
        this.maxClaimDistance = maxClaimDistance;
        this.alwaysUseLoadingValues = alwaysUseLoadingValues;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_10569("cc", this.loadingClaimCount);
        tag.method_10569("fc", this.loadingForceloadCount);
        tag.method_10569("cl", this.claimLimit);
        tag.method_10569("fl", this.forceloadLimit);
        tag.method_10569("d", this.maxClaimDistance);
        tag.method_10556("a", this.alwaysUseLoadingValues);
        u.method_10794((class_2520)tag);
    }

    @Override
    protected Function<class_2540, ClientboundClaimLimitsPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<class_2540, ClientboundClaimLimitsPacket> {
        @Override
        public ClientboundClaimLimitsPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                class_2487 tag = (class_2487)input.method_30616(class_2505.method_53898());
                if (tag == null) {
                    return null;
                }
                int loadingClaimCount = tag.method_68083("cc", 0);
                int loadingForceloadCount = tag.method_68083("fc", 0);
                int claimLimit = tag.method_68083("cl", 0);
                int forceloadLimit = tag.method_68083("fl", 0);
                int maxClaimDistance = tag.method_68083("d", 0);
                boolean alwaysUseLoadingValues = tag.method_68566("a", false);
                return new ClientboundClaimLimitsPacket(loadingClaimCount, loadingForceloadCount, claimLimit, forceloadLimit, maxClaimDistance, alwaysUseLoadingValues);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimLimitsPacket> {
        @Override
        public void handle(ClientboundClaimLimitsPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimLimits(t.loadingClaimCount, t.loadingForceloadCount, t.claimLimit, t.forceloadLimit, t.maxClaimDistance, t.alwaysUseLoadingValues);
        }
    }
}

