/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import xaero.pac.client.ClientTickHandler;
import xaero.pac.client.ClientWorldLoadHandler;
import xaero.pac.client.IClientData;
import xaero.pac.client.claims.ClientClaimsManager;
import xaero.pac.client.claims.sync.ClientClaimsSyncHandler;
import xaero.pac.client.controls.XPACKeyBindings;
import xaero.pac.client.gui.MainMenu;
import xaero.pac.client.parties.party.ClientPartyStorage;
import xaero.pac.client.player.config.PlayerConfigClientStorageManager;
import xaero.pac.client.player.config.PlayerConfigClientSynchronizer;

public final class ClientData
implements IClientData<PlayerConfigClientStorageManager, ClientPartyStorage, ClientClaimsManager> {
    private final ClientTickHandler clientTickHandler;
    private final ClientWorldLoadHandler clientWorldLoadHandler;
    private final PlayerConfigClientSynchronizer playerConfigClientSynchronizer;
    private final XPACKeyBindings keyBindings;
    private final PlayerConfigClientStorageManager playerConfigStorageManager;
    private final ClientPartyStorage clientPartyStorage;
    private final ClientClaimsManager claimsManager;
    private final ClientClaimsSyncHandler clientClaimsSyncHandler;

    public ClientData(ClientTickHandler clientTickHandler, ClientWorldLoadHandler clientWorldLoadHandler, PlayerConfigClientSynchronizer playerConfigClientSynchronizer, XPACKeyBindings keyBindings, PlayerConfigClientStorageManager playerConfigStorageManager, ClientPartyStorage clientPartyStorage, ClientClaimsManager claimsManager, ClientClaimsSyncHandler clientClaimsSyncHandler) {
        this.clientTickHandler = clientTickHandler;
        this.clientWorldLoadHandler = clientWorldLoadHandler;
        this.playerConfigClientSynchronizer = playerConfigClientSynchronizer;
        this.keyBindings = keyBindings;
        this.playerConfigStorageManager = playerConfigStorageManager;
        this.clientPartyStorage = clientPartyStorage;
        this.claimsManager = claimsManager;
        this.clientClaimsSyncHandler = clientClaimsSyncHandler;
    }

    @Override
    public ClientTickHandler getClientTickHandler() {
        return this.clientTickHandler;
    }

    @Override
    public ClientWorldLoadHandler getClientWorldLoadHandler() {
        return this.clientWorldLoadHandler;
    }

    @Override
    public PlayerConfigClientSynchronizer getPlayerConfigClientSynchronizer() {
        return this.playerConfigClientSynchronizer;
    }

    @Override
    @Nonnull
    public XPACKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorageManager getPlayerConfigStorageManager() {
        return this.playerConfigStorageManager;
    }

    @Override
    @Nonnull
    public ClientPartyStorage getClientPartyStorage() {
        return this.clientPartyStorage;
    }

    @Override
    public void reset() {
        this.clientPartyStorage.reset();
        this.claimsManager.reset();
        this.clientClaimsSyncHandler.reset();
        this.playerConfigStorageManager.reset();
    }

    @Override
    @Nonnull
    public ClientClaimsManager getClaimsManager() {
        return this.claimsManager;
    }

    @Override
    public ClientClaimsSyncHandler getClientClaimsSyncHandler() {
        return this.clientClaimsSyncHandler;
    }

    @Override
    public void openMainMenuScreen(@Nullable Screen escape, @Nullable Screen parent) {
        Minecraft.getInstance().setScreen((Screen)new MainMenu(escape, parent));
    }

    public static final class Builder {
        private ClientTickHandler clientTickHandler;
        private ClientWorldLoadHandler clientWorldLoadHandler;
        private PlayerConfigClientSynchronizer playerConfigClientSynchronizer;
        private XPACKeyBindings keyBindings;
        private PlayerConfigClientStorageManager playerConfigStorageManager;
        private ClientPartyStorage clientPartyStorage;
        private ClientClaimsManager claimsManager;
        private ClientClaimsSyncHandler clientClaimsSyncHandler;

        private Builder setDefault() {
            this.setClientTickHandler(null);
            this.setPlayerConfigClientSynchronizer(null);
            this.setKeyBindings(null);
            this.setPlayerConfigStorageManager(null);
            this.setClientPartyStorage(null);
            this.setClaimsManager(null);
            return this;
        }

        public Builder setClientTickHandler(ClientTickHandler clientTickHandler) {
            this.clientTickHandler = clientTickHandler;
            return this;
        }

        public Builder setClientWorldLoadHandler(ClientWorldLoadHandler clientWorldLoadHandler) {
            this.clientWorldLoadHandler = clientWorldLoadHandler;
            return this;
        }

        public Builder setPlayerConfigClientSynchronizer(PlayerConfigClientSynchronizer playerConfigClientSynchronizer) {
            this.playerConfigClientSynchronizer = playerConfigClientSynchronizer;
            return this;
        }

        public Builder setKeyBindings(XPACKeyBindings keyBindings) {
            this.keyBindings = keyBindings;
            return this;
        }

        public Builder setPlayerConfigStorageManager(PlayerConfigClientStorageManager playerConfigStorageManager) {
            this.playerConfigStorageManager = playerConfigStorageManager;
            return this;
        }

        public Builder setClientPartyStorage(ClientPartyStorage clientPartyStorage) {
            this.clientPartyStorage = clientPartyStorage;
            return this;
        }

        public Builder setClaimsManager(ClientClaimsManager claimsManager) {
            this.claimsManager = claimsManager;
            return this;
        }

        public Builder setClientClaimsSyncHandler(ClientClaimsSyncHandler clientClaimsSyncHandler) {
            this.clientClaimsSyncHandler = clientClaimsSyncHandler;
            return this;
        }

        public ClientData build() {
            if (this.clientTickHandler == null || this.keyBindings == null || this.clientWorldLoadHandler == null || this.playerConfigClientSynchronizer == null || this.playerConfigStorageManager == null || this.clientPartyStorage == null || this.claimsManager == null || this.clientClaimsSyncHandler == null) {
                throw new IllegalStateException();
            }
            return new ClientData(this.clientTickHandler, this.clientWorldLoadHandler, this.playerConfigClientSynchronizer, this.keyBindings, this.playerConfigStorageManager, this.clientPartyStorage, this.claimsManager, this.clientClaimsSyncHandler);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

