/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import xaero.pac.common.claims.ClaimLocation;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.task.IPlayerClaimReplaceSpreadoutTaskCallback;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.task.IServerSpreadoutQueuedTask;

public class PlayerClaimReplaceSpreadoutTask
implements IServerSpreadoutQueuedTask<PlayerClaimReplaceSpreadoutTask> {
    private final IPlayerClaimReplaceSpreadoutTaskCallback callback;
    private final UUID claimOwnerId;
    private final IPlayerChunkClaim with;
    private final Predicate<IPlayerChunkClaim> matcher;
    private boolean finished;
    private int totalCount;

    public PlayerClaimReplaceSpreadoutTask(IPlayerClaimReplaceSpreadoutTaskCallback callback, UUID claimOwnerId, Predicate<IPlayerChunkClaim> matcher, IPlayerChunkClaim with) {
        this.callback = callback;
        this.claimOwnerId = claimOwnerId;
        this.matcher = matcher;
        this.with = with;
    }

    @Override
    public void onQueued(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        IServerClaimsManagerAPI claimManager = serverData.getServerClaimsManager();
        IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)claimManager.getPlayerInfo(this.claimOwnerId);
        playerInfo.setReplacementInProgress(true);
    }

    @Override
    public boolean shouldWork(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PlayerClaimReplaceSpreadoutTask holder) {
        return !this.shouldDrop(serverData, holder);
    }

    @Override
    public boolean shouldDrop(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PlayerClaimReplaceSpreadoutTask holder) {
        return this.finished;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PlayerClaimReplaceSpreadoutTask holder, int perTick, List<PlayerClaimReplaceSpreadoutTask> tasksToAdd) {
        IServerClaimsManagerAPI claimManager = serverData.getServerClaimsManager();
        IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)claimManager.getPlayerInfo(this.claimOwnerId);
        int tickCount = 0;
        ResultType resultType = null;
        if (this.with != null && this.with.getPlayerId().equals(this.claimOwnerId) && this.matcher.test(this.with)) {
            resultType = ResultType.FAILURE_STATE_MATCHES;
            this.finished = true;
        } else {
            Iterator dimensionIterator = playerInfo.getFullStream().iterator();
            Iterator claimPosListIterator = null;
            Iterator claimPosIterator = null;
            ArrayList<ClaimLocation> locations = new ArrayList<ClaimLocation>(perTick);
            while (dimensionIterator.hasNext() && locations.size() < perTick) {
                Map.Entry entry = (Map.Entry)dimensionIterator.next();
                ResourceLocation dimId = (ResourceLocation)entry.getKey();
                IPlayerDimensionClaims dim = (IPlayerDimensionClaims)entry.getValue();
                claimPosListIterator = dim.getTypedStream().iterator();
                while (claimPosListIterator.hasNext() && locations.size() < perTick) {
                    IPlayerClaimPosList claimPosList = (IPlayerClaimPosList)claimPosListIterator.next();
                    IPlayerChunkClaim claimState = claimPosList.getClaimState();
                    if (!this.matcher.test(claimState)) continue;
                    claimPosIterator = claimPosList.getStream().iterator();
                    while (claimPosIterator.hasNext() && locations.size() < perTick) {
                        ChunkPos claimChunkPos = (ChunkPos)claimPosIterator.next();
                        locations.add(new ClaimLocation(dimId, claimChunkPos.x, claimChunkPos.z));
                        ++this.totalCount;
                        ++tickCount;
                    }
                }
            }
            if (!(dimensionIterator.hasNext() || claimPosListIterator != null && (claimPosListIterator.hasNext() || claimPosIterator != null && claimPosIterator.hasNext()))) {
                resultType = ResultType.SUCCESS;
                this.finished = true;
            }
            if (this.with == null) {
                locations.forEach(arg_0 -> PlayerClaimReplaceSpreadoutTask.lambda$onTick$0((IServerClaimsManager)claimManager, arg_0));
            } else {
                locations.forEach(arg_0 -> this.lambda$onTick$1((IServerClaimsManager)claimManager, arg_0));
            }
        }
        if (this.finished) {
            this.callback.onFinish(resultType, tickCount, this.totalCount, serverData);
            playerInfo.setReplacementInProgress(false);
            if (playerInfo.hasReplacementTasks()) {
                tasksToAdd.add(playerInfo.removeNextReplacementTask());
            }
        } else {
            this.callback.onWork(tickCount);
        }
    }

    private /* synthetic */ void lambda$onTick$1(IServerClaimsManager claimManager, ClaimLocation cl) {
        claimManager.claim(cl.getDimId(), this.with.getPlayerId(), this.with.getSubConfigIndex(), cl.getChunkX(), cl.getChunkZ(), this.with.isForceloadable());
    }

    private static /* synthetic */ void lambda$onTick$0(IServerClaimsManager claimManager, ClaimLocation cl) {
        claimManager.unclaim(cl.getDimId(), cl.getChunkX(), cl.getChunkZ());
    }

    public static enum ResultType {
        SUCCESS(true, false, (Component)Component.translatable((String)"gui.xaero_claims_replacement_success")),
        FAILURE_STATE_MATCHES(false, true, (Component)Component.translatable((String)"gui.xaero_claims_replacement_state_matches_matcher"));

        private final boolean success;
        private final boolean failure;
        private final Component message;

        private ResultType(boolean success, boolean failure, Component message) {
            this.success = success;
            this.failure = failure;
            this.message = message;
        }

        public Component getMessage() {
            return this.message;
        }

        public boolean isFailure() {
            return this.failure;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

