/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player.io.serialization.nbt;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimPosList;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.server.claims.player.io.serialization.nbt.PlayerChunkClaimNbtSerializer;

public class PlayerDimensionClaimsNbtSerializer {
    private final PlayerChunkClaimNbtSerializer playerChunkClaimDataNbtSerializer;

    public PlayerDimensionClaimsNbtSerializer(PlayerChunkClaimNbtSerializer playerChunkClaimDataNbtSerializer) {
        this.playerChunkClaimDataNbtSerializer = playerChunkClaimDataNbtSerializer;
    }

    public PlayerDimensionClaims deserialize(UUID playerId, String dimension, class_2487 nbt) {
        class_2499 claimsTag = nbt.method_10554("claims", 10);
        HashMap<PlayerChunkClaim, PlayerClaimPosList> claimLists = new HashMap<PlayerChunkClaim, PlayerClaimPosList>(64);
        claimsTag.forEach(t -> {
            class_2487 posListTag = (class_2487)t;
            class_2487 stateTag = posListTag.method_10562("state");
            class_2499 positionsTag = posListTag.method_10554("positions", 10);
            PlayerChunkClaim state = this.playerChunkClaimDataNbtSerializer.deserialize(playerId, stateTag);
            PlayerClaimPosList posList = PlayerClaimPosList.Builder.begin().setClaim(state).build();
            positionsTag.forEach(t2 -> {
                class_2487 posTag = (class_2487)t2;
                int x = posTag.method_10550("x");
                int z = posTag.method_10550("z");
                posList.add(x, z);
            });
            claimLists.put(state, posList);
        });
        return new PlayerDimensionClaims(playerId, new class_2960(dimension), claimLists);
    }

    public class_2487 serialize(PlayerDimensionClaims data) {
        class_2487 nbt = new class_2487();
        class_2499 claims = new class_2499();
        data.getTypedStream().forEach(posList -> {
            class_2487 posListTag = new class_2487();
            PlayerChunkClaim claim = posList.getClaimState();
            class_2487 stateTag = this.playerChunkClaimDataNbtSerializer.serialize(claim);
            posListTag.method_10566("state", (class_2520)stateTag);
            class_2499 positionsTag = new class_2499();
            posList.getStream().forEach(pos -> {
                class_2487 posTag = new class_2487();
                posTag.method_10569("x", pos.field_9181);
                posTag.method_10569("z", pos.field_9180);
                positionsTag.add((Object)posTag);
            });
            posListTag.method_10566("positions", (class_2520)positionsTag);
            claims.add((Object)posListTag);
        });
        nbt.method_10566("claims", (class_2520)claims);
        return nbt;
    }
}

