/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimOwnerPropertiesPacket
extends LazyPacket<ClientboundClaimOwnerPropertiesPacket> {
    public static final int MAX_PROPERTIES = 32;
    public static final LazyPacket.Encoder<ClientboundClaimOwnerPropertiesPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final List<PlayerProperties> properties;

    public ClientboundClaimOwnerPropertiesPacket(List<PlayerProperties> properties) {
        this.properties = properties;
    }

    @Override
    protected Function<class_2540, ClientboundClaimOwnerPropertiesPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(class_2540 dest) {
        class_2487 nbt = new class_2487();
        class_2499 propertiesListTag = new class_2499();
        for (int i = 0; i < this.properties.size(); ++i) {
            PlayerProperties propertiesEntry = this.properties.get(i);
            class_2487 propertiesEntryNbt = new class_2487();
            propertiesEntryNbt.method_25927("p", propertiesEntry.playerId);
            propertiesEntryNbt.method_10582("u", propertiesEntry.username);
            propertiesListTag.add((Object)propertiesEntryNbt);
        }
        nbt.method_10566("l", (class_2520)propertiesListTag);
        dest.method_10794(nbt);
    }

    public static class Decoder
    implements Function<class_2540, ClientboundClaimOwnerPropertiesPacket> {
        @Override
        public ClientboundClaimOwnerPropertiesPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 32768) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                class_2499 propertiesListTag = nbt.method_10554("l", 10);
                if (propertiesListTag.size() > 32) {
                    OpenPartiesAndClaims.LOGGER.info("Received claim owner properties list is too large!");
                    return null;
                }
                ArrayList<PlayerProperties> propertiesList = new ArrayList<PlayerProperties>(propertiesListTag.size());
                for (int i = 0; i < propertiesListTag.size(); ++i) {
                    class_2487 propertiesEntryNbt = propertiesListTag.method_10602(i);
                    String username = propertiesEntryNbt.method_10558("u");
                    if (username.isEmpty() || username.length() > 128) {
                        OpenPartiesAndClaims.LOGGER.info("Received claim owner properties list with invalid player username!");
                        return null;
                    }
                    UUID playerId = propertiesEntryNbt.method_25926("p");
                    propertiesList.add(new PlayerProperties(playerId, username));
                }
                return new ClientboundClaimOwnerPropertiesPacket(propertiesList);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class PlayerProperties {
        private final UUID playerId;
        private final String username;

        public PlayerProperties(UUID playerId, String username) {
            this.playerId = playerId;
            this.username = username;
        }

        public String toString() {
            return String.format("[%s, %s]", this.playerId, this.username);
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimOwnerPropertiesPacket> {
        @Override
        public void handle(ClientboundClaimOwnerPropertiesPacket t) {
            for (PlayerProperties propertiesEntry : t.properties) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onPlayerInfo(propertiesEntry.playerId, propertiesEntry.username);
            }
        }
    }
}

