/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyCommands;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class RankPartyCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<class_2168> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.ADMIN.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"member").requires(requirement)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rank").requires(requirement)).then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Arrays.asList(PartyMemberRank.values()).stream().map(r -> r.toString()), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PartyCommands.getPartyMemberSuggestor()).executes(context -> {
            String targetUsername;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerId);
            IPartyMemberAPI targetPlayerInfo = playerParty.getMemberInfo(targetUsername = StringArgumentType.getString((CommandContext)context, (String)"name"));
            if (targetPlayerInfo == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_member", targetUsername));
                return 0;
            }
            IPartyMemberAPI casterInfo = playerParty.getMemberInfo(playerId);
            boolean casterIsOwner = playerParty.getOwner() == casterInfo;
            IPartyMember targetMember = (IPartyMember)targetPlayerInfo;
            if (!casterIsOwner && targetMember.getRank().ordinal() >= casterInfo.getRank().ordinal() || targetMember == playerParty.getOwner()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_lower_rank_player", new Object[0]));
                return 0;
            }
            String targetRankString = StringArgumentType.getString((CommandContext)context, (String)"rank");
            PartyMemberRank targetRank = PartyMemberRank.valueOf(targetRankString);
            if (!casterIsOwner && targetRank.ordinal() >= casterInfo.getRank().ordinal()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_rank_not_lower_rank", new Object[0]));
                return 0;
            }
            playerParty.setRankTyped(targetMember, targetRank);
            UUID targetPlayerId = targetMember.getUUID();
            class_3222 rankedPlayer = server.method_3760().method_14602(targetPlayerId);
            if (rankedPlayer != null) {
                server.method_3734().method_9241(rankedPlayer);
            }
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_rank_party_message", (Object[])new Object[]{class_2561.method_43470((String)casterInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1077)), class_2561.method_43470((String)targetPlayerInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1054)), class_2561.method_43470((String)targetRank.toString()).method_27694(s -> s.method_10977(targetRank.getColor()))}));
            return 1;
        })))));
        dispatcher.register(command);
    }
}

