/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.result.api.ClaimResult;

public class ClientboundClaimResultPacket {
    private final AreaClaimResult result;

    public ClientboundClaimResultPacket(AreaClaimResult result) {
        this.result = result;
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimResultPacket> {
        @Override
        public void accept(ClientboundClaimResultPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimResult(t.result);
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundClaimResultPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ClientboundClaimResultPacket> {
        @Override
        public ClientboundClaimResultPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                byte[] resultTypesArray = tag.m_128463_("ta");
                HashSet<ClaimResult.Type> resultTypes = new HashSet<ClaimResult.Type>();
                for (byte ordinal : resultTypesArray) {
                    ClaimResult.Type resultType;
                    try {
                        resultType = ClaimResult.Type.values()[ordinal];
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        OpenPartiesAndClaims.LOGGER.error("illegal claim result id in packet", (Throwable)aioobe);
                        return null;
                    }
                    resultTypes.add(resultType);
                }
                int left = tag.m_128451_("l");
                int top = tag.m_128451_("t");
                int right = tag.m_128451_("r");
                int bottom = tag.m_128451_("b");
                return new ClientboundClaimResultPacket(new AreaClaimResult(resultTypes, left, top, right, bottom));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }

        @Override
        public void accept(ClientboundClaimResultPacket t, FriendlyByteBuf u) {
            CompoundTag tag = new CompoundTag();
            Iterator<ClaimResult.Type> iterator = t.result.getResultTypesIterable().iterator();
            byte[] resultTypes = new byte[t.result.getSize()];
            int index = 0;
            while (iterator.hasNext()) {
                resultTypes[index] = (byte)iterator.next().ordinal();
                ++index;
            }
            tag.m_128382_("ta", resultTypes);
            tag.m_128405_("l", t.result.getLeft());
            tag.m_128405_("t", t.result.getTop());
            tag.m_128405_("r", t.result.getRight());
            tag.m_128405_("b", t.result.getBottom());
            u.m_130079_(tag);
        }
    }
}

