/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class ClientboundSubClaimPropertiesPacket
extends LazyPacket<ClientboundSubClaimPropertiesPacket> {
    public static final int MAX_PROPERTIES = 32;
    public static final LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final List<SubClaimProperties> properties;

    public ClientboundSubClaimPropertiesPacket(List<SubClaimProperties> properties) {
        this.properties = properties;
    }

    @Override
    protected Function<class_2540, ClientboundSubClaimPropertiesPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(class_2540 dest) {
        class_2487 nbt = new class_2487();
        class_2499 propertiesListTag = new class_2499();
        for (int i = 0; i < this.properties.size(); ++i) {
            SubClaimProperties propertiesEntry = this.properties.get(i);
            class_2487 propertiesEntryNbt = new class_2487();
            XaeroNbtUtil.putUUID(propertiesEntryNbt, "p", propertiesEntry.playerId);
            propertiesEntryNbt.method_10569("i", propertiesEntry.subConfigIndex);
            if (propertiesEntry.claimsName != null) {
                propertiesEntryNbt.method_10582("n", propertiesEntry.claimsName);
            }
            if (propertiesEntry.claimsColor != null) {
                propertiesEntryNbt.method_10569("c", propertiesEntry.claimsColor.intValue());
            }
            propertiesListTag.add((Object)propertiesEntryNbt);
        }
        nbt.method_10566("l", (class_2520)propertiesListTag);
        dest.method_10794((class_2520)nbt);
    }

    public static class Decoder
    implements Function<class_2540, ClientboundSubClaimPropertiesPacket> {
        @Override
        public ClientboundSubClaimPropertiesPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 32768) {
                    return null;
                }
                class_2487 nbt = (class_2487)input.method_30616(class_2505.method_53898());
                if (nbt == null) {
                    return null;
                }
                class_2499 propertiesListTag = nbt.method_68569("l");
                if (propertiesListTag.size() > 32) {
                    OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list is too large!");
                    return null;
                }
                ArrayList<SubClaimProperties> propertiesList = new ArrayList<SubClaimProperties>(propertiesListTag.size());
                for (int i = 0; i < propertiesListTag.size(); ++i) {
                    class_2487 propertiesEntryNbt = propertiesListTag.method_68582(i);
                    String claimsName = propertiesEntryNbt.method_68564("n", "");
                    if (claimsName.length() > 128) {
                        OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list with invalid claims name!");
                        return null;
                    }
                    UUID playerId = XaeroNbtUtil.getUUID(propertiesEntryNbt, "p").orElse(null);
                    int subConfigIndex = propertiesEntryNbt.method_68083("i", 0);
                    Integer claimsColor = propertiesEntryNbt.method_10545("c") ? Integer.valueOf(propertiesEntryNbt.method_68083("c", 0)) : null;
                    propertiesList.add(new SubClaimProperties(playerId, subConfigIndex, claimsName, claimsColor));
                }
                return new ClientboundSubClaimPropertiesPacket(propertiesList);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class SubClaimProperties {
        private final UUID playerId;
        private final int subConfigIndex;
        private final String claimsName;
        private final Integer claimsColor;

        public SubClaimProperties(UUID playerId, int subConfigIndex, String claimsName, Integer claimsColor) {
            this.playerId = playerId;
            this.subConfigIndex = subConfigIndex;
            this.claimsName = claimsName;
            this.claimsColor = claimsColor;
        }

        public String toString() {
            return String.format("[%s, %d, %s, %d]", this.playerId, this.subConfigIndex, this.claimsName, this.claimsColor);
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundSubClaimPropertiesPacket> {
        @Override
        public void handle(ClientboundSubClaimPropertiesPacket t) {
            for (SubClaimProperties propertiesEntry : t.properties) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onSubClaimInfo(propertiesEntry.playerId, propertiesEntry.subConfigIndex, propertiesEntry.claimsName, propertiesEntry.claimsColor);
            }
        }
    }
}

