/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player.request;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.request.ClaimActionRequest;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.result.api.ClaimResult;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.ServerTickHandler;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;

public class PlayerClaimActionRequestHandler {
    private final ServerClaimsManager manager;
    private final ServerTickHandler serverTickHandler;
    private long lastRequestTickCounter;

    private PlayerClaimActionRequestHandler(ServerClaimsManager manager, ServerTickHandler serverTickHandler) {
        this.manager = manager;
        this.serverTickHandler = serverTickHandler;
    }

    public void onReceive(class_3222 player, ClaimActionRequest request) {
        if (this.serverTickHandler.getTickCounter() == this.lastRequestTickCounter) {
            return;
        }
        ServerPlayerData playerData = (ServerPlayerData)ServerPlayerDataAPI.from(player);
        boolean shouldServerClaim = request.isByServer();
        if (playerData.isClaimsServerMode()) {
            shouldServerClaim = true;
        }
        if (shouldServerClaim && this.manager.getPermissionHandler().shouldPreventServerClaim(player, playerData, player.method_5682())) {
            this.manager.getClaimsManagerSynchronizer().syncToPlayerClaimActionResult(new AreaClaimResult(Set.of(ClaimResult.Type.NO_SERVER_PERMISSION), request.getLeft(), request.getTop(), request.getRight(), request.getBottom()), player);
            return;
        }
        this.manager.getPermissionHandler().ensureAdminModeStatusPermission(player, playerData);
        UUID playerId = shouldServerClaim ? PlayerConfig.SERVER_CLAIM_UUID : player.method_5667();
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.method_5682());
        IPlayerConfig playerConfig = serverData.getPlayerConfigs().getLoadedConfig(player.method_5667());
        IPlayerConfig usedSubConfig = shouldServerClaim ? playerConfig.getUsedServerSubConfig() : playerConfig.getUsedSubConfig();
        int subConfigIndex = usedSubConfig.getSubIndex();
        int fromX = player.method_31476().field_9181;
        int fromZ = player.method_31476().field_9180;
        AreaClaimResult result = this.manager.tryClaimActionOverArea(player.method_51469().method_27983().method_29177(), playerId, subConfigIndex, fromX, fromZ, request.getLeft(), request.getTop(), request.getRight(), request.getBottom(), request.getAction(), playerData.isClaimsAdminMode());
        this.manager.getClaimsManagerSynchronizer().syncToPlayerClaimActionResult(result, player);
        this.lastRequestTickCounter = this.serverTickHandler.getTickCounter();
    }

    public long getLastRequestTickCounter() {
        return this.lastRequestTickCounter;
    }

    public void setLastRequestTickCounter(long lastRequestTickCounter) {
        this.lastRequestTickCounter = lastRequestTickCounter;
    }

    public static final class Builder {
        private ServerClaimsManager manager;
        private ServerTickHandler serverTickHandler;

        private Builder() {
        }

        private Builder setDefault() {
            this.setManager(null);
            this.setServerTickHandler(null);
            return this;
        }

        public Builder setManager(IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>> manager) {
            this.manager = (ServerClaimsManager)manager;
            return this;
        }

        public Builder setServerTickHandler(ServerTickHandler serverTickHandler) {
            this.serverTickHandler = serverTickHandler;
            return this;
        }

        public PlayerClaimActionRequestHandler build() {
            if (this.manager == null || this.serverTickHandler == null) {
                throw new IllegalStateException();
            }
            return new PlayerClaimActionRequestHandler(this.manager, this.serverTickHandler);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

