/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import xaero.pac.common.server.player.permission.api.UsedPermissionNodes;

public class ServerConfig {
    public final ModConfigSpec.ConfigValue<String> defaultLanguage;
    public final ModConfigSpec.BooleanValue partiesEnabled;
    public final ModConfigSpec.BooleanValue claimsEnabled;
    public final ModConfigSpec.IntValue autosaveInterval;
    public final ModConfigSpec.IntValue playerSubConfigLimit;
    public final ModConfigSpec.IntValue partyExpirationTime;
    public final ModConfigSpec.IntValue partyExpirationCheckInterval;
    public final ModConfigSpec.ConfigValue<List<? extends String>> opConfigurablePlayerConfigOptions;
    public final ModConfigSpec.ConfigValue<List<? extends String>> playerConfigurablePlayerConfigOptions;
    public final ModConfigSpec.EnumValue<ConfigListType> friendlyChunkProtectedEntityListType;
    public final ModConfigSpec.ConfigValue<List<? extends String>> friendlyChunkProtectedEntityList;
    public final ModConfigSpec.EnumValue<ConfigListType> hostileChunkProtectedEntityListType;
    public final ModConfigSpec.ConfigValue<List<? extends String>> hostileChunkProtectedEntityList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> blockProtectionExceptionList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityProtectionExceptionList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityClaimBarrierList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> forcedBlockProtectionExceptionList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> blockProtectionOptionalExceptionGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> forcedEntityProtectionExceptionList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityProtectionOptionalExceptionGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> forcedEntityClaimBarrierList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityClaimBarrierOptionalGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entitiesAllowedToGrief;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entitiesAllowedToGriefEntities;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entitiesAllowedToGriefDroppedItems;
    public final ModConfigSpec.ConfigValue<List<? extends String>> nonBlockGriefingMobs;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityGriefingMobs;
    public final ModConfigSpec.ConfigValue<List<? extends String>> droppedItemGriefingMobs;
    public final ModConfigSpec.ConfigValue<List<? extends String>> blockAccessEntityGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> entityAccessEntityGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> droppedItemAccessEntityGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> staticFakePlayers;
    public final ModConfigSpec.ConfigValue<List<? extends String>> staticFakePlayerClassExceptions;
    public final ModConfigSpec.ConfigValue<List<? extends String>> additionalBannedItemsList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> itemUseProtectionExceptionList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> itemUseProtectionOptionalExceptionGroups;
    public final ModConfigSpec.ConfigValue<List<? extends String>> completelyDisabledItemInteractions;
    public final ModConfigSpec.ConfigValue<List<? extends String>> completelyDisabledBlockInteractions;
    public final ModConfigSpec.ConfigValue<List<? extends String>> completelyDisabledEntityInteractions;
    public final ModConfigSpec.BooleanValue alwaysProtectBlocksFromEnchantments;
    public final ModConfigSpec.BooleanValue reducedBoatEntityCollisions;
    public final ModConfigSpec.IntValue maxClaimDistance;
    public final ModConfigSpec.ConfigValue<List<? extends String>> claimableDimensionsList;
    public final ModConfigSpec.EnumValue<ConfigListType> claimableDimensionsListType;
    public final ModConfigSpec.BooleanValue allowExistingClaimsInUnclaimableDimensions;
    public final ModConfigSpec.BooleanValue allowExistingForceloadsInUnclaimableDimensions;
    public final ModConfigSpec.IntValue maxPlayerClaims;
    public final ModConfigSpec.IntValue maxPlayerClaimForceloads;
    public final ModConfigSpec.IntValue maxPartyMembers;
    public final ModConfigSpec.IntValue maxPartyAllies;
    public final ModConfigSpec.IntValue maxPartyInvites;
    public final ModConfigSpec.IntValue playerClaimsExpirationTime;
    public final ModConfigSpec.IntValue playerClaimsExpirationCheckInterval;
    public final ModConfigSpec.BooleanValue playerClaimsConvertExpiredClaims;
    public final ModConfigSpec.EnumValue<ClaimsSyncType> claimsSynchronization;
    public final ModConfigSpec.BooleanValue claimWelcomeMessages;
    public final ModConfigSpec.ConfigValue<String> maxPlayerClaimsPermission;
    public final ModConfigSpec.ConfigValue<String> maxPlayerClaimForceloadsPermission;
    public final ModConfigSpec.ConfigValue<String> serverClaimPermission;
    public final ModConfigSpec.ConfigValue<String> adminModePermission;
    public final ModConfigSpec.ConfigValue<String> permissionSystem;
    public final ModConfigSpec.ConfigValue<String> primaryPartySystem;
    public static final ModConfigSpec SPEC;
    public static final ServerConfig CONFIG;

    private ServerConfig(ModConfigSpec.Builder builder) {
        builder.push("serverConfig");
        this.defaultLanguage = builder.comment("The default language used for server-side localization for players that don't have the mod installed.").translation("gui.xaero_pac_config_default_language").worldRestart().define("defaultLanguage", (Object)"en_us");
        this.autosaveInterval = builder.comment("How often to auto-save modified data, e.g. parties, claims, player configs (in minutes).").translation("gui.xaero_pac_config_autosave_interval").worldRestart().defineInRange("autosaveInterval", 10, 1, Integer.MAX_VALUE);
        this.playerSubConfigLimit = builder.comment("How many sub-configs (sub-claims) can each player create.").translation("gui.xaero_pac_config_player_subconfig_limit").worldRestart().defineInRange("playerSubConfigLimit", 64, 0, 1024);
        this.permissionSystem = builder.comment("The permission system to use for everything that requires permission checks (e.g. permission_api, ftb_ranks, luck_perms, prometheus). Non-built-in permission systems can be registered through the API with an addon.").translation("gui.xaero_pac_config_permission_system").worldRestart().define("permissionSystem", (Object)"prometheus");
        this.primaryPartySystem = builder.comment("The player party system to prefer and use for anything that can't support multiple systems (e.g. default, ftb_teams, argonauts, argonauts_guilds). Non-built-in party systems can be registered through the API with an addon.").translation("gui.xaero_pac_config_primary_party_system").worldRestart().define("primaryPartySystem", (Object)"argonauts_guilds");
        builder.push("parties");
        this.partiesEnabled = builder.comment("Whether the parties part of this mod is enabled.").translation("gui.xaero_pac_config_parties_enabled").worldRestart().define("enabled", true);
        this.maxPartyMembers = builder.comment("The maximum number of members in a party. Existing members are not removed if the limit is reduced.").translation("gui.xaero_pac_config_party_max_members").worldRestart().defineInRange("maxPartyMembers", 64, 1, Integer.MAX_VALUE);
        this.maxPartyAllies = builder.comment("The maximum number of allies for a party. Existing allies are not removed if the limit is reduced.").translation("gui.xaero_pac_config_party_max_allies").worldRestart().defineInRange("maxPartyAllies", 64, 0, Integer.MAX_VALUE);
        this.maxPartyInvites = builder.comment("The maximum number of invites to a party. Existing invites are not removed if the limit is reduced.").translation("gui.xaero_pac_config_party_max_invites").worldRestart().defineInRange("maxPartyInvites", 16, 1, Integer.MAX_VALUE);
        this.partyExpirationTime = builder.comment("For how long a party (members) can stay completely inactive on the server until it is deleted (in hours). This improves performance for servers running for years.").translation("gui.xaero_pac_config_party_expiration_time").worldRestart().defineInRange("partyExpirationTime", 720, 1, Integer.MAX_VALUE);
        this.partyExpirationCheckInterval = builder.comment("How often to check for expired parties in order to remove them (in minutes). The interval is effectively rounded up to a multiple of 10 minutes.").translation("gui.xaero_pac_config_party_expiration_check_interval").worldRestart().defineInRange("partyExpirationCheckInterval", 360, 10, Integer.MAX_VALUE);
        builder.pop();
        builder.push("claims");
        this.claimsEnabled = builder.comment("Whether the claims part of this mod is enabled.").translation("gui.xaero_pac_config_claims_enabled").worldRestart().define("enabled", true);
        this.playerClaimsExpirationTime = builder.comment("For how long a player can stay completely inactive on the server until their claims are expired (in hours). This improves performance for servers running for years.").translation("gui.xaero_pac_config_claims_expiration_time").worldRestart().defineInRange("playerClaimsExpirationTime", 8760, 1, Integer.MAX_VALUE);
        this.playerClaimsExpirationCheckInterval = builder.comment("How often to check for expired player chunk claims in order to remove them (in minutes). The interval is effectively rounded up to a multiple of 10 minutes.").translation("gui.xaero_pac_config_claims_expiration_check_interval").worldRestart().defineInRange("playerClaimsExpirationCheckInterval", 360, 10, Integer.MAX_VALUE);
        this.playerClaimsConvertExpiredClaims = builder.comment("Whether to convert expired player chunk claims to \"expired claims\" instead of completely freeing them. This shouldn't be too bad for performance because it still reduces the number of unique claims.").translation("gui.xaero_pac_config_keep_expired_claims").worldRestart().define("playerClaimsConvertExpiredClaims", true);
        this.maxPlayerClaims = builder.comment("The maximum number of chunks that a player can claim. Additional claims can be configured in the player config.\nThis value can be overridden with a player permission.").translation("gui.xaero_pac_config_max_player_claims").worldRestart().defineInRange("maxPlayerClaims", 500, 0, Integer.MAX_VALUE);
        this.maxPlayerClaimForceloads = builder.comment("The maximum number of claimed chunks that a player can forceload. Additional forceloads can be configured in the player config.\nThis value can be overridden with a player permission.").translation("gui.xaero_pac_config_max_player_forceloads").worldRestart().defineInRange("maxPlayerClaimForceloads", 10, 0, Integer.MAX_VALUE);
        this.maxPlayerClaimsPermission = builder.comment("The permission that should override the default \"maxPlayerClaims\" value. Set it to an empty string to never check permissions. The used permission system can be configured with \"permissionSystem\".").translation("gui.xaero_pac_config_max_claims_permission").worldRestart().define("maxPlayerClaimsPermission", (Object)UsedPermissionNodes.MAX_PLAYER_CLAIMS.getDefaultNodeString());
        this.maxPlayerClaimForceloadsPermission = builder.comment("The permission that should override the default \"maxPlayerClaimForceloads\" value. Set it to an empty string to never check permissions.\nThe permission override only takes effect after the player logs in at least once after a server (re)launch, so it is recommended to keep all permission-based forceload limits equal to or greater than \"maxPlayerClaimForceloads\".\nThe used permission system can be configured with \"permissionSystem\".").translation("gui.xaero_pac_config_max_forceloads_permission").worldRestart().define("maxPlayerClaimForceloadsPermission", (Object)UsedPermissionNodes.MAX_PLAYER_FORCELOADS.getDefaultNodeString());
        this.serverClaimPermission = builder.comment("The permission that gives non-OP players the ability to make server claims and enable server claim mode. The used permission system can be configured with \"permissionSystem\".").translation("gui.xaero_pac_config_server_claim_permission").worldRestart().define("serverClaimPermission", (Object)UsedPermissionNodes.SERVER_CLAIMS.getDefaultNodeString());
        this.adminModePermission = builder.comment("The permission that gives non-OP players the ability to enable claim admin mode. The used permission system can be configured with \"permissionSystem\".").translation("gui.xaero_pac_config_admin_mode_permission").worldRestart().define("adminModePermission", (Object)UsedPermissionNodes.ADMIN_MODE.getDefaultNodeString());
        this.maxClaimDistance = builder.comment("The maximum distance on the X or Z axis (forming a square) that a chunk can be claimed at by a player.").translation("gui.xaero_pac_config_max_claim_distance").worldRestart().defineInRange("maxClaimDistance", 5, 0, Integer.MAX_VALUE);
        this.claimableDimensionsListType = builder.comment("The type of the list defined in \"claimableDimensionsList\". ONLY - include only the listed dimensions. ALL_BUT - include all but the listed dimensions.").translation("gui.xaero_pac_config_claimable_dimensions_list_type").worldRestart().defineEnum("claimableDimensionsListType", (Enum)ConfigListType.ALL_BUT);
        this.claimableDimensionsList = builder.comment("Dimensions to include/exclude from being claimable, depending on the list type in \"claimableDimensionsListType\".\nFor example [\"minecraft:overworld\", \"minecraft:the_nether\"].\nBy default the list is empty and of type ALL_BUT, meaning that all dimensions are claimable.").translation("gui.xaero_pac_config_claimable_dimensions_list").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"claimableDimensionsList"}), ArrayList::new, s -> s instanceof String);
        this.allowExistingClaimsInUnclaimableDimensions = builder.comment("Whether to allow existing player claims to stay active in unclaimable dimensions which were previously claimable.").translation("gui.xaero_pac_config_allow_existing_claims_in_unclaimable_dims").worldRestart().define("allowExistingClaimsInUnclaimableDimensions", true);
        this.allowExistingForceloadsInUnclaimableDimensions = builder.comment("Whether to allow existing player forceloads to stay active in unclaimable dimensions which were previously claimable. Only relevant if existing claims are allowed.").translation("gui.xaero_pac_config_allow_existing_forceloads_in_unclaimable_dims").worldRestart().define("allowExistingForceloadsInUnclaimableDimensions", false);
        this.claimsSynchronization = builder.comment("Whether to synchronize world chunk claims to the game clients. Enables client-side mods to access the claims data, e.g. to display it on a map.\nALL - all claims are synced. OWNED_ONLY - only the claims that the client player owns and server claims are synced. NOT_SYNCED - claims are not synced.").translation("gui.xaero_pac_config_claims_synchronization").worldRestart().defineEnum("claimsSynchronization", (Enum)ClaimsSyncType.ALL);
        this.claimWelcomeMessages = builder.comment("Whether to display \"welcome\" messages when a player enters a claim or wilderness. Not recommended to turn off unless you have another mod handling this.").translation("gui.xaero_pac_config_claim_welcome_messages").worldRestart().define("claimWelcomeMessages", true);
        builder.push("protection");
        this.friendlyChunkProtectedEntityListType = builder.comment("The type of the list defined in \"friendlyChunkProtectedEntityList\". ONLY - include only the listed entities. ALL_BUT - include all but the listed entities.").translation("gui.xaero_pac_config_friendly_protected_entities_list_type").worldRestart().defineEnum("friendlyChunkProtectedEntityListType", (Enum)ConfigListType.ALL_BUT);
        this.friendlyChunkProtectedEntityList = builder.comment("Friendly entities to fully include/exclude in chunk protection, depending on the list type in \"friendlyChunkProtectedEntityListType\". Supports entity type tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"*:villager\", \"minecraft:m(ule|ooshroom)\", \"#minecraft:axolotl_hunt_targets\"].\nBy default the list is empty with the type set to ALL_BUT, which means that all friendly entities are included.").translation("gui.xaero_pac_config_friendly_protected_entities").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"friendlyChunkProtectedEntityList"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:boat"}), s -> s instanceof String);
        this.hostileChunkProtectedEntityListType = builder.comment("The type of the list defined in \"hostileChunkProtectedEntityList\". ONLY - include only the listed entities. ALL_BUT - include all but the listed entities.").translation("gui.xaero_pac_config_hostile_protected_entities_list_type").worldRestart().defineEnum("hostileChunkProtectedEntityListType", (Enum)ConfigListType.ONLY);
        this.hostileChunkProtectedEntityList = builder.comment("Hostile entities to fully include/exclude in chunk protection, depending on the list type in \"hostileChunkProtectedEntityListType\". Supports entity type tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(|wither_)skeleton\", \"minecraft:zombie(_villager|)\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_hostile_protected_entities").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"hostileChunkProtectedEntityList"}), ArrayList::new, s -> s instanceof String);
        this.blockProtectionExceptionList = builder.comment("No longer a working option. Please transfer anything you still have here to \"forcedBlockProtectionExceptionList\" or \"blockProtectionOptionalExceptionGroups\",\nbut keep in mind that those options work differently and please read their comments.\nThis option will be completely removed on the full release of the mod.").translation("gui.xaero_pac_config_block_protection_exception").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"blockProtectionExceptionList"}), Lists::newArrayList, s -> s instanceof String);
        this.entityProtectionExceptionList = builder.comment("No longer a working option. Please transfer anything you still have here to \"forcedEntityProtectionExceptionList\" or \"entityProtectionOptionalExceptionGroups\",\nbut keep in mind that those options work differently and please read their comments.\nThis option will be completely removed on the full release of the mod.").translation("gui.xaero_pac_config_entity_protection_exception").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityProtectionExceptionList"}), Lists::newArrayList, s -> s instanceof String);
        this.entityClaimBarrierList = builder.comment("No longer a working option. Please transfer anything you still have here to \"forcedEntityClaimBarrierList\" or \"entityClaimBarrierOptionalGroups\",\nbut keep in mind that those options work differently and please read their comments.\nThis option will be completely removed on the full release of the mod.").translation("gui.xaero_pac_config_entity_claim_barrier_list").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityClaimBarrierList"}), Lists::newArrayList, s -> s instanceof String);
        this.forcedBlockProtectionExceptionList = builder.comment("Blocks to partially exclude from chunk protection. Supports block tags.\nJust a block/tag ID in the list, e.g. \"minecraft:lever\" allows block interaction across the server if the item in the used hand isn't blocking it.\nPrefix \"hand$\" is the same as no prefix but enforces an empty hand requirement in protected chunks. Prefix \"break$\" allows breaking the block(s).\nPrefix \"anything$\" is the same as no prefix but allows interaction with any item held in the hand. Please make sure that no item does anything bad when used at a block with such an exception.\nAdd the same block/tag multiple times to use multiple prefixes. Supports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:lever\", \"minecraft:*_button\", \"break$minecraft:*_button\", \"break$minecraft:(*_|)sand\"]").translation("gui.xaero_pac_config_block_protection_forced_exception").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"forcedBlockProtectionExceptionList"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:crafting_table"}), s -> s instanceof String);
        this.blockProtectionOptionalExceptionGroups = builder.comment("Custom groups of blocks that a player/claim config should be able to make protection exceptions for. Each group can consist of multiple blocks and block tags.\nA group without a prefix creates a player config option for the right-click interaction with the group blocks. The format for a block group is <group ID>{<blocks/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-DIRT35{minecraft:dirt, minecraft:grass_block, minecraft:(oak|spruce)_*}\".\nA group can be prefixed with \"hand$\" to create an option for the right-click interaction with an enforced empty hand requirement or \"break$\" for breaking the group blocks.\nMoreover, prefix \"anything$\" creates an option for the right-click interaction with any item held in the hand, not just allowed items. Please make sure that no item does anything\nbad when used at a block with such an exception.\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_block_protection_exception_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"blockProtectionOptionalExceptionGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Controls{minecraft:lever, #minecraft:buttons}", "Doors{#minecraft:doors, #minecraft:fence_gates, #forge:fence_gates, #minecraft:trapdoors}", "Chests{minecraft:chest, minecraft:trapped_chest, #forge:chests/wooden}", "Barrels{minecraft:barrel, #forge:barrels}", "Ender_Chests{minecraft:ender_chest, #forge:chests/ender}", "Shulker_Boxes{#minecraft:shulker_boxes}", "Furnaces{minecraft:furnace, minecraft:blast_furnace, minecraft:smoker}", "Hoppers{minecraft:hopper}", "Dispenser-like{minecraft:dispenser, minecraft:dropper}", "Anvils{#minecraft:anvil}", "Beds{#minecraft:beds}", "Beacons{minecraft:beacon}", "Enchanting_Tables{minecraft:enchanting_table}", "break$Crops{#minecraft:crops}"}), s -> s instanceof String);
        this.forcedEntityProtectionExceptionList = builder.comment("Entities to partially exclude from chunk protection. Supports entity type tags.\nJust an entity/tag ID in the list, e.g. \"minecraft:horse\" allows entity interaction across the server if the item in the used hand isn't blocking it.\nPrefix \"hand$\" is the same as no prefix but enforces an empty hand requirement in protected chunks. Prefix \"break$\" allows killing the entities across the server.\nPrefix \"anything$\" is the same as no prefix but allows interaction with any item held in the hand. Please make sure that no item does anything bad when used at an entity with such an exception.\nAdd the same entity/tag multiple times to use multiple prefixes. Supports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:villager\", \"break$minecraft:villager\", \"break$minecraft:(trader_|)llama\"]").translation("gui.xaero_pac_config_entity_protection_forced_exception").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"forcedEntityProtectionExceptionList"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:minecart"}), s -> s instanceof String);
        this.entityProtectionOptionalExceptionGroups = builder.comment("Custom groups of entities that a player/claim config should be able to make protection exceptions for. Each group can consist of multiple entities and entity tags.\nA group without a prefix creates a player config option for the right-click interaction with the group entities. The format for an entity group is <group ID>{<entities/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-GUYS98{minecraft:pig, minecraft:c(ow|at), #minecraft:beehive_inhabitors}\".\nA group can be prefixed with \"hand$\" to create an option for the right-click interaction with an enforced empty hand requirement or \"break$\" for destroying the group entities.\nMoreover, prefix \"anything$\" creates an option for the right-click interaction with any item held in the hand, not just allowed items. Please make sure that no item does anything\nbad when used at an entity with such an exception.\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_entity_protection_exception_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityProtectionOptionalExceptionGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Traders{minecraft:villager, minecraft:wandering_trader}", "hand$Item_Frames{minecraft:item_frame}", "break$Livestock{minecraft:cow, minecraft:mooshroom, minecraft:sheep, minecraft:chicken, minecraft:pig, minecraft:rabbit, minecraft:goat}", "Armor_Stands{minecraft:armor_stand}"}), s -> s instanceof String);
        this.forcedEntityClaimBarrierList = builder.comment("Entities that are prevented from entering the claim. Supports entity type tags. An entity/tag ID in the list, e.g. \"minecraft:falling_block\" prevents the entities from entering.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR. For example: \"minecraft:zombie(_villager|)\".").translation("gui.xaero_pac_config_entity_forced_claim_barrier_list").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"forcedEntityClaimBarrierList"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:falling_block", "supplementaries:slingshot_projectile"}), s -> s instanceof String);
        this.entityClaimBarrierOptionalGroups = builder.comment("Custom groups of entities that a player/claim config should be able to enable a barrier for. Each group can consist of multiple entities and entity tags.\nEach group creates a player config option for controlling the entity barrier. The format for a entity group is <group ID>{<entities/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-GUYS98{#minecraft:raiders, minecraft:zombie(_villager|)}\".\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_entity_claim_barrier_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityClaimBarrierOptionalGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Players{minecraft:player}", "Ender_Pearls{minecraft:ender_pearl}"}), s -> s instanceof String);
        this.entitiesAllowedToGrief = builder.comment("Entities that can bypass all block protection. Supports entity type tags.\nPrefixing an entity id/tag with \"interact$\" creates an exception which tries to exclude block breaking.\nPrefixing an entity id/tag with \"break$\" creates an exception that only includes block breaking.\nLeaving an entity id/tag without a prefix creates an exception that includes all block interactions.\nProjectiles landing on blocks is considered a non-breaking interaction first, even if it can result in a block break,\nwhich is protected separately afterwards.\nProjectile landing on blocks requires non-break block access through this option or blockAccessEntityGroups.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_entities_allowed_to_grief").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entitiesAllowedToGrief"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:sheep", "interact$minecraft:potion", "interact$minecraft:trident", "interact$minecraft:(*_|)arrow", "interact$minecraft:ender_pearl", "interact$minecraft:egg"}), s -> s instanceof String);
        this.entitiesAllowedToGriefEntities = builder.comment("Entities that can bypass all protection of other entities. Supports entity type tags.\nPrefixing an entity id/tag with \"interact$\" creates an exception which tries to exclude attacks.\nPrefixing an entity id/tag with \"break$\" creates an exception that only includes attacks.\nLeaving an entity id/tag without a prefix creates an exception that includes all entity interactions.\nProjectiles landing on entities is considered a non-attack interaction first, even if it can result in an attack,\nwhich is protected separately afterwards.\nProjectile landing on entities requires non-attack entity access through this option or entityAccessEntityGroups.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_entities_allowed_to_grief_entities").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entitiesAllowedToGriefEntities"}), () -> Lists.newArrayList((Object[])new String[]{"interact$minecraft:potion", "interact$minecraft:trident", "interact$minecraft:(*_|)arrow", "interact$minecraft:ender_pearl", "interact$minecraft:egg"}), s -> s instanceof String);
        this.entitiesAllowedToGriefDroppedItems = builder.comment("Entities that can bypass all dropped item protection. Supports entity type tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_entities_allowed_to_grief_items").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entitiesAllowedToGriefDroppedItems"}), Lists::newArrayList, s -> s instanceof String);
        this.nonBlockGriefingMobs = builder.comment("(Forge-only option) Mobs that can grief entities/items but not blocks. This list is used when overriding the vanilla \"mob griefing\" game rule value.\nBy default, the mod assumes that any \"mob griefing\" game rule check is meant for block protection.\nThis means that the \"Protect Blocks From Mobs\" option might cause entity or item protection, if that's what the mob is trying to affect.\nBy adding a mob to this list, you're removing the block protection check for it during the \"mob griefing\" game rule check.\nSupports entity type tags. Supports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:*illager\", \"minecraft:(v|p)illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_non_block_griefers").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"nonBlockGriefingMobs"}), Lists::newArrayList, s -> s instanceof String);
        this.entityGriefingMobs = builder.comment("(Forge-only option) Mobs that can grief entities in ways other than attacking them, e.g. how evokers can change the color of sheep. This list is used when overriding the vanilla \"mob griefing\" game rule value.\nBy default, the mod assumes that any \"mob griefing\" game rule check is meant for block protection only. Add a mob to this list if you want the entity protection option to be checked as well when the rule is checked.\nCheck out the \"nonBlockGriefingMobs\" option if you want to also remove the default block protection check for the mob.\nSupports entity type tags. Supports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_entity_griefers").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityGriefingMobs"}), Lists::newArrayList, s -> s instanceof String);
        this.droppedItemGriefingMobs = builder.comment("(Forge-only option) Mobs that can grief dropped items. This list is used when overriding the vanilla \"mob griefing\" game rule value.\nBy default, the mod assumes that any \"mob griefing\" game rule check is meant for block protection only. Add a mob to this list if you want the item pickup protection option to be checked as well when the rule is checked.\nThis mod should detect most mobs picking up items by default, but if it doesn't already detect a specific mob, this option might help.\nCheck out the \"nonBlockGriefingMobs\" option if you want to also remove the default block protection check for the mob.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_gropped_item_griefers").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"droppedItemGriefingMobs"}), Lists::newArrayList, s -> s instanceof String);
        this.blockAccessEntityGroups = builder.comment("Custom groups of entities that a player/claim config should be able to make block access exceptions for (e.g. letting sheep eat grass or endermen take blocks). Each group can consist of multiple entities and entity tags.\nThe format for an entity group is <group ID>{<entities/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-GUYS98{minecraft:pig, minecraft:c(ow|at), #minecraft:beehive_inhabitors}\".\nThe group can be prefixed with \"interact$\" to create an exception that tries to exclude block breaking.\nThe group can be prefixed with \"break$\" to create an exception that only includes block breaking.\nThe group can be left without a prefix to create an exception that includes all block interactions.\nProjectiles landing on blocks is considered a non-breaking interaction first, even if it can result in a block break,\nwhich is protected separately afterwards.\nProjectile landing on blocks requires non-break block access through this option or entitiesAllowedToGrief.\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_block_access_entity_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"blockAccessEntityGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Villagers{minecraft:villager}"}), s -> s instanceof String);
        this.entityAccessEntityGroups = builder.comment("Custom groups of entities that a player/claim config should be able to make entity access exceptions for (e.g. letting zombies kill things).\nThe groups should consist of entities that are the ones accessing other entities. The groups should not contain entities that are being accessed. Check out the \"entityProtectionOptionalExceptionGroups\" option for that.\nEach group can consist of multiple entities and entity tags. The format for an entity group is <group ID>{<entities/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-GUYS98{minecraft:pig, minecraft:c(ow|at), #minecraft:beehive_inhabitors}\".\nThe group can be prefixed with \"interact$\" to create an exception that tries to exclude attacks.\nThe group can be prefixed with \"break$\" to create an exception that only includes attacks.\nThe group can be left without a prefix to create an exception that includes all entity interactions.\nProjectiles landing on entities is considered a non-attack interaction first, even if it can result in an attack,\nwhich is protected separately afterwards.\nProjectile landing on entities requires non-attack entity access through this option or entitiesAllowedToGriefEntities.\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_entity_access_entity_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"entityAccessEntityGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Zombies{minecraft:zombie, minecraft:zombie_villager, minecraft:husk, minecraft:drowned}"}), s -> s instanceof String);
        this.droppedItemAccessEntityGroups = builder.comment("Custom groups of entities that a player/claim config should be able to make dropped item access exceptions for (e.g. letting piglins pick up gold).\nThe groups should consist of entities that are the ones trying to pick up items, not consist of specific items.\nEach group can consist of multiple entities and entity tags. The format for an entity group is <group ID>{<entities/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-GUYS98{minecraft:pig, minecraft:c(ow|at), #minecraft:beehive_inhabitors}\".\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_dropped_item_access_entity_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"droppedItemAccessEntityGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Villagers{minecraft:villager}", "Piglins{minecraft:piglin}", "Foxes{minecraft:fox}"}), s -> s instanceof String);
        this.staticFakePlayers = builder.comment("A list of fake players (UUIDs or names) that shouldn't be affected by any chunk claim protection if they try to access a chunk with building protection compatible with\nthe chunk that the fake player's origin block is positioned in, e.g. claims with the same owner and block protection option values.\nThis works great for fake players that are bound to the position of a specific placed block (origin block). Moreover, the mod supports fake players placed at a block\nnext to the origin block, even if that means entering another chunk, e.g. in the case of the Integrated Tunnels mod, or if the origin block is touching the target block.\nThe mod will try all positions next to the target block and the fake player as the possible position of the fake player origin block.\nThis will always protect the target block if it or the fake player touch a claim with incompatible build protection. Avoid building on such claim edges.\nHowever, some fake players' origin blocks can be nowhere near the fake player or the target block, e.g. in the case of the Create mod, or there might be no origin block at all,\ne.g. NPCs that can move around. In this case, the mods that use such fake players require explicit support to be implemented. Although they might also sometimes\nbe supported by default, if the fake players use UUIDs of actual players.\nExplicit support exists for the Create mod (requires an extension on Fabric) and you are not required to add anything to this list.\nMake sure to always test that claim edges are protected from outside interaction by fake players that you add to this list.\nWondering where to get the UUIDs or usernames of specific fake players? You can check the source code of the mods that use them or politely ask the mod authors.\nFor example [\"41C82C87-7AfB-4024-BB57-13D2C99CAE77\", \"FakePlayerName\"]").translation("gui.xaero_pac_config_static_fake_players").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"staticFakePlayers"}), () -> Lists.newArrayList((Object[])new String[]{"[IntegratedTunnels]"}), s -> s instanceof String);
        this.staticFakePlayerClassExceptions = builder.comment("A list of Java classes of fake players that should be excluded from claim protection exceptions given to fake players with the \"staticFakePlayers\" option\nor built-in fake player support, like in the case of Create mod deployers.\nThis option is meant for fake players similar to ComputerCraft's turtles, which take the UUID of the player that places them. It becomes a problem when a turtle takes\nthe UUID of a fake player from \"staticFakePlayers\" or a deployer because the turtle then gets the same privileges without actually being stationary itself nor a deployer.\nAdding classes here should not break support of fake players that take the UUID of their owner. It simply takes away privileges which aren't meant for them.\nFor example [\"dan200.computercraft.shared.turtle.core.TurtlePlayer\"]").translation("gui.xaero_pac_config_static_fake_player_class_exceptions").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"staticFakePlayerClassExceptions"}), () -> Lists.newArrayList((Object[])new String[]{"dan200.computercraft.shared.turtle.core.TurtlePlayer"}), s -> s instanceof String);
        this.additionalBannedItemsList = builder.comment("By default, right-click use of some items is allowed in protected chunks, e.g. swords, pickaxes, bows, shield, tridents, splash potions, to let the players protect themselves or interact with some blocks/entities.\nTo remove such exceptions for specific items, add them to this list. This list applies to both using an item at air and using it at a block/entity. Supports item tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:trident\", \"minecraft:shield\", \"minecraft:(oak|spruce)_boat\", \"#minecraft:boats\"]").translation("gui.xaero_pac_config_banned_item_list").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"additionalBannedItemsList"}), () -> Lists.newArrayList((Object[])new String[]{"supplementaries:slingshot"}), s -> s instanceof String);
        this.itemUseProtectionExceptionList = builder.comment("By default, most item right-click uses are disabled in protected chunks. To make an exception for a specific item, add it to this list. This option has a higher priority than \"additionalBannedItemsList\".\nThis list applies to both using an item at air and using it at a block/entity. Supports item tags. Supports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:fishing_rod\", \"minecraft:ender_pearl\", \"minecraft:(red|green)_bed\", \"#minecraft:beds\"]").translation("gui.xaero_pac_config_item_protection_exception").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"itemUseProtectionExceptionList"}), () -> Lists.newArrayList((Object[])new String[]{"minecraft:firework_rocket"}), s -> s instanceof String);
        this.itemUseProtectionOptionalExceptionGroups = builder.comment("Custom groups of items that a player/claim config should be able to make protection exceptions for. Each group can consist of multiple items and item tags.\nEach group creates a player config option for the right-click use of the group items. The format for an item group is <group ID>{<items/tags/wildcards separated by ,>}.\nThe group ID should consist of at most 32 characters that are letters A-Z, numbers 0-9 or the - and _ characters, e.g. \"ePiC-stuff98{minecraft:(writable|written)_book, minecraft:*_book, #minecraft:compasses}\".\nThe player config options created for the groups, like regular options, must be added in the \"playerConfigurablePlayerConfigOptions\" list for players to have access to them.\nThe exact paths of the added options can be found in the default player config file after you start the server.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.").translation("gui.xaero_pac_config_item_protection_exception_groups").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"itemUseProtectionOptionalExceptionGroups"}), () -> Lists.newArrayList((Object[])new String[]{"Books{minecraft:written_book, minecraft:writable_book}"}), s -> s instanceof String);
        this.completelyDisabledItemInteractions = builder.comment("Items that are completely banned from right-click usage on the server, claimed or not. This list applies to both using an item at air and using it at a block/entity. Supports item tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:trident\", \"minecraft:shield\", \"minecraft:(oak|spruce)_boat\", \"#minecraft:boats\"]").translation("gui.xaero_pac_config_completely_disabled_item_interactions").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"completelyDisabledItemInteractions"}), Lists::newArrayList, s -> s instanceof String);
        this.completelyDisabledBlockInteractions = builder.comment("Blocks that are completely banned from being interacted with on the server, claimed or not. Does not affect block breaking. Supports block tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:dirt\", \"minecraft:*_table\", \"minecraft:(cartography|fletching)_table\", \"#minecraft:buttons\"]").translation("gui.xaero_pac_config_completely_disabled_block_interactions").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"completelyDisabledBlockInteractions"}), Lists::newArrayList, s -> s instanceof String);
        this.completelyDisabledEntityInteractions = builder.comment("Entities that are completely banned from being interacted with on the server, claimed or not. Does not affect killing the entities. Supports entity tags.\nSupports patterns with special characters *, (, ) and |, where * matches anything, ( ) are used for grouping and | means OR.\nFor example [\"minecraft:(v|p)illager\", \"minecraft:*illager\", \"#minecraft:raiders\"]").translation("gui.xaero_pac_config_completely_disabled_entity_interactions").worldRestart().defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"completelyDisabledEntityInteractions"}), Lists::newArrayList, s -> s instanceof String);
        this.alwaysProtectBlocksFromEnchantments = builder.comment("Whether to always protect blocks from enchantments such as frost walking across the server. Use this if the regular claim protection doesn't work, since there is no game rule for it.").translation("gui.xaero_pac_config_always_protect_blocks_enchantments").worldRestart().define("alwaysProtectBlocksFromEnchantments", false);
        this.reducedBoatEntityCollisions = builder.comment("Whether to ignore most detected entity collisions for boats.\nBy default, boats detect entity collisions and handle them every tick for every entity that touches them, which is a lot.\nThis can become very slow on a server if we also add the necessary claim protection checks in the mix.\nThis option makes it so most collisions with boats are randomly ignored, which helps the performance without affecting gameplay all that much.").translation("gui.xaero_pac_config_reduced_boat_collisions").worldRestart().define("reducedBoatEntityCollisions", true);
        builder.pop();
        builder.pop();
        this.playerConfigurablePlayerConfigOptions = builder.comment("A list of options in the player config that individual players can reconfigure. If an option is in neither of the configurable option lists,\nthen the value in the default player config is used across the server. Check the default player config .toml file for the option names.").translation("gui.xaero_pac_config_player_configurable_player_options").defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"playerConfigurablePlayerConfigOptions"}), () -> Lists.newArrayList((Object[])new String[]{"claims.protectClaimedChunks", "claims.forceload.enabled", "claims.name", "claims.color", "claims.protection.fromParty", "claims.protection.fromAllyParties", "claims.protection.buttonsFromProjectiles", "claims.protection.targetsFromProjectiles", "claims.protection.platesFromPlayers", "claims.protection.platesFromMobs", "claims.protection.platesFromOther", "claims.protection.tripwireFromPlayers", "claims.protection.tripwireFromMobs", "claims.protection.tripwireFromOther", "claims.protection.cropTrample", "claims.protection.playerLightning", "claims.protection.blocksFromEnchantments", "claims.protection.entitiesFromPlayers", "claims.protection.entitiesFromMobs", "claims.protection.entitiesFromOther", "claims.protection.entitiesRedirect", "claims.protection.entitiesFromExplosions", "claims.protection.entitiesFromFire", "claims.protection.netherPortalsPlayers", "claims.protection.netherPortalsMobs", "claims.protection.netherPortalsOther", "claims.protection.fluidBarrier", "claims.protection.dispenserBarrier", "claims.protection.pistonBarrier", "claims.protection.itemTossPlayers", "claims.protection.itemTossMobs", "claims.protection.itemTossOther", "claims.protection.itemTossRedirect", "claims.protection.mobLoot", "claims.protection.playerDeathLoot", "claims.protection.itemPickupPlayers", "claims.protection.itemPickupMobs", "claims.protection.itemPickupRedirect", "claims.protection.xpPickup", "claims.protection.raids", "claims.protection.naturalSpawnHostile", "claims.protection.naturalSpawnFriendly", "claims.protection.spawnersHostile", "claims.protection.spawnersFriendly", "claims.protection.projectileHitHostileSpawn", "claims.protection.projectileHitFriendlySpawn", "parties.name", "parties.shareLocationWithParty", "parties.shareLocationWithMutualAllyParties", "parties.receiveLocationsFromParty", "parties.receiveLocationsFromMutualAllyParties", "claims.protection.exceptionGroups.block.interact.Controls", "claims.protection.exceptionGroups.block.interact.Doors", "claims.protection.exceptionGroups.block.interact.Chests", "claims.protection.exceptionGroups.block.interact.Barrels", "claims.protection.exceptionGroups.block.interact.Ender_Chests", "claims.protection.exceptionGroups.block.interact.Shulker_Boxes", "claims.protection.exceptionGroups.block.interact.Furnaces", "claims.protection.exceptionGroups.block.interact.Hoppers", "claims.protection.exceptionGroups.block.interact.Dispenser-like", "claims.protection.exceptionGroups.block.interact.Anvils", "claims.protection.exceptionGroups.block.interact.Beds", "claims.protection.exceptionGroups.block.interact.Beacons", "claims.protection.exceptionGroups.block.interact.Enchanting_Tables", "claims.protection.exceptionGroups.block.break.Crops", "claims.protection.exceptionGroups.entity.interact.Traders", "claims.protection.exceptionGroups.entity.handInteract.Item_Frames", "claims.protection.exceptionGroups.entity.interact.Armor_Stands", "claims.protection.exceptionGroups.entity.break.Livestock", "claims.protection.exceptionGroups.entity.blockAccess.Villagers", "claims.protection.exceptionGroups.entity.entityAccess.Zombies", "claims.protection.exceptionGroups.entity.droppedItemAccess.Villagers", "claims.protection.exceptionGroups.entity.droppedItemAccess.Piglins", "claims.protection.exceptionGroups.entity.droppedItemAccess.Foxes", "claims.protection.exceptionGroups.item.interact.Books", "claims.protection.exceptionGroups.entity.barrier.Ender_Pearls", "/*remove comment to enable*/claims.protection.exceptionGroups.entity.barrier.Players"}), s -> s instanceof String);
        this.opConfigurablePlayerConfigOptions = builder.comment("A list of additional options in the player config that OPs can reconfigure for players.\nThis is meant for options that should be configured per player but not by the players.\nIf an option is in neither of the configurable option lists, then the value in the default player config is used across the server.\nCheck the default player config .toml file for the option names.").translation("gui.xaero_pac_config_op_configurable_player_options").defineListAllowEmpty((List)Lists.newArrayList((Object[])new String[]{"opConfigurablePlayerConfigOptions"}), () -> Lists.newArrayList((Object[])new String[]{"claims.bonusChunkClaims", "claims.bonusChunkForceloads"}), s -> s instanceof String);
        builder.pop();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        CONFIG = (ServerConfig)specPair.getLeft();
    }

    public static enum ConfigListType {
        ONLY,
        ALL_BUT;

    }

    public static enum ClaimsSyncType {
        NOT_SYNCED,
        OWNED_ONLY,
        ALL;

    }
}

