/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSubCreateCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command<CommandSourceStack> regularExecutor = ConfigSubCreateCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<CommandSourceStack> serverExecutor = ConfigSubCreateCommand.getExecutor(PlayerConfigType.SERVER);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(this.getMainCommandPart(regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(this.getMainCommandPart(regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(this.getMainCommandPart(serverExecutor)));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> getMainCommandPart(Command<CommandSourceStack> executor) {
        return (LiteralArgumentBuilder)Commands.literal((String)"sub").then(Commands.literal((String)"create").then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).executes(executor)));
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type) {
        return context -> {
            UUID configPlayerUUID;
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            NameAndId inputPlayer = null;
            UUID uUID = configPlayerUUID = type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_pac_config_create_sub_too_many_targets", "gui.xaero_pac_config_create_sub_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.id();
            }
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(sourcePlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return 0;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            PlayerConfig playerConfig = (PlayerConfig)serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            if (playerConfig.getSubCount() >= playerConfig.getSubConfigLimit()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_create_sub_id_limit_reached", playerConfig.getSubConfigLimit()));
                return 0;
            }
            IPlayerConfig result = playerConfig.createSubConfig(inputSubId);
            if (result == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_create_sub_id_rules", 16));
                return 0;
            }
            sourcePlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_create_sub", new Object[0]));
            return 1;
        };
    }
}

