/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.world;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import xaero.pac.common.event.CommonEvents;

public class ServerLevelHelper {
    public static ServerLevel getServerLevel(Level level) {
        if (level == null) {
            return null;
        }
        MinecraftServer server = ServerLevelHelper.getServer(level);
        if (server == null) {
            return null;
        }
        if (level instanceof ServerLevel) {
            return (ServerLevel)level;
        }
        return server.getLevel(level.dimension());
    }

    public static MinecraftServer getServer(Level level) {
        MinecraftServer result = level.getServer();
        if (result == null && CommonEvents.lastServerStarted != null && CommonEvents.lastServerStarted.isSameThread()) {
            return CommonEvents.lastServerStarted;
        }
        if (result != null && !result.isSameThread()) {
            return null;
        }
        return result;
    }

    public static MinecraftServer getServer(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity.level() == null) {
            return null;
        }
        return ServerLevelHelper.getServer(entity.level());
    }
}

