/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.command.ConfigGetOrHelpCommand;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSetCommand {
    private <T extends Comparable<T>> IPlayerConfigAPI.SetResult tryToSet(CommandContext<CommandSourceStack> context, ServerPlayer player, AdaptiveLocalizer adaptiveLocalizer, IPlayerConfig playerConfig, PlayerConfigOptionSpec<T> option, String valueInput, boolean reset) {
        IPlayerConfigAPI.SetResult result;
        if (reset) {
            result = playerConfig.tryToReset(option);
        } else {
            Comparable value;
            try {
                value = (Comparable)option.getCommandInputParser().apply(valueInput);
            }
            catch (Throwable t) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_pac_config_option_set_invalid_value_format", new Object[0]));
                return IPlayerConfigAPI.SetResult.INVALID;
            }
            result = playerConfig.tryToSet(option, value);
        }
        if (result == IPlayerConfigAPI.SetResult.INVALID) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_pac_config_option_set_invalid_value", new Object[0]));
        }
        return result;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        SuggestionProvider<CommandSourceStack> optionSuggestor = ConfigGetOrHelpCommand.getOptionSuggestor();
        SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        this.registerSetCommands("set", dispatcher, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, false);
        this.registerSetCommands("reset", dispatcher, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, true);
    }

    private void registerSetCommands(String literalPrefix, CommandDispatcher<CommandSourceStack> dispatcher, SuggestionProvider<CommandSourceStack> optionSuggestor, SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider, SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider, boolean reset) {
        Command<CommandSourceStack> regularExecutor = this.getExecutor(PlayerConfigType.PLAYER, reset);
        Command<CommandSourceStack> defaultExecutor = this.getExecutor(PlayerConfigType.DEFAULT_PLAYER, reset);
        Command<CommandSourceStack> serverExecutor = this.getExecutor(PlayerConfigType.SERVER, reset);
        Command<CommandSourceStack> expiredExecutor = this.getExecutor(PlayerConfigType.EXPIRED, reset);
        Command<CommandSourceStack> wildernessExecutor = this.getExecutor(PlayerConfigType.WILDERNESS, reset);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)literalPrefix).requires(sourceStack -> true)).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(Commands.literal((String)"sub").then(((LiteralArgumentBuilder)Commands.literal((String)literalPrefix).requires(sourceStack -> true)).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(Commands.literal((String)"for").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(Commands.literal((String)"for").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"sub").then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(Commands.literal((String)"player-config").then(((LiteralArgumentBuilder)Commands.literal((String)"default").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, defaultExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, serverExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"server-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"sub").then(Commands.literal((String)literalPrefix).then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(serverSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, serverExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"expired-claims-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, expiredExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac").then(((LiteralArgumentBuilder)Commands.literal((String)"wilderness-config").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, wildernessExecutor, Commands.argument((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
    }

    private <T extends ArgumentBuilder<CommandSourceStack, T>> T addValueArgumentIfNeeded(boolean reset, Command<CommandSourceStack> executor, T builder) {
        if (reset) {
            return (T)builder.executes(executor);
        }
        return (T)builder.then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(executor));
    }

    public Command<CommandSourceStack> getExecutor(PlayerConfigType type, boolean reset) {
        return context -> {
            PlayerSubConfig subConfig;
            String valueInput;
            UUID configPlayerUUID;
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String targetConfigOptionId = StringArgumentType.getString((CommandContext)context, (String)"key");
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)serverData.getPlayerConfigs().getOptionForId(targetConfigOptionId);
            if (option == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_invalid_key", new Object[0]));
                return 0;
            }
            GameProfile inputPlayer = null;
            UUID uUID = configPlayerUUID = type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_pac_config_option_set_too_many_targets", "gui.xaero_pac_config_option_set_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            }
            String string = valueInput = reset ? null : StringArgumentType.getString((CommandContext)context, (String)"value");
            IPlayerConfig playerConfig = type == PlayerConfigType.DEFAULT_PLAYER ? serverData.getPlayerConfigs().getDefaultConfig() : (type == PlayerConfigType.EXPIRED ? serverData.getPlayerConfigs().getExpiredClaimConfig() : serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID));
            IPlayerConfig effectivePlayerConfig = ConfigCommandUtil.getEffectiveConfig((CommandContext<CommandSourceStack>)context, playerConfig);
            if (effectivePlayerConfig == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_invalid_sub", new Object[0]));
                return 0;
            }
            boolean isOP = ((CommandSourceStack)context.getSource()).hasPermission(2);
            if (!isOP && PlayerConfig.isOptionOPConfigurable(option)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_op_option", new Object[0]));
                return 0;
            }
            IPlayerConfigAPI.SetResult result = this.tryToSet((CommandContext<CommandSourceStack>)context, sourcePlayer, adaptiveLocalizer, effectivePlayerConfig, option, valueInput, reset);
            if (result == IPlayerConfigAPI.SetResult.INVALID) {
                return 0;
            }
            if (result == IPlayerConfigAPI.SetResult.ILLEGAL_OPTION) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_illegal_option", new Object[0]));
                return 0;
            }
            Object wantedValue = reset ? effectivePlayerConfig.getDefaultRawValue(option) : option.getCommandInputParser().apply(valueInput);
            Object actualValue = effectivePlayerConfig.getFromEffectiveConfig(option);
            if (effectivePlayerConfig instanceof PlayerSubConfig && (subConfig = (PlayerSubConfig)effectivePlayerConfig).isInherited(option)) {
                actualValue = null;
            }
            Component wantedValueName = option.getValueDisplayName(wantedValue);
            if (type == PlayerConfigType.PLAYER) {
                sourcePlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set", inputPlayer.getName(), targetConfigOptionId, wantedValueName));
            } else {
                sourcePlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set", type.getName(), targetConfigOptionId, wantedValueName));
            }
            if (result == IPlayerConfigAPI.SetResult.DEFAULTED && wantedValue != null && wantedValue != actualValue) {
                Component actualValueName = option.getValueDisplayName(actualValue);
                sourcePlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_server_force", actualValueName));
            }
            return 1;
        };
    }
}

