/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class InviteAcceptPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getNonMemberRequirement(p -> true);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.literal((String)"join").requires(requirement)).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            ServerPlayer casterPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            CompoundTag data = Services.PLATFORM.getEntityAccess().getPersistentData((Entity)casterPlayer);
            Stream lastInviteId = data.hasUUID("xaero_OPAC_LastInviteId") ? Stream.of(data.getUUID("xaero_OPAC_LastInviteId").toString()) : Stream.empty();
            return SharedSuggestionProvider.suggest(lastInviteId, (SuggestionsBuilder)builder);
        }).executes(context -> {
            UUID targetPartyId;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID playerId = player.getUUID();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerId);
            if (playerParty != null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_already_in_one", new Object[0]));
                return 0;
            }
            String targetPartyStringId = (String)context.getArgument("id", String.class);
            try {
                targetPartyId = UUID.fromString(targetPartyStringId);
            }
            catch (IllegalArgumentException iae) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_invalid_id", new Object[0]));
                return 0;
            }
            IServerPartyAPI targetParty = partyManager.getPartyById(targetPartyId);
            if (targetParty == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_not_exist", new Object[0]));
                return 0;
            }
            if (!targetParty.isInvited(playerId)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_party_not_invited", new Object[0]));
                return 0;
            }
            if (targetParty.getMemberCount() >= (Integer)ServerConfig.CONFIG.maxPartyMembers.get()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_member_limit", new Object[0]));
                return 0;
            }
            IPartyMemberAPI addedPartyMember = targetParty.addMember(playerId, null, player.getGameProfile().getName());
            if (addedPartyMember == null) {
                return 0;
            }
            player.sendSystemMessage((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_join_success", targetParty.getDefaultName()));
            new PartyOnCommandUpdater().update(playerId, serverData, targetParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.translatable((String)"gui.xaero_parties_join_success_info", (Object[])new Object[]{Component.literal((String)addedPartyMember.getUsername()).withStyle(s -> s.withColor(ChatFormatting.DARK_GREEN))}));
            server.getCommands().sendCommands(player);
            return 1;
        })));
        dispatcher.register(command);
    }
}

