/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.list.SortedValueList;
import xaero.pac.common.misc.ConfigUtil;
import xaero.pac.common.parties.party.PartyMemberDynamicInfoSyncable;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.io.ObjectManagerIOObject;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.util.linked.LinkedChain;

public class PlayerConfig<P extends IServerParty<?, ?, ?>>
implements IPlayerConfig,
ObjectManagerIOObject {
    public static final int MAX_SUB_ID_LENGTH = 16;
    public static final String SUB_ID_REGEX = "[a-zA-Z\\d\\-_]+";
    public static final UUID SERVER_CLAIM_UUID = new UUID(0L, 0L);
    public static final UUID EXPIRED_CLAIM_UUID = new UUID(0L, 1L);
    public static final String MAIN_SUB_ID = "main";
    public static final String PLAYER_CONFIG_ROOT = "playerConfig";
    public static final String PLAYER_CONFIG_ROOT_DOT = "playerConfig.";
    public static final List<Integer> PROTECTION_LEVELS = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    public static final String PROTECTION_LEVELS_TOOLTIP = "1) Every - protected from all players/entities that don't have chunk access.\n2) Not Party - only players/entities not in the same party as you.\n3) Not Ally - only players/entities not in any party allied by yours.";
    public static final String PROTECTION_LEVELS_TOOLTIP_PLAYERS = "1) Every - protected from all players that don't have chunk access.\n2) Not Party - only players not in the same party as you.\n3) Not Ally - only players not in any party allied by yours.";
    public static final String PROTECTION_LEVELS_TOOLTIP_OWNED = "1) Every - protected from all entities not owned by a player that has chunk access.\n2) Not Party - all entities, except owned by a player in the same party as you.\n3) Not Ally - all entities, except owned by a player in any party allied by yours.";
    public static final String PROTECTION_LEVELS_TOOLTIP_PROJECTILE = "1) Every - protected from all projectiles not owned by a player that has chunk access.\n2) Not Party - all projectiles, except owned by a player in the same party as you.\n3) Not Ally - all projectiles, except owned by a player in any party allied by yours.";
    public static final String EXCEPTION_LEVELS_TOOLTIP = "1) Party - players or entities owned by players in the same party as you.\n2) Allies - players or entities owned by players in parties that are allied by yours.\n3) Every - all players/entities.";
    public static final String EXCEPTION_LEVELS_TOOLTIP_PLAYERS = "1) Party - players in the same party as you.\n2) Allies - players in parties that are allied by yours.\n3) Every - all players.";
    protected final PlayerConfigManager<P, ?> manager;
    private final PlayerConfigType type;
    private final UUID playerId;
    protected Config storage;
    private boolean dirty;
    private final Map<PlayerConfigOptionSpec<?>, Object> automaticDefaultValues;
    private final LinkedChain<PlayerSubConfig<P>> linkedSubConfigs;
    private final Map<String, PlayerSubConfig<P>> subByID;
    private final Int2ObjectMap<String> subIndexToID;
    private int lastCreatedSubIndex;
    private final SortedValueList<String> subConfigIds;
    private final List<String> subConfigIdsUnmodifiable;
    private boolean beingDeleted;

    protected PlayerConfig(PlayerConfigType type, UUID playerId, PlayerConfigManager<P, ?> manager, Map<PlayerConfigOptionSpec<?>, Object> automaticDefaultValues, LinkedChain<PlayerSubConfig<P>> linkedSubConfigs, Map<String, PlayerSubConfig<P>> subByID, Int2ObjectMap<String> subIndexToID, SortedValueList<String> subConfigIds, List<String> subConfigIdsUnmodifiable) {
        this.type = type;
        this.playerId = playerId;
        this.manager = manager;
        this.automaticDefaultValues = automaticDefaultValues;
        this.linkedSubConfigs = linkedSubConfigs;
        this.subByID = subByID;
        this.subIndexToID = subIndexToID;
        this.subConfigIds = subConfigIds;
        this.subConfigIdsUnmodifiable = subConfigIdsUnmodifiable;
    }

    public Config getStorage() {
        if (this.storage == null) {
            this.setStorage(ConfigUtil.deepCopy((UnmodifiableConfig)((PlayerConfig)this.manager.getDefaultConfig()).getStorage(), LinkedHashMap::new));
            this.setDirty(true);
        }
        return this.storage;
    }

    public void setStorage(Config storage) {
        this.storage = storage;
    }

    private <T extends Comparable<T>> void set(PlayerConfigOptionSpec<T> option, T value) {
        if (value == null) {
            this.getStorage().remove(option.getPath());
        } else {
            this.getStorage().set(option.getPath(), value);
        }
        if (this.manager.isLoaded()) {
            this.setDirty(true);
        }
    }

    private <T extends Comparable<T>> T get(PlayerConfigOptionSpec<T> option) {
        return (T)((Comparable)this.getStorage().get(option.getPath()));
    }

    protected <T extends Comparable<T>> boolean isValidSetValue(@Nonnull PlayerConfigOptionSpec<T> option, @Nullable T value) {
        return option.getServerSideValidator().test(this, (IPlayerConfigAPI)((Object)value));
    }

    protected <T extends Comparable<T>> T getValueForDefaultConfigMatch(T actualEffective, T value) {
        return actualEffective;
    }

    @Override
    public boolean isOptionAllowed(@Nonnull IPlayerConfigOptionSpecAPI<?> option) {
        return option.getConfigTypeFilter().test(this.getType());
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> IPlayerConfigAPI.SetResult tryToSet(@Nonnull IPlayerConfigOptionSpecAPI<T> o, @Nullable T value) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        if (!this.isOptionAllowed(option)) {
            return IPlayerConfigAPI.SetResult.ILLEGAL_OPTION;
        }
        if (!this.isValidSetValue(option, value)) {
            return IPlayerConfigAPI.SetResult.INVALID;
        }
        T beforeEffective = this.getFromEffectiveConfig(option);
        this.set(option, value);
        T nowEffective = value;
        if (this.isOptionDefaulted(option)) {
            nowEffective = this.getValueForDefaultConfigMatch(((PlayerConfig)this.manager.getDefaultConfig()).getFromEffectiveConfig(option), value);
            if (nowEffective != value) {
                this.set(option, nowEffective);
            }
            return IPlayerConfigAPI.SetResult.DEFAULTED;
        }
        if (this.playerId != null && !Objects.equals(nowEffective, beforeEffective)) {
            ServerPlayer onlinePlayer;
            if ((option == PlayerConfigOptions.BONUS_CHUNK_FORCELOADS || option == PlayerConfigOptions.BONUS_CHUNK_CLAIMS) && (onlinePlayer = this.getOnlinePlayer()) != null) {
                Object claimsManager = this.manager.getClaimsManager();
                claimsManager.getClaimsManagerSynchronizer().syncClaimLimits(this, onlinePlayer);
            }
            if (option == PlayerConfigOptions.FORCELOAD || option == PlayerConfigOptions.OFFLINE_FORCELOAD || option == PlayerConfigOptions.BONUS_CHUNK_FORCELOADS) {
                this.manager.getForceLoadTicketManager().updateTicketsFor(this.manager, this.playerId, false);
            } else if (option == PlayerConfigOptions.PARTY_NAME) {
                IServerPartyAPI party = this.manager.getPartyManager().getPartyByOwner(this.playerId);
                if (party != null) {
                    this.manager.getPartyManager().getPartySynchronizer().syncToPartyAndAlliersUpdateName(party, (String)((Object)value));
                }
            } else if (option == PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY || option == PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES || option == PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY || option == PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY_MUTUAL_ALLIES) {
                ServerPlayer onlinePlayer2;
                boolean castValue = (Boolean)nowEffective;
                IServerPartyAPI party = this.manager.getPartyManager().getPartyByMember(this.playerId);
                if (party != null && (onlinePlayer2 = this.getOnlinePlayer()) != null) {
                    if (option == PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY || option == PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES) {
                        PartyMemberDynamicInfoSyncable syncedInfo;
                        ServerPlayerData mainCap = (ServerPlayerData)ServerPlayerDataAPI.from(onlinePlayer2);
                        PartyMemberDynamicInfoSyncable partyMemberDynamicInfoSyncable = syncedInfo = castValue ? mainCap.getPartyMemberDynamicInfo() : mainCap.getPartyMemberDynamicInfo().getRemover();
                        if (option == PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY) {
                            this.manager.getPartyManager().getPartySynchronizer().getOftenSyncedInfoSync().syncToPartyDynamicInfo(party, syncedInfo, party);
                        } else {
                            this.manager.getPartyManager().getPartySynchronizer().getOftenSyncedInfoSync().syncToPartyMutualAlliesDynamicInfo(party, syncedInfo);
                        }
                    } else if (option == PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY) {
                        this.manager.getPartyManager().getPartySynchronizer().getOftenSyncedInfoSync().syncToClientAllDynamicInfo(onlinePlayer2, party, !castValue);
                    } else {
                        this.manager.getPartyManager().getPartySynchronizer().getOftenSyncedInfoSync().syncToClientMutualAlliesDynamicInfo(onlinePlayer2, party, !castValue);
                    }
                }
            } else if (option == PlayerConfigOptions.CLAIMS_NAME || option == PlayerConfigOptions.CLAIMS_COLOR) {
                this.manager.getClaimsManager().getClaimsManagerSynchronizer().syncToPlayersSubClaimPropertiesUpdate(this);
            } else if ((option == PlayerConfigOptions.USED_SUBCLAIM || option == PlayerConfigOptions.USED_SERVER_SUBCLAIM) && (onlinePlayer = this.getOnlinePlayer()) != null) {
                this.manager.getClaimsManager().getClaimsManagerSynchronizer().syncCurrentSubClaim(this, onlinePlayer);
            }
        }
        this.manager.getSynchronizer().syncOptionToClients(this, option);
        return IPlayerConfigAPI.SetResult.SUCCESS;
    }

    private ServerPlayer getOnlinePlayer() {
        PlayerList serverPlayers = this.manager.getServer().getPlayerList();
        return serverPlayers.getPlayer(this.playerId);
    }

    public static boolean isPlayerConfigurable(IPlayerConfigOptionSpecAPI<?> o) {
        return o == PlayerConfigOptions.USED_SUBCLAIM || o == PlayerConfigOptions.USED_SERVER_SUBCLAIM || ((List)ServerConfig.CONFIG.playerConfigurablePlayerConfigOptions.get()).contains(o.getId()) || ((List)ServerConfig.CONFIG.playerConfigurablePlayerConfigOptions.get()).contains(o.getShortenedId());
    }

    protected boolean isOptionDefaulted(PlayerConfigOptionSpec<?> option) {
        return this.playerId != null && !Objects.equals(this.playerId, SERVER_CLAIM_UUID) && !Objects.equals(this.playerId, EXPIRED_CLAIM_UUID) && !PlayerConfig.isOptionOPConfigurable(option) && !PlayerConfig.isPlayerConfigurable(option);
    }

    public static boolean isOptionOPConfigurable(IPlayerConfigOptionSpecAPI<?> option) {
        return ((List)ServerConfig.CONFIG.opConfigurablePlayerConfigOptions.get()).contains(option.getId()) || ((List)ServerConfig.CONFIG.opConfigurablePlayerConfigOptions.get()).contains(option.getShortenedId());
    }

    public static boolean isOptionOPConfigurable(String fullOptionId) {
        return ((List)ServerConfig.CONFIG.opConfigurablePlayerConfigOptions.get()).contains(fullOptionId) || ((List)ServerConfig.CONFIG.opConfigurablePlayerConfigOptions.get()).contains(fullOptionId.substring(PLAYER_CONFIG_ROOT_DOT.length()));
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getFromEffectiveConfig(@Nonnull IPlayerConfigOptionSpecAPI<T> o) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        if (this.isOptionDefaulted(option)) {
            return ((PlayerConfig)this.manager.getDefaultConfig()).getFromEffectiveConfig(option);
        }
        return this.get(option);
    }

    @Override
    public <T extends Comparable<T>> T getRaw(@Nonnull IPlayerConfigOptionSpecAPI<T> o) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        return this.get(option);
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> IPlayerConfigAPI.SetResult tryToReset(@Nonnull IPlayerConfigOptionSpecAPI<T> option) {
        return this.tryToSet(option, this.getDefaultRawValue(option));
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getEffective(@Nonnull IPlayerConfigOptionSpecAPI<T> o) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        T value = this.getFromEffectiveConfig(option);
        return this.applyDefaultReplacer(o, value);
    }

    @Override
    public <T extends Comparable<T>> T applyDefaultReplacer(IPlayerConfigOptionSpecAPI<T> o, T value) {
        if (value == null) {
            return null;
        }
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        if (option.getDefaultReplacer() != null && value.equals(option.getDefaultValue())) {
            Comparable autoValue = (Comparable)this.automaticDefaultValues.get(option);
            if (autoValue == null) {
                autoValue = (Comparable)option.getDefaultReplacer().apply(this, (PlayerConfig)((Object)value));
                this.automaticDefaultValues.put(option, autoValue);
            }
            return (T)autoValue;
        }
        return value;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.playerId != null && !this.dirty && dirty) {
            this.manager.addToSave(this);
        }
        this.dirty = dirty;
    }

    @Override
    public String getFileName() {
        if (this.playerId == null) {
            return "null";
        }
        return this.playerId.toString();
    }

    @Override
    @Nullable
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    @Nonnull
    public PlayerConfigType getType() {
        return this.type;
    }

    public static boolean isValidSubId(String id) {
        return !id.isEmpty() && id.length() <= 16 && id.matches(SUB_ID_REGEX);
    }

    private boolean isFreeSubIndex(int index) {
        return index != -1 && !this.subIndexToID.containsKey(index);
    }

    private int getFreeSubConfigIndex() {
        int result = this.lastCreatedSubIndex;
        while (!this.isFreeSubIndex(++result)) {
        }
        return result;
    }

    @Override
    @Nullable
    public PlayerSubConfig<P> createSubConfig(@Nonnull String id) {
        int freeSubIndex = this.getFreeSubConfigIndex();
        return this.createSubConfig(id, freeSubIndex);
    }

    public PlayerSubConfig<P> createSubConfig(String id, int index) {
        if (this.subConfigIds.contains(id) || !this.isFreeSubIndex(index) || !PlayerConfig.isValidSubId(id)) {
            return null;
        }
        if (index > this.lastCreatedSubIndex || index < 0 && this.lastCreatedSubIndex >= 0) {
            this.lastCreatedSubIndex = index;
        }
        PlayerConfig subConfig = ((PlayerSubConfig.Builder)((PlayerSubConfig.Builder)((PlayerSubConfig.Builder)PlayerSubConfig.Builder.begin().setType(this.type)).setPlayerId(this.playerId)).setManager(this.manager)).setMainConfig(this).setSubId(id).setSubIndex(index).build();
        this.subByID.put(id, (PlayerSubConfig<P>)subConfig);
        this.subIndexToID.put(index, (Object)id);
        this.linkedSubConfigs.add((PlayerSubConfig<P>)subConfig);
        this.addToSubConfigIds(id);
        if (this.manager.isLoaded()) {
            ((PlayerSubConfig)subConfig).getStorage();
            this.manager.getSynchronizer().syncSubExistence(null, subConfig, true);
        }
        return subConfig;
    }

    private void addToSubConfigIds(String id) {
        this.subConfigIds.add(id);
    }

    private void removeFromSubConfigIds(String id) {
        this.subConfigIds.remove(id);
    }

    @Override
    public PlayerSubConfig<P> removeSubConfig(String id) {
        PlayerSubConfig<P> subConfig = this.subByID.remove(id);
        if (subConfig == null) {
            return null;
        }
        this.subIndexToID.remove(subConfig.getSubIndex());
        this.removeFromSubConfigIds(id);
        this.linkedSubConfigs.remove(subConfig);
        this.manager.onSubConfigRemoved(subConfig);
        if (this.type != PlayerConfigType.SERVER && this.getEffective(PlayerConfigOptions.USED_SUBCLAIM).equals(id)) {
            this.tryToReset(PlayerConfigOptions.USED_SUBCLAIM);
        }
        if (this.manager.isLoaded()) {
            this.manager.getSynchronizer().syncSubExistence(null, subConfig, false);
        }
        return subConfig;
    }

    @Override
    public PlayerSubConfig<P> removeSubConfig(int index) {
        String subId = (String)this.subIndexToID.get(index);
        return subId != null ? this.removeSubConfig(subId) : null;
    }

    @Override
    @Nullable
    public PlayerConfig<P> getSubConfig(@Nonnull String id) {
        if (MAIN_SUB_ID.equals(id)) {
            return this;
        }
        return this.subByID.get(id);
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getEffectiveSubConfig(@Nonnull String id) {
        IPlayerConfig result = this.getSubConfig(id);
        return result == null ? this : result;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getEffectiveSubConfig(int subIndex) {
        if (subIndex == -1) {
            return this;
        }
        String subId = (String)this.subIndexToID.get(subIndex);
        if (subId == null) {
            return this;
        }
        return this.getSubConfig(subId);
    }

    @Override
    public boolean subConfigExists(@Nonnull String id) {
        return this.subByID.containsKey(id);
    }

    @Override
    public boolean subConfigExists(int subIndex) {
        return this.subIndexToID.containsKey(subIndex);
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getUsedSubConfig() {
        String usedSubId = this.getEffective(PlayerConfigOptions.USED_SUBCLAIM);
        IPlayerConfig result = this.getSubConfig(usedSubId);
        return result == null ? this : result;
    }

    @Override
    @Nonnull
    public IPlayerConfig getUsedServerSubConfig() {
        return ((PlayerConfig)this.manager.getServerClaimConfig()).getEffectiveSubConfig(this.getEffective(PlayerConfigOptions.USED_SERVER_SUBCLAIM));
    }

    @Override
    @Nullable
    public <T extends Comparable<T>> T getDefaultRawValue(@Nonnull IPlayerConfigOptionSpecAPI<T> option) {
        return option.getDefaultValue();
    }

    @Override
    public int getSubCount() {
        return this.subByID.size();
    }

    public Stream<PlayerSubConfig<P>> getSubConfigStream() {
        return this.linkedSubConfigs.stream();
    }

    @Override
    public Iterator<IPlayerConfig> getSubConfigIterator() {
        return this.getSubConfigStream().map(Function.identity()).iterator();
    }

    @Override
    @Nonnull
    public List<String> getSubConfigIds() {
        return this.subConfigIdsUnmodifiable;
    }

    @Override
    @Nonnull
    public Stream<IPlayerConfigAPI> getSubConfigAPIStream() {
        return this.getSubConfigStream().map(Function.identity());
    }

    @Override
    @Nullable
    public String getSubId() {
        return null;
    }

    public PlayerConfigManager<P, ?> getManager() {
        return this.manager;
    }

    @Override
    public int getSubIndex() {
        return -1;
    }

    @Override
    public boolean isBeingDeleted() {
        return this.beingDeleted;
    }

    @Override
    public int getSubConfigLimit() {
        if (this.type == PlayerConfigType.SERVER) {
            return Integer.MAX_VALUE;
        }
        return (Integer)ServerConfig.CONFIG.playerSubConfigLimit.get();
    }

    @Override
    public void setBeingDeleted() {
        this.beingDeleted = true;
        this.manager.getSynchronizer().syncGeneralState(null, this);
    }

    public static abstract class Builder<P extends IServerParty<?, ?, ?>, B extends Builder<P, B>> {
        protected final B self = this;
        protected PlayerConfigManager<P, ?> manager;
        protected PlayerConfigType type;
        protected UUID playerId;
        protected Map<PlayerConfigOptionSpec<?>, Object> automaticDefaultValues;

        protected Builder() {
        }

        public B setDefault() {
            this.setManager(null);
            this.setType(PlayerConfigType.PLAYER);
            this.setPlayerId(null);
            this.setAutomaticDefaultValues(null);
            return this.self;
        }

        public B setManager(PlayerConfigManager<P, ?> manager) {
            this.manager = manager;
            return this.self;
        }

        public B setType(PlayerConfigType type) {
            this.type = type;
            return this.self;
        }

        public B setPlayerId(UUID playerId) {
            this.playerId = playerId;
            return this.self;
        }

        public B setAutomaticDefaultValues(Map<PlayerConfigOptionSpec<?>, Object> automaticDefaultValues) {
            this.automaticDefaultValues = automaticDefaultValues;
            return this.self;
        }

        public PlayerConfig<P> build() {
            if (this.type == PlayerConfigType.PLAYER && this.playerId == null || this.manager == null) {
                throw new IllegalStateException();
            }
            if (this.automaticDefaultValues == null) {
                this.automaticDefaultValues = new HashMap();
            }
            return this.buildInternally();
        }

        protected abstract PlayerConfig<P> buildInternally();
    }

    public static final class FinalBuilder<P extends IServerParty<?, ?, ?>>
    extends Builder<P, FinalBuilder<P>> {
        @Override
        protected PlayerConfig<P> buildInternally() {
            ArrayList subConfigIdStorage = Lists.newArrayList((Object[])new String[]{PlayerConfig.MAIN_SUB_ID});
            SortedValueList<String> subConfigIds = SortedValueList.Builder.begin().setContent(subConfigIdStorage).build();
            List<String> subConfigIdsUnmodifiable = Collections.unmodifiableList(subConfigIdStorage);
            return new PlayerConfig(this.type, this.playerId, this.manager, this.automaticDefaultValues, new LinkedChain(), new HashMap(), (Int2ObjectMap<String>)new Int2ObjectOpenHashMap(), subConfigIds, subConfigIdsUnmodifiable);
        }

        public static <P extends IServerParty<?, ?, ?>> FinalBuilder<P> begin() {
            return (FinalBuilder)new FinalBuilder<P>().setDefault();
        }
    }
}

