/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.tracker.api.IClaimsManagerTrackerRegisterAPI;
import xaero.pac.common.entity.EntityData;
import xaero.pac.common.mods.create.CreateContraptionHelper;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IOpenPACMinecraftServer;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.ServerDataInitializer;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsCommandRegister;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.command.CommonCommandRegister;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.core.accessor.ICreateContraptionEntity;
import xaero.pac.common.server.parties.command.PartyCommandRegister;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemRegisterAPI;
import xaero.pac.common.server.parties.system.impl.DefaultPlayerPartySystem;
import xaero.pac.common.server.player.data.IOpenPACServerPlayer;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemRegisterAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public abstract class CommonEvents {
    protected final OpenPartiesAndClaims modMain;
    public static MinecraftServer lastServerStarted;
    private Class<?> createSuperGlueEntityClass;

    protected CommonEvents(OpenPartiesAndClaims modMain) {
        this.modMain = modMain;
        try {
            this.createSuperGlueEntityClass = Class.forName("com.simibubi.create.content.contraptions.glue.SuperGlueEntity");
        }
        catch (ClassNotFoundException ignored) {
            try {
                this.createSuperGlueEntityClass = Class.forName("com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void onServerAboutToStart(MinecraftServer server) throws Throwable {
        lastServerStarted = server;
        OpenPartiesAndClaims.LOGGER.info("Initializing Open Parties and Claims for the server...");
        ((IOpenPACMinecraftServer)lastServerStarted).setXaero_OPAC_ServerData(new ServerDataInitializer().init(this.modMain, lastServerStarted));
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        if (serverData != null) {
            try {
                serverData.getPlayerPermissionSystemManager().preRegister();
                serverData.getPlayerPartySystemManager().preRegister();
                serverData.getPlayerPartySystemManager().register("default", new DefaultPlayerPartySystem((IPartyManager<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>>)serverData.getPartyManager()));
                this.fireAddonRegisterEvent(serverData);
            }
            finally {
                serverData.getPlayerPermissionSystemManager().postRegister();
                serverData.getPlayerPartySystemManager().postRegister();
            }
        }
    }

    protected abstract void fireAddonRegisterEvent(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> var1);

    public void onServerStarting(MinecraftServer server) {
        this.modMain.startupCrashHandler.check();
        ServerData.from(server).getServerLoadCallback().onLoad(server);
    }

    public void onPlayerRespawn(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.getServer());
            if (serverData != null) {
                serverData.getPlayerWorldJoinHandler().onWorldJoin(serverData, serverPlayer.level(), serverPlayer);
            }
        }
    }

    public void onPlayerChangedDimension(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.getServer());
            if (serverData != null) {
                serverData.getPlayerWorldJoinHandler().onWorldJoin(serverData, serverPlayer.level(), serverPlayer);
            }
        }
    }

    public void onPlayerLogIn(Player player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (player instanceof ServerPlayer && (serverData = ServerData.from(player.getServer())) != null) {
            ServerPlayerDataAPI.from((ServerPlayer)player);
        }
    }

    public void onPlayerClone(Player original, Player player) {
        if (original instanceof ServerPlayer) {
            ((IOpenPACServerPlayer)player).setXaero_OPAC_PlayerData(ServerPlayerDataAPI.from((ServerPlayer)original));
        }
    }

    public void onPlayerLogOut(Player player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (player instanceof ServerPlayer && (serverData = ServerData.from(player.getServer())) != null) {
            serverData.getPlayerLogoutHandler().handle((ServerPlayer)player, serverData);
        }
    }

    public void onServerTick(MinecraftServer server, boolean isTickStart) throws Throwable {
        if (isTickStart) {
            ServerCore.onServerTickStart(server);
        }
    }

    public void onPlayerTick(boolean isTickStart, boolean isServerSide, Player player) throws Throwable {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (isServerSide && isTickStart && player instanceof ServerPlayer && (serverData = ServerData.from(player.getServer())) != null) {
            serverData.getPlayerTickHandler().onTick((ServerPlayer)player, serverData);
        }
    }

    public void onServerStopped(MinecraftServer server) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        if (serverData != null) {
            serverData.onStop();
        }
        ServerCore.reset();
    }

    public void onRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        new PartyCommandRegister().register(dispatcher, environment);
        new ClaimsCommandRegister().register(dispatcher, environment);
        new CommonCommandRegister().register(dispatcher, environment);
    }

    public boolean onLeftClickBlock(Level level, BlockPos pos, Player player) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, serverLevel.getBlockState(pos), (Entity)player, serverLevel, pos, true);
    }

    public boolean onDestroyBlock(LevelAccessor levelAccessor, BlockPos pos, Player player) {
        if (!(levelAccessor instanceof Level)) {
            return false;
        }
        Level level = (Level)levelAccessor;
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, serverLevel.getBlockState(pos), (Entity)player, serverLevel, pos, true);
    }

    public boolean onEntityDestroyBlock(Level level, BlockPos pos, Entity entity) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, serverLevel.getBlockState(pos), entity, serverLevel, pos, false);
    }

    public boolean onRightClickBlock(Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitVec) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onBlockInteraction(serverData, serverLevel.getBlockState(pos), (Entity)player, hand, null, serverLevel, pos, hitVec.getDirection(), false, true);
    }

    public boolean onItemRightClick(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onItemRightClick(serverData, hand, itemStack, pos, (LivingEntity)player, true);
    }

    public boolean onItemUseTick(LivingEntity entityLiving, ItemStack itemStack) {
        InteractionHand hand;
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(entityLiving.level());
        if (serverLevel == null) {
            return false;
        }
        if (!EntityData.from((Entity)entityLiving).getShouldCheckItemUseTick()) {
            return false;
        }
        EntityData.from((Entity)entityLiving).setShouldCheckItemUseTick(false);
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        Object object = entityLiving.getItemInHand(InteractionHand.MAIN_HAND) == itemStack ? InteractionHand.MAIN_HAND : (hand = entityLiving.getItemInHand(InteractionHand.OFF_HAND) == itemStack ? InteractionHand.OFF_HAND : null);
        if (((ChunkProtection)serverData.getChunkProtection()).onItemRightClick(serverData, hand, itemStack, entityLiving.blockPosition(), entityLiving, true)) {
            entityLiving.stopUsingItem();
            return true;
        }
        return false;
    }

    public boolean onItemUseStop(LivingEntity entityLiving, ItemStack itemStack) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(entityLiving.level());
        if (serverLevel == null) {
            return false;
        }
        EntityData.from((Entity)entityLiving).setShouldCheckItemUseTick(false);
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        InteractionHand hand = entityLiving.getItemInHand(InteractionHand.MAIN_HAND) == itemStack ? InteractionHand.MAIN_HAND : (entityLiving.getItemInHand(InteractionHand.OFF_HAND) == itemStack ? InteractionHand.OFF_HAND : null);
        return ((ChunkProtection)serverData.getChunkProtection()).onItemRightClick(serverData, hand, itemStack, entityLiving.blockPosition(), entityLiving, true);
    }

    public boolean onMobGrief(Entity entity) {
        if (entity == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onMobGrief(serverData, entity);
    }

    public boolean onLivingHurt(DamageSource source, Entity target) {
        boolean isFire;
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.getServer());
        if (serverData == null) {
            return false;
        }
        boolean bl = isFire = source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE);
        if (!(source.getEntity() != null || source.getDirectEntity() != null || (source.is(DamageTypeTags.DAMAGES_HELMET) || source.is(DamageTypes.DRAGON_BREATH) || isFire || source.is(DamageTypeTags.IS_PROJECTILE) || source.is(DamageTypeTags.IS_EXPLOSION) || source.getMsgId().startsWith("create.")) && !source.is(DamageTypes.LAVA) && !source.is(DamageTypes.HOT_FLOOR))) {
            return false;
        }
        if (isFire) {
            return ((ChunkProtection)serverData.getChunkProtection()).onEntityFire(serverData, target);
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source.getEntity(), source.getDirectEntity(), target, null, InteractionHand.MAIN_HAND, true, source.getDirectEntity() instanceof Player, true);
    }

    protected boolean onEntityAttack(Player player, Entity target) {
        if (target == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.getServer());
        if (serverData == null) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        boolean result = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, (Entity)player, (Entity)player, target, null, InteractionHand.MAIN_HAND, true, true, true);
        if (result) {
            ServerCore.postResourcesDrop((Entity)player);
        }
        return result;
    }

    public boolean onEntityInteract(Entity source, Entity target, InteractionHand hand) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.getServer());
        if (serverData == null) {
            return false;
        }
        if (source.isSpectator()) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source, source, target, null, hand, false, false, true);
    }

    public boolean onInteractEntitySpecific(Entity source, Entity target, InteractionHand hand) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source, source, target, null, hand, false, true, true);
    }

    public void onExplosionDetonate(Level level, Explosion explosion, List<Entity> affectedEntities, List<BlockPos> affectedBlocks) {
        if (!(explosion instanceof ServerExplosion)) {
            return;
        }
        ServerExplosion serverExplosion = (ServerExplosion)explosion;
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        ((ChunkProtection)serverData.getChunkProtection()).onExplosionDetonate(serverData, serverLevel, serverExplosion, affectedEntities, affectedBlocks);
    }

    public boolean onChorusFruit(Entity entity, Vec3 target) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onChorusFruitTeleport(serverData, target, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEntityJoinWorld(Entity entity, Level level, boolean fromDisk) {
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (!serverLevel.getServer().isSameThread()) {
            return false;
        }
        try {
            Projectile projectile;
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
            Projectile spawnerProjectile = ServerCore.getHitProjectile(serverLevel.getServer().getTickCount());
            if (spawnerProjectile != null && ((ChunkProtection)(serverData = ServerData.from(spawnerProjectile.getServer())).getChunkProtection()).onProjectileHitSpawnedEntity(serverData, (Entity)spawnerProjectile, entity)) {
                boolean bl = true;
                return bl;
            }
            boolean isMobLoot = false;
            if (!(entity instanceof LivingEntity) && ServerCore.getDyingDamageSourceForCurrentEntitySpawns(serverLevel.getServer().getTickCount()) != null) {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData2 = ServerData.from(serverLevel.getServer());
                if (serverData2 == null) {
                    boolean itemEntity = false;
                    return itemEntity;
                }
                isMobLoot = true;
                if (((ChunkProtection)serverData2.getChunkProtection()).onLivingLootEntity(serverData2, ServerCore.getDyingLivingForCurrentEntitySpawns(serverLevel.getServer().getTickCount()), entity, ServerCore.getDyingDamageSourceForCurrentEntitySpawns(serverLevel.getServer().getTickCount()))) {
                    boolean itemEntity = true;
                    return itemEntity;
                }
            }
            if (entity instanceof Projectile && (projectile = (Projectile)entity).getOwner() != null && projectile.getOwner().level() == entity.level()) {
                SectionPos oldSection = SectionPos.of((BlockPos)projectile.getOwner().blockPosition());
                SectionPos newSection = SectionPos.of((BlockPos)entity.blockPosition());
                if (oldSection.x() != newSection.x() || oldSection.z() != newSection.z()) {
                    IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData3 = ServerData.from(entity.getServer());
                    ((ChunkProtection)serverData3.getChunkProtection()).onEntityEnterChunk(serverData3, entity, projectile.getOwner().getX(), projectile.getOwner().getZ(), newSection, oldSection);
                }
                boolean serverData3 = false;
                return serverData3;
            }
            if (!fromDisk && !isMobLoot && entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData4 = ServerData.from(serverLevel.getServer());
                if (serverData4 == null) {
                    boolean newSection = false;
                    return newSection;
                }
                boolean newSection = ((ChunkProtection)serverData4.getChunkProtection()).onItemAddedToWorld(serverData4, itemEntity);
                return newSection;
            }
            if (!fromDisk && entity.getClass() == this.createSuperGlueEntityClass) {
                BlockPos contraptionAnchor = ServerCore.getFreshAddedSuperGlueAnchor((Level)serverLevel);
                if (contraptionAnchor != null) {
                    IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData5 = ServerData.from(entity.getServer());
                    ServerCore.postCreateDisassembleSuperGlue();
                    boolean bl = ((ChunkProtection)serverData5.getChunkProtection()).onCreateGlueEntityFromAnchor(serverData5, entity, contraptionAnchor);
                    return bl;
                }
            } else if (entity instanceof ICreateContraptionEntity) {
                ICreateContraptionEntity contraptionEntity = (ICreateContraptionEntity)entity;
                CreateContraptionHelper.handleCreateContraptionAdded(entity, contraptionEntity);
            }
        }
        finally {
            if (EntityData.from(entity).getLastChunkEntryDimension() == null) {
                EntityData.from(entity).setLastChunkEntryDimension((ResourceKey<Level>)entity.level().dimension());
            }
            if (entity instanceof ItemEntity) {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
                ItemEntity itemEntity = (ItemEntity)entity;
                if (ServerCore.getItemEntityThrower(itemEntity) == null && ServerCore.getResourcesDropOwner() != null) {
                    itemEntity.setThrower(ServerCore.getResourcesDropOwner());
                }
                if (ServerCore.getItemEntityThrower(itemEntity) != null && ServerCore.getThrowerAccessor(itemEntity) == null && (serverData = ServerData.from(serverLevel.getServer())) != null) {
                    ((ChunkProtection)serverData.getChunkProtection()).setThrowerAccessor(itemEntity);
                }
            }
        }
        return false;
    }

    protected void onEntityEnteringSection(Entity entity, SectionPos oldSection, SectionPos newSection, boolean chunkChanged) {
        if (entity.getServer() != null && chunkChanged) {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
            if (serverData == null) {
                return;
            }
            if (entity.level().dimension().equals(EntityData.from(entity).getLastChunkEntryDimension())) {
                ((ChunkProtection)serverData.getChunkProtection()).onEntityEnterChunk(serverData, entity, entity.xOld, entity.zOld, newSection, oldSection);
            }
            EntityData.from(entity).setLastChunkEntryDimension((ResourceKey<Level>)entity.level().dimension());
            EntityData.from(entity).setShouldCheckItemUseTick(true);
        }
    }

    protected void onPermissionsChanged(ServerPlayer player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.getServer());
        if (serverData != null) {
            serverData.getPlayerPermissionChangeHandler().handle(player, serverData);
        }
    }

    protected boolean onCropTrample(Entity entity, BlockPos pos) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onCropTrample(serverData, entity, pos);
    }

    public boolean onBucketUse(Entity entity, Level level, HitResult hitResult, ItemStack itemStack) {
        if (entity.getServer() == null) {
            return false;
        }
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        return ((ChunkProtection)serverData.getChunkProtection()).onBucketUse(serverData, entity, serverLevel, hitResult, itemStack);
    }

    protected boolean onEntityPlaceBlock(LevelAccessor levelAccessor, BlockPos pos, Entity entity, BlockState placedBlock, BlockState replacedBlock) {
        if (!(levelAccessor instanceof Level)) {
            return false;
        }
        Level level = (Level)levelAccessor;
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (ServerCore.isHandlingEnchantmentOnBlocks(serverLevel)) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        if (serverData == null) {
            return false;
        }
        return placedBlock != null && !placedBlock.isAir() && ((ChunkProtection)serverData.getChunkProtection()).onEntityPlaceBlock(serverData, entity, serverLevel, pos, null);
    }

    protected boolean onEntityMultiPlaceBlock(LevelAccessor levelAccessor, Stream<Pair<BlockPos, BlockState>> blocks, Entity entity) {
        if (!(levelAccessor instanceof Level)) {
            return false;
        }
        Level level = (Level)levelAccessor;
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.getServer());
        if (serverData == null) {
            return false;
        }
        if (ServerCore.isHandlingEnchantmentOnBlocks(serverLevel)) {
            return false;
        }
        HashSet<ChunkPos> chunkPositions = new HashSet<ChunkPos>();
        Iterator iterator = blocks.iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            Pair blockEntry = (Pair)iterator.next();
            BlockPos pos = (BlockPos)blockEntry.getLeft();
            if (!chunkPositions.add(new ChunkPos(pos))) continue;
            BlockState placedBlock = (BlockState)blockEntry.getRight();
            if (placedBlock == null || placedBlock.isAir()) {
                return false;
            }
            result = result || ((ChunkProtection)serverData.getChunkProtection()).onEntityPlaceBlock(serverData, entity, serverLevel, pos, null);
        }
        return result;
    }

    protected void onTagsUpdate() {
        if (lastServerStarted == null || !lastServerStarted.isRunning() || !lastServerStarted.isSameThread()) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(lastServerStarted);
        if (serverData == null) {
            return;
        }
        ((ChunkProtection)serverData.getChunkProtection()).updateTagExceptions(lastServerStarted);
    }

    public boolean onItemPickup(Entity entity, ItemEntity itemEntity) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(itemEntity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onItemPickup(serverData, entity, itemEntity);
    }

    public boolean onMobSpawn(Entity entity, double x, double y, double z, EntitySpawnReason spawnReason) {
        if (spawnReason == EntitySpawnReason.CHUNK_GENERATION) {
            return false;
        }
        if (spawnReason == EntitySpawnReason.COMMAND) {
            return false;
        }
        if (spawnReason == EntitySpawnReason.SPAWN_ITEM_USE) {
            return false;
        }
        if (spawnReason == EntitySpawnReason.BREEDING) {
            return false;
        }
        if (spawnReason == EntitySpawnReason.BUCKET) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onMobSpawn(serverData, entity, x, y, z, spawnReason);
    }

    public boolean onProjectileImpact(HitResult hitResult, Projectile entity) {
        if (hitResult == null || hitResult.getType() == HitResult.Type.MISS) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.getServer());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onProjectileImpact(serverData, entity, hitResult);
    }

    public void onServerDataReload(ResourceManager resourceManager) {
        if (lastServerStarted != null && lastServerStarted.isSameThread()) {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(lastServerStarted);
            serverData.onServerResourcesReload(resourceManager);
        }
    }

    public void onAddonRegister(MinecraftServer server, IPlayerPermissionSystemRegisterAPI permissionSystemManagerAPI, IPlayerPartySystemRegisterAPI partySystemManagerAPI, IClaimsManagerTrackerRegisterAPI claimsManagerTrackerAPI) {
        if (this.modMain.getModSupport().LUCK_PERMS) {
            permissionSystemManagerAPI.register("luck_perms", this.modMain.getModSupport().getLuckPerms().getPermissionSystem());
        }
        if (this.modMain.getModSupport().FTB_RANKS) {
            permissionSystemManagerAPI.register("ftb_ranks", this.modMain.getModSupport().getFTBRanksSupport().getPermissionSystem());
        }
        if (this.modMain.getModSupport().PROMETHEUS) {
            permissionSystemManagerAPI.register("prometheus", this.modMain.getModSupport().getPrometheusSupport().getPermissionSystem());
        }
        if (this.modMain.getModSupport().FTB_TEAMS) {
            partySystemManagerAPI.register("ftb_teams", this.modMain.getModSupport().getFTBTeamsSupport().getPartySystem());
        }
        if (this.modMain.getModSupport().ARGONAUTS) {
            partySystemManagerAPI.register("argonauts", this.modMain.getModSupport().getArgonautsSupport().getPartySystem());
            partySystemManagerAPI.register("argonauts_guilds", this.modMain.getModSupport().getArgonautsSupport().createGuildSystem(server));
        }
    }
}

