/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.pac.common.server.core.ServerCore;

@Mixin(value={ReplaceBlock.class}, priority=1000001)
public class MixinReplaceBlock {
    @Inject(method={"apply"}, at={@At(value="HEAD")}, cancellable=true)
    public void onApplyHead(ServerLevel level, int i, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 pos, CallbackInfo ci) {
        if (ServerCore.captureEnchantmentEffectLevel(level, entity)) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"apply"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    public BlockPos replaceSetBlockPos(BlockPos actual) {
        return ServerCore.replaceEnchantmentEffectBlockPos(actual);
    }

    @Inject(method={"apply"}, at={@At(value="RETURN")})
    public void onApplyReturn(ServerLevel serverLevel, int i, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 vec3, CallbackInfo ci) {
        ServerCore.postEnchantmentEffectOnBlock();
    }
}

