/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimsClaimUpdatePosPacket
extends LazyPacket<ClientboundClaimsClaimUpdatePosPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimsClaimUpdatePosPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int x;
    private final int z;

    public ClientboundClaimsClaimUpdatePosPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundClaimsClaimUpdatePosPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("x", this.x);
        nbt.putInt("z", this.z);
        u.writeNbt((Tag)nbt);
    }

    public String toString() {
        return String.format("[%d, %d]", this.x, this.z);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimsClaimUpdatePosPacket> {
        @Override
        public ClientboundClaimsClaimUpdatePosPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (nbt == null) {
                    return null;
                }
                int x = nbt.getIntOr("x", 0);
                int z = nbt.getIntOr("z", 0);
                return new ClientboundClaimsClaimUpdatePosPacket(x, z);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimsClaimUpdatePosPacket> {
        @Override
        public void handle(ClientboundClaimsClaimUpdatePosPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimUpdatePos(t.x, t.z);
        }
    }
}

