/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.IPlayerConfigStringableOptionClientStorage;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.player.config.PlayerConfigHexOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigRangedOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStaticListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStringOptionSpec;

public final class ClientboundPlayerConfigDynamicOptionsPacket
extends PlayerConfigPacket {
    private static final String DEFAULT_VALUE_KEY = "d";
    private final List<PlayerConfigOptionSpec<?>> entries;

    public ClientboundPlayerConfigDynamicOptionsPacket(List<PlayerConfigOptionSpec<?>> entries) {
        this.entries = entries;
    }

    private static <T extends Comparable<T>> ValueType<T> getEntryValueType(PlayerConfigOptionSpec<T> entry) {
        return ValueType.ALL.get(entry.getType());
    }

    private static final class ValueType<T extends Comparable<T>> {
        private static final Map<Class<?>, ValueType<?>> ALL = new HashMap();
        private static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(Boolean.class, t -> t instanceof ByteTag, t -> ((ByteTag)t).byteValue() != 0, ByteTag::valueOf);
        private static final ValueType<Integer> INT = new ValueType<Integer>(Integer.class, t -> t instanceof IntTag, t -> ((IntTag)t).intValue(), IntTag::valueOf);
        private static final ValueType<Double> DOUBLE = new ValueType<Double>(Double.class, t -> t instanceof DoubleTag, t -> ((DoubleTag)t).doubleValue(), DoubleTag::valueOf);
        private static final ValueType<Float> FLOAT = new ValueType<Float>(Float.class, t -> t instanceof FloatTag, t -> Float.valueOf(((FloatTag)t).floatValue()), FloatTag::valueOf);
        private static final ValueType<String> STRING = new ValueType<String>(String.class, t -> t instanceof StringTag, t -> t.asString().orElse(null), StringTag::valueOf);
        private final Class<T> jType;
        private final Predicate<Tag> typeCheck;
        private final Function<Tag, T> valueUntagger;
        private final Function<T, Tag> valueTagger;

        private ValueType(Class<T> jType, Predicate<Tag> typeCheck, Function<Tag, T> valueUntagger, Function<T, Tag> valueTagger) {
            this.jType = jType;
            this.typeCheck = typeCheck;
            this.valueUntagger = valueUntagger;
            this.valueTagger = valueTagger;
            ALL.put(jType, this);
        }
    }

    public static abstract class OptionType {
        private static final Int2ObjectMap<OptionType> ALL = new Int2ObjectOpenHashMap();
        public static final OptionType DEFAULT = new OptionType(0){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, CompoundTag entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                return PlayerConfigOptionSpec.FinalBuilder.begin(type.jType);
            }
        };
        public static final OptionType HEX = new OptionType(1){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, CompoundTag entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                return PlayerConfigHexOptionSpec.Builder.begin();
            }
        };
        public static final OptionType RANGED = new OptionType(2){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigRangedOptionSpec option = (PlayerConfigRangedOptionSpec)o;
                Object minValue = option.getMinValue();
                Object maxValue = option.getMaxValue();
                Tag minTag = type.valueTagger.apply(minValue);
                Tag maxTag = type.valueTagger.apply(maxValue);
                entryTag.put("min", minTag);
                entryTag.put("max", maxTag);
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigRangedOptionSpec.Builder<Comparable> builder = PlayerConfigRangedOptionSpec.Builder.begin(type.jType);
                Tag minValueTag = entryTag.get("min");
                Tag maxValueTag = entryTag.get("max");
                builder.setMinValue((Comparable)type.valueUntagger.apply(minValueTag));
                builder.setMaxValue((Comparable)type.valueUntagger.apply(maxValueTag));
                return builder;
            }
        };
        public static final OptionType STRING = new OptionType(3){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigStringOptionSpec option = (PlayerConfigStringOptionSpec)o;
                entryTag.putInt("ml", option.getMaxLength());
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigStringOptionSpec.Builder builder = PlayerConfigStringOptionSpec.Builder.begin();
                builder.setMaxLength(entryTag.getIntOr("ml", 0));
                PlayerConfigStringOptionSpec.Builder result = builder;
                return result;
            }
        };
        public static final OptionType STATIC_LIST = new OptionType(4){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigStaticListIterationOptionSpec option = (PlayerConfigStaticListIterationOptionSpec)o;
                ListTag iterationListTag = new ListTag();
                for (Comparable el : option.getList()) {
                    iterationListTag.add((Object)type.valueTagger.apply(el));
                }
                entryTag.put("il", (Tag)iterationListTag);
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                PlayerConfigStaticListIterationOptionSpec.Builder builder = PlayerConfigStaticListIterationOptionSpec.Builder.begin(type.jType);
                ListTag iterationListTag = (ListTag)entryTag.get("il");
                ArrayList<Comparable> list = new ArrayList<Comparable>(iterationListTag.size());
                for (Tag elTag : iterationListTag) {
                    list.add((Comparable)type.valueUntagger.apply(elTag));
                }
                builder.setList(list);
                return builder;
            }
        };
        public static final OptionType UNSYNCABLE = new OptionType(5){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, CompoundTag entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, CompoundTag entryTag) {
                return null;
            }
        };
        private final int index;

        protected OptionType(int index) {
            this.index = index;
            ALL.put(index, (Object)this);
        }

        public abstract <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> var1, ValueType<T> var2, CompoundTag var3);

        public abstract <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> var1, CompoundTag var2);
    }

    public static class ClientHandler
    implements Consumer<ClientboundPlayerConfigDynamicOptionsPacket> {
        @Override
        public void accept(ClientboundPlayerConfigDynamicOptionsPacket packet) {
            PlayerConfigDynamicOptions.Builder dynamicOptionsBuilder = PlayerConfigDynamicOptions.Builder.begin();
            packet.entries.forEach(dynamicOptionsBuilder::addOption);
            PlayerConfigDynamicOptions dynamicOptions = dynamicOptionsBuilder.build();
            IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> playerConfigStorageManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager();
            playerConfigStorageManager.setDynamicOptions(dynamicOptions);
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundPlayerConfigDynamicOptionsPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ClientboundPlayerConfigDynamicOptionsPacket> {
        private <T extends Comparable<T>> PlayerConfigOptionSpec<T> getEntry(OptionType optionType, CompoundTag entryTag, Tag defaultValueTag, ValueType<T> type, String id, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, String comment, PlayerConfigOptionCategory category) {
            return ((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)optionType.buildSpec(type, entryTag).setId(id)).setTranslation(translation, translationArgs)).setCommentTranslation(commentTranslation, commentTranslationArgs)).setDefaultValue((Comparable)((Comparable)type.valueUntagger.apply(defaultValueTag)))).setComment(comment)).setCategory(category)).setDynamic(true)).build(null);
        }

        @Override
        public ClientboundPlayerConfigDynamicOptionsPacket apply(FriendlyByteBuf friendlyByteBuf) {
            try {
                if (friendlyByteBuf.readableBytes() > 0x20000000) {
                    return null;
                }
                CompoundTag tag = (CompoundTag)friendlyByteBuf.readNbt(NbtAccounter.unlimitedHeap());
                if (tag == null) {
                    return null;
                }
                ListTag entryListTag = tag.getListOrEmpty("l");
                ArrayList entries = new ArrayList(entryListTag.size());
                entryListTag.forEach(t -> {
                    CompoundTag entryTag = (CompoundTag)t;
                    int optionTypeIndex = entryTag.getIntOr("ot", 0);
                    OptionType optionType = (OptionType)OptionType.ALL.get(optionTypeIndex);
                    String id = entryTag.getStringOr("i", null);
                    String translation = entryTag.getStringOr("t", null);
                    String commentTranslation = entryTag.getStringOr("ct", null);
                    String comment = entryTag.getStringOr("c", null);
                    ListTag translationArgsTag = entryTag.getListOrEmpty("ta");
                    String[] translationArgs = new String[translationArgsTag.size()];
                    for (int i = 0; i < translationArgs.length; ++i) {
                        translationArgs[i] = translationArgsTag.getStringOr(i, null);
                    }
                    ListTag commentTranslationArgsTag = entryTag.getListOrEmpty("cta");
                    String[] commentTranslationArgs = new String[commentTranslationArgsTag.size()];
                    for (int i = 0; i < commentTranslationArgs.length; ++i) {
                        commentTranslationArgs[i] = commentTranslationArgsTag.getStringOr(i, null);
                    }
                    PlayerConfigOptionCategory category = PlayerConfigOptionCategory.values()[entryTag.getIntOr("cat", 0)];
                    Tag defaultValueTag = entryTag.get(ClientboundPlayerConfigDynamicOptionsPacket.DEFAULT_VALUE_KEY);
                    PlayerConfigOptionSpec<?> entry = null;
                    for (ValueType<?> valueType : ValueType.ALL.values()) {
                        if (!valueType.typeCheck.test(defaultValueTag)) continue;
                        entry = this.getEntry(optionType, entryTag, defaultValueTag, valueType, id, translation, translationArgs, commentTranslation, commentTranslationArgs, comment, category);
                        break;
                    }
                    if (entry != null) {
                        entries.add(entry);
                    }
                });
                return new ClientboundPlayerConfigDynamicOptionsPacket(entries);
            }
            catch (Throwable t2) {
                return null;
            }
        }

        private <T extends Comparable<T>> void handleValueAndOptionTypes(PlayerConfigOptionSpec<T> entry, CompoundTag entryTag) {
            ValueType<T> valueType = ClientboundPlayerConfigDynamicOptionsPacket.getEntryValueType(entry);
            Tag valueTag = valueType.valueTagger.apply(entry.getDefaultValue());
            entryTag.put(ClientboundPlayerConfigDynamicOptionsPacket.DEFAULT_VALUE_KEY, valueTag);
            entry.getSyncOptionType().serializeExtra(entry, valueType, entryTag);
        }

        @Override
        public void accept(ClientboundPlayerConfigDynamicOptionsPacket packet, FriendlyByteBuf friendlyByteBuf) {
            CompoundTag tag = new CompoundTag();
            ListTag entryListTag = new ListTag();
            for (PlayerConfigOptionSpec<?> entry : packet.entries) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putInt("ot", entry.getSyncOptionType().index);
                entryTag.putString("i", entry.getId());
                entryTag.putString("t", entry.getTranslation());
                entryTag.putString("ct", entry.getCommentTranslation());
                entryTag.putString("c", entry.getComment());
                ListTag translationArgsTag = new ListTag();
                for (String translationArg : entry.getTranslationArgs()) {
                    translationArgsTag.add((Object)StringTag.valueOf((String)translationArg));
                }
                entryTag.put("ta", (Tag)translationArgsTag);
                ListTag commentTranslationArgsTag = new ListTag();
                for (String translationArg : entry.getCommentTranslationArgs()) {
                    commentTranslationArgsTag.add((Object)StringTag.valueOf((String)translationArg));
                }
                entryTag.put("cta", (Tag)commentTranslationArgsTag);
                entryTag.putInt("cat", entry.getCategory().ordinal());
                this.handleValueAndOptionTypes(entry, entryTag);
                entryListTag.add((Object)entryTag);
            }
            tag.put("l", (Tag)entryListTag);
            friendlyByteBuf.writeNbt((Tag)tag);
        }
    }
}

