/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class ServerboundOtherPlayerConfigPacket
extends PlayerConfigPacket {
    private final String ownerName;

    public ServerboundOtherPlayerConfigPacket(String ownerName) {
        this.ownerName = ownerName;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundOtherPlayerConfigPacket, ServerPlayer> {
        @Override
        public void accept(ServerboundOtherPlayerConfigPacket t, ServerPlayer serverPlayer) {
            if (!serverPlayer.hasPermissions(2)) {
                OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to requesting another player's config! Name: " + serverPlayer.getGameProfile().getName());
                return;
            }
            serverPlayer.getServer().getProfileCache().get(t.ownerName).ifPresent(gp -> {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.getServer());
                IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
                IPlayerConfig config = playerConfigs.getLoadedConfig(gp.getId());
                ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(serverPlayer);
                playerData.getConfigSyncSpreadoutTask().addConfigToSync(config);
            });
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundOtherPlayerConfigPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ServerboundOtherPlayerConfigPacket> {
        @Override
        public ServerboundOtherPlayerConfigPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (nbt == null) {
                    return null;
                }
                String ownerName = nbt.getStringOr("ownerName", null);
                if (ownerName == null || !ownerName.matches("^[a-zA-Z0-9_]+$")) {
                    return null;
                }
                return new ServerboundOtherPlayerConfigPacket(ownerName);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundOtherPlayerConfigPacket t, FriendlyByteBuf u) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("ownerName", t.ownerName);
            u.writeNbt((Tag)nbt);
        }
    }
}

