/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfigDeletionStarter;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class ServerboundSubConfigExistencePacket
extends PlayerConfigPacket {
    private final String subId;
    private final UUID owner;
    private final PlayerConfigType type;
    private final boolean create;

    public ServerboundSubConfigExistencePacket(String subId, UUID owner, PlayerConfigType type, boolean create) {
        this.subId = subId;
        this.owner = owner;
        this.type = type;
        this.create = create;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundSubConfigExistencePacket, ServerPlayer> {
        @Override
        public void accept(ServerboundSubConfigExistencePacket t, ServerPlayer serverPlayer) {
            UUID ownerId;
            boolean isServer;
            if (t.type != PlayerConfigType.PLAYER && t.type != PlayerConfigType.SERVER) {
                OpenPartiesAndClaims.LOGGER.info("Someone is trying to create/delete a sub-config for an invalid config type! Name: " + serverPlayer.getGameProfile().getName());
                return;
            }
            boolean isOP = serverPlayer.hasPermissions(2);
            boolean bl = isServer = t.type == PlayerConfigType.SERVER;
            UUID uUID = isServer ? null : (ownerId = t.owner == null ? serverPlayer.getUUID() : t.owner);
            if (!isOP) {
                if (isServer) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config without required permissions! Name: " + serverPlayer.getGameProfile().getName());
                    return;
                }
                if (!Objects.equals(ownerId, serverPlayer.getUUID())) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to create/delete a sub-config for another player! Name: " + serverPlayer.getGameProfile().getName());
                    return;
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.getServer());
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            IPlayerConfig config = !isServer ? playerConfigs.getLoadedConfig(ownerId) : playerConfigs.getServerClaimConfig();
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(serverPlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            if (t.create) {
                boolean reachedLimit;
                boolean bl2 = reachedLimit = config.getSubCount() >= config.getSubConfigLimit();
                if (reachedLimit || config.createSubConfig(t.subId) == null || !isServer && !Objects.equals(ownerId, serverPlayer.getUUID())) {
                    playerConfigs.getSynchronizer().confirmSubConfigCreationSync(serverPlayer, config);
                    if (reachedLimit) {
                        MutableComponent limitReachedMessage = Component.translatable((String)"gui.xaero_pac_config_create_sub_id_limit_reached", (Object[])new Object[]{config.getSubConfigLimit()});
                        limitReachedMessage.withStyle(s -> s.withColor(ChatFormatting.RED));
                        serverPlayer.sendSystemMessage((Component)limitReachedMessage);
                    }
                }
            } else {
                IPlayerConfig subConfig = config.getSubConfig(t.subId);
                if (subConfig == null) {
                    return;
                }
                if (subConfig == config) {
                    return;
                }
                IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)serverData.getServerClaimsManager().getPlayerInfo(config.getPlayerId());
                if (playerInfo.hasReplacementTasks()) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"gui.xaero_pac_config_delete_sub_already_replacing"));
                    playerConfigs.getSynchronizer().syncGeneralState(serverPlayer, subConfig);
                    return;
                }
                new PlayerSubConfigDeletionStarter().start(serverPlayer, playerInfo, subConfig, serverData);
            }
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundSubConfigExistencePacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ServerboundSubConfigExistencePacket> {
        @Override
        public ServerboundSubConfigExistencePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 4096) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (nbt == null) {
                    return null;
                }
                String subId = nbt.getStringOr("subId", null);
                if (subId == null || subId.length() > 100) {
                    return null;
                }
                String typeString = nbt.getStringOr("type", null);
                if (typeString == null || typeString.length() > 100) {
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                UUID owner = XaeroNbtUtil.getUUID(nbt, "owner").orElse(null);
                boolean create = nbt.getBooleanOr("create", false);
                return new ServerboundSubConfigExistencePacket(subId, owner, type, create);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundSubConfigExistencePacket t, FriendlyByteBuf u) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("subId", t.subId);
            if (t.owner != null) {
                XaeroNbtUtil.putUUID(nbt, "owner", t.owner);
            }
            nbt.putString("type", t.type.name());
            nbt.putBoolean("create", t.create);
            u.writeNbt((Tag)nbt);
        }
    }
}

