/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.ClientPartyAllyInfo;
import xaero.pac.client.parties.party.api.IClientPartyAPI;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class ClientboundPartyAllyPacket
extends LazyPacket<ClientboundPartyAllyPacket> {
    public static final LazyPacket.Encoder<ClientboundPartyAllyPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final Action action;
    private final ClientPartyAllyInfo allyInfo;

    public ClientboundPartyAllyPacket(Action action, ClientPartyAllyInfo allyInfo) {
        this.action = action;
        this.allyInfo = allyInfo;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundPartyAllyPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        XaeroNbtUtil.putUUID(tag, "i", this.allyInfo.getAllyId());
        tag.putString("n", this.allyInfo.getAllyName());
        tag.putString("dn", this.allyInfo.getAllyDefaultName());
        tag.putString("a", this.action.toString());
        u.writeNbt((Tag)tag);
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.action, this.allyInfo.getAllyName(), this.allyInfo.getAllyDefaultName()});
    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundPartyAllyPacket> {
        @Override
        public ClientboundPartyAllyPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 102400) {
                    return null;
                }
                CompoundTag tag = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (tag == null) {
                    return null;
                }
                UUID allyId = XaeroNbtUtil.getUUID(tag, "i").orElse(null);
                String allyName = tag.getStringOr("n", null);
                if (allyName.length() > 512) {
                    return null;
                }
                String allyDefaultName = tag.getStringOr("dn", null);
                if (allyDefaultName.length() > 512) {
                    return null;
                }
                String actionString = tag.getStringOr("a", null);
                if (actionString == null || actionString.length() > 128) {
                    return null;
                }
                Action action = Action.valueOf(actionString);
                return new ClientboundPartyAllyPacket(action, new ClientPartyAllyInfo(allyId, allyName, allyDefaultName));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyAllyPacket> {
        @Override
        public void handle(ClientboundPartyAllyPacket t) {
            IClientPartyAPI party = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty();
            if (party == null) {
                return;
            }
            if (t.action == Action.ADD) {
                party.addAllyParty(t.allyInfo.getAllyId());
            } else {
                party.removeAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.UPDATE) {
                party.addAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.REMOVE) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getAllyInfoStorage().remove(t.allyInfo.getAllyId());
            } else {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getAllyInfoStorage().add(t.allyInfo);
            }
        }
    }
}

