/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.gui.MainMenu;
import xaero.pac.client.gui.OtherPlayerConfigWaitScreen;
import xaero.pac.client.gui.XPACScreen;
import xaero.pac.client.gui.widget.FixedEditBox;
import xaero.pac.client.world.capability.ClientWorldMainCapability;
import xaero.pac.client.world.capability.api.ClientWorldCapabilityTypes;

public class ConfigMenu
extends XPACScreen {
    private static final Component ANOTHER_PLAYER_TITLE = Component.translatable((String)"gui.xaero_pac_ui_other_player_config_name_title");
    private boolean serverHasMod;
    private Button myPlayerConfigButton;
    private Button serverClaimsConfigButton;
    private Button expiredClaimsConfigButton;
    private Button wildernessConfigButton;
    private Button defaultConfigButton;
    private Button otherPlayerConfigButton;
    private EditBox otherPlayerNameBox;
    private static String otherPlayerNameString = "";

    public ConfigMenu(Screen escape, Screen parent) {
        super(escape, parent, (Component)Component.translatable((String)"gui.xaero_pac_ui_config_menu"));
    }

    @Override
    protected void init() {
        super.init();
        this.myPlayerConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_my_player_config"), this::onPlayerConfigButton).bounds(this.width / 2 - 100, this.height / 7 + 8, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.myPlayerConfigButton);
        this.serverClaimsConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_server_claims_config"), this::onServerClaimsConfigButton).bounds(this.width / 2 - 100, this.height / 7 + 32, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.serverClaimsConfigButton);
        this.expiredClaimsConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_expired_claims_config"), this::onExpiredClaimsConfigButton).bounds(this.width / 2 - 100, this.height / 7 + 56, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.expiredClaimsConfigButton);
        this.wildernessConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_wilderness_config"), this::onWildernessConfigButton).bounds(this.width / 2 - 100, this.height / 7 + 80, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.wildernessConfigButton);
        this.defaultConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_default_player_config"), this::onDefaultConfigButton).bounds(this.width / 2 - 100, this.height / 7 + 104, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.defaultConfigButton);
        this.otherPlayerNameBox = new FixedEditBox(this.font, this.width / 2 - 99, this.height / 7 + 148, 98, 20, (Component)Component.translatable((String)"gui.xaero_pac_ui_other_player_config_name_field"));
        this.addRenderableWidget((GuiEventListener)this.otherPlayerNameBox);
        this.otherPlayerConfigButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_other_player_config_button"), this::onOtherPlayerConfigButton).bounds(this.width / 2, this.height / 7 + 148, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.otherPlayerConfigButton);
        this.updateOtherPlayerButton();
        ClientWorldMainCapability mainCap = (ClientWorldMainCapability)OpenPartiesAndClaims.INSTANCE.getCapabilityHelper().getCapability(this.minecraft.level, ClientWorldCapabilityTypes.MAIN_CAP);
        this.otherPlayerNameBox.setValue(otherPlayerNameString);
        this.otherPlayerNameBox.setResponder(s -> {
            otherPlayerNameString = s;
            this.updateOtherPlayerButton();
        });
        this.otherPlayerNameBox.setEditable(mainCap.getClientWorldData().serverHasMod() && this.minecraft.player.hasPermissions(2));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_pac_back"), this::onBackButton).bounds(this.width / 2 - 100, this.height / 6 + 168, 200, 20).build());
        this.myPlayerConfigButton.active = this.serverClaimsConfigButton.active = mainCap.getClientWorldData().serverHasMod();
        this.serverHasMod = this.serverClaimsConfigButton.active;
        this.defaultConfigButton.active = mainCap.getClientWorldData().serverHasMod() && this.minecraft.player.hasPermissions(2);
        this.wildernessConfigButton.active = this.defaultConfigButton.active;
        this.expiredClaimsConfigButton.active = this.defaultConfigButton.active;
    }

    private void onBackButton(Button b) {
        this.goBack();
    }

    private void onPlayerConfigButton(Button b) {
        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager().openMyPlayerConfigScreen(this.escape, this);
    }

    private void onServerClaimsConfigButton(Button b) {
        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager().openServerClaimsConfigScreen(this.escape, this);
    }

    private void onExpiredClaimsConfigButton(Button b) {
        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager().openExpiredClaimsConfigScreen(this.escape, this);
    }

    private void onWildernessConfigButton(Button b) {
        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager().openWildernessConfigScreen(this.escape, this);
    }

    private void onDefaultConfigButton(Button b) {
        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager().openDefaultPlayerConfigScreen(this.escape, this);
    }

    private boolean isPlayerNameAllowed() {
        return !otherPlayerNameString.isEmpty() && !otherPlayerNameString.equalsIgnoreCase(this.minecraft.player.getGameProfile().getName());
    }

    private void onOtherPlayerConfigButton(Button b) {
        if (this.isPlayerNameAllowed()) {
            this.minecraft.setScreen((Screen)new OtherPlayerConfigWaitScreen(this.escape, (Screen)this, otherPlayerNameString));
        }
    }

    private void updateOtherPlayerButton() {
        ClientWorldMainCapability mainCap = (ClientWorldMainCapability)OpenPartiesAndClaims.INSTANCE.getCapabilityHelper().getCapability(this.minecraft.level, ClientWorldCapabilityTypes.MAIN_CAP);
        this.otherPlayerConfigButton.active = mainCap.getClientWorldData().serverHasMod() && this.minecraft.player.hasPermissions(2) && this.isPlayerNameAllowed();
    }

    public void tick() {
        super.tick();
    }

    public boolean keyPressed(int p_96552_, int p_96553_, int p_96554_) {
        if (this.otherPlayerNameBox.isFocused() && (p_96552_ == 257 || p_96552_ == 335) && this.isPlayerNameAllowed()) {
            this.setFocused(null);
            this.otherPlayerConfigButton.onPress();
            return true;
        }
        return super.keyPressed(p_96552_, p_96553_, p_96554_);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 16, -1);
        guiGraphics.drawCenteredString(this.font, ANOTHER_PLAYER_TITLE, this.width / 2, this.height / 7 + 132, -1);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        if (!this.serverHasMod) {
            guiGraphics.drawCenteredString(this.font, MainMenu.NO_HANDSHAKE, this.width / 2, 27, -43691);
        }
    }
}

