/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.WidgetListScreen;

public final class PickerWidgetListElement<T>
extends SimpleValueWidgetListElement<T, PickerWidgetListElement<T>> {
    private int currentIndex;
    private final List<T> options;
    private final T defaultValue;
    private Button prevButton;
    private Button nextButton;
    private Button defaultButton;
    private final BiConsumer<T, Button> valueChangeConsumer;

    private PickerWidgetListElement(int w, int h, boolean mutable, BiFunction<PickerWidgetListElement<T>, Vec3i, AbstractWidget> widgetSupplier, List<FormattedCharSequence> tooltip, T startValue, int startIndex, List<T> options, T defaultValue, BiConsumer<T, Button> valueChangeConsumer) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.options = options;
        this.currentIndex = startIndex;
        this.defaultValue = defaultValue;
        this.valueChangeConsumer = valueChangeConsumer;
    }

    @Override
    public AbstractWidget screenInit(int x, int y, WidgetListScreen screen, List<EditBox> tickableBoxes) {
        this.prevButton = (Button)super.screenInit(x, y, screen, tickableBoxes);
        this.defaultButton = Button.builder((Component)Component.literal((String)"-"), this::onDefaultButton).bounds(x + this.w - 20, y, 20, 20).build();
        screen.addRenderableWidget(this.defaultButton);
        this.updateDefaultButton();
        this.nextButton = Button.builder((Component)Component.literal((String)">"), this::onNextButton).bounds(x + this.w - 40, y, 20, 20).build();
        screen.addRenderableWidget(this.nextButton);
        return this.prevButton;
    }

    private void updateDefaultButton() {
        this.defaultButton.active = !Objects.equals(this.draftValue, this.defaultValue);
    }

    private void updateValue(Button b) {
        this.draftValue = this.options.get(this.currentIndex);
        this.valueChangeConsumer.accept(this.draftValue, b);
        this.updateDefaultButton();
    }

    private void onDefaultButton(Button b) {
        this.currentIndex = this.options.indexOf(this.defaultValue);
        if (this.currentIndex == -1) {
            this.currentIndex = 0;
        }
        this.updateValue(b);
    }

    private void onPrevButton(Button b) {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.options.size() - 1;
        }
        this.updateValue(b);
    }

    private void onNextButton(Button b) {
        this.currentIndex = (this.currentIndex + 1) % this.options.size();
        this.updateValue(b);
    }

    @Override
    public void render(GuiGraphics guiGraphics) {
        super.render(guiGraphics);
        String subName = Objects.toString(this.draftValue);
        int subNameW = Minecraft.getInstance().font.width(subName);
        guiGraphics.drawString(Minecraft.getInstance().font, subName, this.x + 90 - subNameW / 2, this.y + 6, this.mutable ? -1 : 0xE0E0E0);
    }

    public static final class Builder<T>
    extends SimpleValueWidgetListElement.Builder<T, PickerWidgetListElement<T>, Builder<T>> {
        private int startIndex;
        private List<T> options;
        private T defaultValue;
        private BiConsumer<T, Button> valueChangeConsumer;

        @Override
        public Builder<T> setDefault() {
            super.setDefault();
            this.setStartIndex(-1);
            this.setOptions(null);
            this.setDefaultValue(null);
            this.setValueChangeConsumer((v, b) -> {});
            return (Builder)this.self;
        }

        @Override
        public Builder<T> setStartValue(T startValue) {
            if (startValue != null) {
                throw new IllegalArgumentException();
            }
            return (Builder)super.setStartValue(startValue);
        }

        public Builder<T> setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return (Builder)this.self;
        }

        public Builder<T> setOptions(List<T> options) {
            this.options = options;
            return (Builder)this.self;
        }

        public Builder<T> setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return (Builder)this.self;
        }

        public Builder<T> setValueChangeConsumer(BiConsumer<T, Button> valueChangeConsumer) {
            this.valueChangeConsumer = valueChangeConsumer;
            return (Builder)this.self;
        }

        @Override
        public PickerWidgetListElement<T> build() {
            if (this.startIndex == -1 || this.options == null || this.valueChangeConsumer == null) {
                throw new IllegalStateException();
            }
            this.startValue = this.options.get(this.startIndex);
            if (this.defaultValue == null) {
                this.defaultValue = this.startValue;
            }
            return (PickerWidgetListElement)super.build();
        }

        @Override
        protected PickerWidgetListElement<T> buildInternal() {
            BiFunction widgetSupplier = (el, xy) -> Button.builder((Component)Component.literal((String)"<"), el::onPrevButton).bounds(xy.getX(), xy.getY(), 20, 20).build();
            return new PickerWidgetListElement<Object>(this.w, this.h, this.mutable, widgetSupplier, this.tooltip, this.startValue, this.startIndex, this.options, this.defaultValue, this.valueChangeConsumer);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

