/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.PlayNetworkDirection;
import net.neoforged.neoforge.network.simple.MessageFunctions;

public class PacketConsumerNeoForge<P>
implements MessageFunctions.MessageConsumer<P> {
    private final BiConsumer<P, ServerPlayer> serverHandler;
    private final Consumer<P> clientHandler;

    public PacketConsumerNeoForge(BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    public void handle(P msg, NetworkEvent.Context context) {
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        INetworkDirection networkDirection = context.getDirection();
        if (this.clientHandler != null && networkDirection == PlayNetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> this.clientHandler.accept(msg));
        } else if (this.serverHandler != null && networkDirection == PlayNetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.accept(msg, sender));
        }
        context.setPacketHandled(true);
    }
}

