/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.PlayNetworkDirection;
import net.neoforged.neoforge.network.simple.SimpleChannel;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.IPacketHandler;
import xaero.pac.common.packet.PacketConsumerNeoForge;

public class PacketHandlerNeoForge
implements IPacketHandler {
    private static final int PROTOCOL_VERSION = 1004000;
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)OpenPartiesAndClaims.MAIN_CHANNEL_LOCATION).networkProtocolVersion(() -> "1004000").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerNeoForge<P> consumer = new PacketConsumerNeoForge<P>(serverHandler, clientHandler);
        if (serverHandler == null != (clientHandler == null)) {
            NETWORK.messageBuilder(type, index, (INetworkDirection)(clientHandler != null ? PlayNetworkDirection.PLAY_TO_CLIENT : PlayNetworkDirection.PLAY_TO_SERVER)).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
        } else {
            NETWORK.messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
        }
    }

    public void sendToServer(Object packet) {
        NETWORK.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public void sendToPlayer(ServerPlayer player, Object packet) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

