/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.parties.party.Party;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObject;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.util.linked.ILinkedChainNode;
import xaero.pac.common.util.linked.LinkedChain;

public final class ServerParty
extends Party
implements IServerParty<PartyMember, PartyInvite, PartyAlly>,
ObjectManagerIOExpirableObject,
ILinkedChainNode<ServerParty> {
    private final PartyManager managedBy;
    private boolean dirty;
    private long registeredActivity;
    private ServerParty nextInChain;
    private ServerParty prevInChain;
    private boolean destroyed;
    private final Map<String, PartyMember> memberInfoByUsername;
    private final Map<String, PartyInvite> inviteByUsername;
    private final Map<String, PartyAlly> allyByUsername;
    private final Map<UUID, String> usernameByAlly;

    protected ServerParty(PartyManager managedBy, PartyMember owner, UUID id, List<PartyMember> staffInfo, Map<UUID, PartyMember> memberInfo, LinkedChain<PartyMember> linkedMemberInfo, Map<UUID, PartyInvite> invitedPlayers, LinkedChain<PartyInvite> linkedInvitedPlayers, Map<UUID, PartyAlly> allyParties, LinkedChain<PartyAlly> linkedAllyParties, Map<String, PartyMember> memberInfoByUsername, Map<String, PartyInvite> inviteByUsername, Map<String, PartyAlly> allyByUsername, Map<UUID, String> usernameByAlly) {
        super(owner, id, staffInfo, memberInfo, linkedMemberInfo, invitedPlayers, linkedInvitedPlayers, allyParties, linkedAllyParties);
        this.managedBy = managedBy;
        this.memberInfoByUsername = memberInfoByUsername;
        this.inviteByUsername = inviteByUsername;
        this.allyByUsername = allyByUsername;
        this.usernameByAlly = usernameByAlly;
        this.registeredActivity = managedBy.getExpirationHandler().getServerInfo().getTotalUseTime();
    }

    @Override
    public boolean changeOwner(UUID newOwnerId, String newOwnerUsername) {
        PartyMember oldOwner = this.getOwner();
        boolean result = super.changeOwner(newOwnerId, newOwnerUsername);
        if (result) {
            this.memberInfoByUsername.put(oldOwner.getUsername().toLowerCase(), this.getMemberInfo(oldOwner.getUUID()));
            this.memberInfoByUsername.put(this.owner.getUsername().toLowerCase(), this.owner);
            if (this.managedBy != null) {
                this.managedBy.onOwnerChange(oldOwner, this.owner);
                if (this.managedBy.isLoaded()) {
                    this.managedBy.getPartySynchronizer().syncToPartyUpdateOwner(this);
                    IPlayerConfig newOwnerConfig = this.managedBy.getPlayerConfigs().getLoadedConfig(newOwnerId);
                    this.managedBy.getPartySynchronizer().syncToPartyAndAlliersUpdateName(this, newOwnerConfig.getEffective(PlayerConfigOptions.PARTY_NAME));
                }
            }
            this.setDirty(true);
        }
        return result;
    }

    @Override
    public PartyMember addMember(@Nonnull UUID memberUUID, @Nullable PartyMemberRank rank, @Nonnull String playerUsername) {
        if (this.managedBy != null && this.managedBy.getPartyByMember(memberUUID) != null) {
            return null;
        }
        PartyMember m = super.addMember(memberUUID, rank, playerUsername);
        if (m == null) {
            return null;
        }
        this.setDirty(true);
        return m;
    }

    @Override
    public PartyMember addMemberClean(UUID memberUUID, PartyMemberRank rank, String playerUsername) {
        PartyMember m = super.addMemberClean(memberUUID, rank, playerUsername);
        if (m == null) {
            return null;
        }
        String playerUsernameLowerCase = playerUsername.toLowerCase();
        PartyMember sameNameMember = this.memberInfoByUsername.get(playerUsernameLowerCase);
        if (sameNameMember != null) {
            this.updateUsername(sameNameMember, "" + sameNameMember.getUUID());
        }
        this.memberInfoByUsername.put(playerUsernameLowerCase, m);
        if (this.managedBy != null) {
            this.managedBy.onMemberAdded(this, m);
            if (this.managedBy.isLoaded()) {
                this.managedBy.getPartySynchronizer().syncToPartyAddMember(this, m);
            }
        }
        return m;
    }

    @Override
    public PartyMember removeMember(@Nonnull UUID memberUUID) {
        PartyMember m = super.removeMember(memberUUID);
        if (m == null) {
            return null;
        }
        if (this.managedBy != null) {
            this.managedBy.onMemberRemoved(this, m);
            if (this.managedBy.isLoaded()) {
                this.managedBy.getPartySynchronizer().syncToPartyRemoveMember(this, m);
            }
        }
        this.memberInfoByUsername.remove(m.getUsername().toLowerCase());
        this.setDirty(true);
        return m;
    }

    @Override
    @Nullable
    public PartyMember getMemberInfo(@Nonnull String username) {
        return this.memberInfoByUsername.get(username.toLowerCase());
    }

    @Override
    public void addAllyParty(@Nonnull UUID partyId) {
        super.addAllyParty(partyId);
        this.setDirty(true);
    }

    @Override
    public void addAllyPartyClean(UUID partyId) {
        super.addAllyPartyClean(partyId);
        if (this.managedBy.isLoaded()) {
            this.updateAllyNameMap(partyId, this.managedBy.getPartyById(partyId).getOwner().getUsername());
        }
        this.managedBy.onAllyAdded(this, partyId);
    }

    @Override
    public void removeAllyParty(@Nonnull UUID partyId) {
        super.removeAllyParty(partyId);
        if (this.managedBy.isLoaded()) {
            this.updateAllyNameMap(partyId, null);
        }
        this.setDirty(true);
        this.managedBy.onAllyRemoved(this, partyId, false);
    }

    @Override
    public PartyAlly getAlly(String ownerUsername) {
        return this.allyByUsername.get(ownerUsername.toLowerCase());
    }

    @Override
    public PartyInvite invitePlayer(@Nonnull UUID playerUUID, @Nonnull String playerUsername) {
        PartyInvite result = super.invitePlayer(playerUUID, playerUsername);
        if (result != null) {
            this.setDirty(true);
        }
        return result;
    }

    @Override
    public PartyInvite invitePlayerClean(UUID playerUUID, String playerUsername) {
        PartyInvite playerInfo = super.invitePlayerClean(playerUUID, playerUsername);
        if (playerInfo == null) {
            return null;
        }
        String playerUsernameLowercase = playerUsername.toLowerCase();
        PartyInvite sameNameInvite = this.inviteByUsername.get(playerUsernameLowercase);
        if (sameNameInvite != null) {
            sameNameInvite.setUsername("" + sameNameInvite.getUUID());
        }
        this.inviteByUsername.put(playerUsernameLowercase, playerInfo);
        if (this.managedBy.isLoaded()) {
            this.managedBy.getPartySynchronizer().syncToPartyAddInvite(this, playerInfo);
        }
        return playerInfo;
    }

    @Override
    public PartyInvite uninvitePlayer(@Nonnull UUID playerUUID) {
        PartyInvite playerInfo = super.uninvitePlayer(playerUUID);
        if (playerInfo == null) {
            return null;
        }
        this.setDirty(true);
        return playerInfo;
    }

    @Override
    protected PartyInvite removeInvitedPlayer(UUID playerId) {
        PartyInvite playerInfo = super.removeInvitedPlayer(playerId);
        if (playerInfo != null) {
            this.inviteByUsername.remove(playerInfo.getUsername().toLowerCase());
        }
        if (playerInfo != null && this.managedBy.isLoaded()) {
            this.managedBy.getPartySynchronizer().syncToPartyRemoveInvite(this, playerInfo);
        }
        return playerInfo;
    }

    @Override
    public PartyInvite getInvite(String username) {
        return this.inviteByUsername.get(username.toLowerCase());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (!this.dirty && dirty && this.managedBy != null) {
            this.managedBy.addToSave(this);
        }
        this.dirty = dirty;
    }

    @Override
    public String getFileName() {
        return this.getId().toString();
    }

    @Override
    public boolean setRankTyped(@Nonnull PartyMember member, @Nonnull PartyMemberRank rank) {
        if (!super.setRankTyped(member, rank)) {
            return false;
        }
        this.setDirty(true);
        if (this.managedBy.isLoaded()) {
            this.managedBy.getPartySynchronizer().syncToPartyUpdateMember(this, member);
        }
        return true;
    }

    @Override
    public boolean updateUsername(PartyMember member, String username) {
        String oldName = member.getUsername();
        if (Objects.equals(oldName, username) || this.getMemberInfo(member.getUUID()) != member) {
            return false;
        }
        member.setUsername(username);
        this.memberInfoByUsername.remove(oldName.toLowerCase());
        this.memberInfoByUsername.put(username.toLowerCase(), member);
        this.setDirty(true);
        if (this.managedBy.isLoaded()) {
            if (this.owner != member) {
                this.managedBy.getPartySynchronizer().syncToPartyUpdateMember(this, member);
            } else {
                UUID partyId = this.getId();
                this.managedBy.getTypedPartiesThatAlly(partyId).forEach(allier -> allier.updateAllyNameMap(partyId, username));
                this.managedBy.getPartySynchronizer().syncToPartyUpdateOwner(this);
            }
        }
        return true;
    }

    public void updateAllyNameMap(UUID allyId, String username) {
        String oldName = this.usernameByAlly.get(allyId);
        if (oldName != null) {
            this.allyByUsername.remove(oldName);
        }
        if (username == null) {
            this.usernameByAlly.remove(allyId);
            return;
        }
        String usernameLowercase = username.toLowerCase();
        this.allyByUsername.put(usernameLowercase, this.getAlly(allyId));
        this.usernameByAlly.put(allyId, usernameLowercase);
    }

    @Override
    @Nonnull
    public Stream<ServerPlayer> getOnlineMemberStream() {
        PlayerList playerList = this.managedBy.getServer().getPlayerList();
        if (playerList.getPlayerCount() > this.getMemberCount()) {
            return this.getTypedMemberInfoStream().map(mi -> playerList.getPlayer(mi.getUUID())).filter(Objects::nonNull);
        }
        return playerList.getPlayers().stream().filter(p -> this.getMemberInfo(p.getUUID()) != null);
    }

    @Override
    public void registerActivity(ServerInfo serverInfo) {
        if (serverInfo.getTotalUseTime() < this.registeredActivity) {
            return;
        }
        this.registeredActivity = serverInfo.getTotalUseTime();
        this.setDirty(true);
    }

    public void setRegisteredActivity(long registeredActivity) {
        this.registeredActivity = registeredActivity;
    }

    @Override
    public long getRegisteredActivity() {
        return this.registeredActivity;
    }

    @Override
    public void setNext(ServerParty element) {
        this.nextInChain = element;
    }

    @Override
    public void setPrevious(ServerParty element) {
        this.prevInChain = element;
    }

    @Override
    public ServerParty getNext() {
        return this.nextInChain;
    }

    @Override
    public ServerParty getPrevious() {
        return this.prevInChain;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void onDestroyed() {
        this.destroyed = true;
    }

    public static final class Builder
    extends Party.Builder {
        private boolean managed = true;
        private PartyManager managedBy;

        private Builder() {
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setManaged(false);
            this.setManagedBy(null);
            return this;
        }

        public Builder setManaged(boolean managed) {
            this.managed = managed;
            return this;
        }

        public Builder setManagedBy(PartyManager managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public Builder setOwner(PartyMember owner) {
            super.setOwner(owner);
            return this;
        }

        @Override
        public Builder setId(UUID id) {
            super.setId(id);
            return this;
        }

        @Override
        public Builder setMemberInfo(Map<UUID, PartyMember> memberInfo) {
            super.setMemberInfo(memberInfo);
            return this;
        }

        @Override
        public Builder setInvitedPlayers(Map<UUID, PartyInvite> invitedPlayers) {
            super.setInvitedPlayers(invitedPlayers);
            return this;
        }

        @Override
        public Builder setAllyParties(Map<UUID, PartyAlly> allyParties) {
            super.setAllyParties(allyParties);
            return this;
        }

        @Override
        public ServerParty build() {
            if (this.managed && this.managedBy == null) {
                throw new IllegalStateException();
            }
            return (ServerParty)super.build();
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        protected ServerParty buildInternally(List<PartyMember> staffInfo, LinkedChain<PartyMember> linkedMemberInfo, LinkedChain<PartyInvite> linkedInvitedPlayers, LinkedChain<PartyAlly> linkedAllyParties) {
            HashMap<String, PartyMember> memberInfoByUsername = new HashMap<String, PartyMember>();
            HashMap<String, PartyInvite> inviteByUsername = new HashMap<String, PartyInvite>();
            HashMap<String, PartyAlly> allyByUsername = new HashMap<String, PartyAlly>();
            HashMap<UUID, String> usernameByAlly = new HashMap<UUID, String>();
            memberInfoByUsername.put(this.owner.getUsername().toLowerCase(), this.owner);
            this.memberInfo.values().forEach(m -> memberInfoByUsername.put(m.getUsername().toLowerCase(), (PartyMember)m));
            this.invitedPlayers.values().forEach(i -> inviteByUsername.put(i.getUsername().toLowerCase(), (PartyInvite)i));
            return new ServerParty(this.managedBy, this.owner, this.id, staffInfo, this.memberInfo, linkedMemberInfo, this.invitedPlayers, linkedInvitedPlayers, this.allyParties, linkedAllyParties, memberInfoByUsername, inviteByUsername, allyByUsername, usernameByAlly);
        }
    }
}

