/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.entity;

import net.mcreator.thedeepvoid.init.TheDeepVoidModEntities;
import net.mcreator.thedeepvoid.init.TheDeepVoidModItems;
import net.mcreator.thedeepvoid.procedures.BoneBallProjectileProjectileHitsLivingEntityProcedure;
import net.mcreator.thedeepvoid.procedures.BoneBallProjectileWhileProjectileFlyingTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BoneBallProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)TheDeepVoidModItems.BONE_BALL.get());

    public BoneBallProjectileEntity(EntityType<? extends BoneBallProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public BoneBallProjectileEntity(EntityType<? extends BoneBallProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public BoneBallProjectileEntity(EntityType<? extends BoneBallProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)TheDeepVoidModItems.BONE_BALL.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        BoneBallProjectileProjectileHitsLivingEntityProcedure.execute(entityHitResult.getEntity());
    }

    public void tick() {
        super.tick();
        BoneBallProjectileWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static BoneBallProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BoneBallProjectileEntity.shoot(world, entity, source, 1.2f, 2.0, 1);
    }

    public static BoneBallProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BoneBallProjectileEntity.shoot(world, entity, source, pullingPower * 1.2f, 2.0, 1);
    }

    public static BoneBallProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BoneBallProjectileEntity entityarrow = new BoneBallProjectileEntity((EntityType<? extends BoneBallProjectileEntity>)((EntityType)TheDeepVoidModEntities.BONE_BALL_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.snowball.throw")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static BoneBallProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        BoneBallProjectileEntity entityarrow = new BoneBallProjectileEntity((EntityType<? extends BoneBallProjectileEntity>)((EntityType)TheDeepVoidModEntities.BONE_BALL_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.4f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(2.0);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.snowball.throw")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

