/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.item;

import java.util.List;
import net.mcreator.thedeepvoid.procedures.VoidPendantHasItemGlowingEffectProcedure;
import net.mcreator.thedeepvoid.procedures.VoidPendantItemInHandTickProcedure;
import net.mcreator.thedeepvoid.procedures.VoidPendantPlayerFinishesUsingItemProcedure;
import net.mcreator.thedeepvoid.procedures.VoidPendantRightclickedOnBlockProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VoidPendantItem
extends Item {
    public VoidPendantItem() {
        super(new Item.Properties().durability(3).rarity(Rarity.UNCOMMON).food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack itemstack) {
        return -42;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return VoidPendantHasItemGlowingEffectProcedure.execute(itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a79Once used:"));
        list.add((Component)Component.literal((String)" \u00a77Teleports you back to the Overworld"));
        list.add((Component)Component.literal((String)" \u00a77Use on a Void Core to link it to it."));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        VoidPendantPlayerFinishesUsingItemProcedure.execute((LevelAccessor)world, (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        VoidPendantRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), context.getItemInHand());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            VoidPendantItemInHandTickProcedure.execute(entity, itemstack);
        }
    }
}

