/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.network;

import java.util.function.Supplier;
import net.mcreator.thedeepvoid.TheDeepVoidMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheDeepVoidModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"the_deep_void");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheDeepVoidMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        TheDeepVoidMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("the_deep_void", "saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("the_deep_void", "player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double StalkerCount = 0.0;
        public double ForgottenValleyAmbientSound = 0.0;
        public boolean StalkerSpawn = false;
        public boolean StalkerCountFinish = false;
        public double playerX = 0.0;
        public double playerY = 0.0;
        public double playerZ = 0.0;
        public double RottenArmorAbility = 0.0;
        public double hallucinate = 0.0;
        public double StalkerStalkCount = 0.0;
        public double VoidCaveAmbientSound = 0.0;
        public double VoidCloakAbility = 0.0;
        public boolean InCreative = false;
        public boolean InAdventure = false;
        public double cave_tremble = 0.0;
        public double darkness_absorption = 0.0;
        public boolean seek_light = false;
        public boolean playerCallOfTheVoid = false;
        public boolean hallucinating = false;
        public double deathgrounds_ambience = 0.0;
        public double flesh_roar = 0.0;
        public boolean armorToggle = false;
        public double monolithAmbience = 0.0;
        public double hasteAllSeeing = 0.0;
        public double allseeingArmor = 0.0;
        public double hallucinateX = 0.0;
        public double hallucinateY = 0.0;
        public double hallucinateZ = 0.0;
        public double soundHallX = 0.0;
        public double soundHallY = 0.0;
        public double soundHallZ = 0.0;
        public double hallucinateHurt = 0.0;
        public double nestAmbience = 0.0;
        public boolean InSurvival = false;
        public double breathingHillsAmbience = 0.0;
        public double breathingHillsHeart = 0.0;
        public double darknessDamageBuildUp = 0.0;
        public double motherCallOutCooldown = 0.0;
        public double motherlyCallCooldown = 0.0;
        public boolean FallSound = false;
        public double healthBoostLevel = 0.0;
        public double healthMask = 0.0;
        public boolean grimRottenArmorAttack = false;
        public boolean SendToHell = false;
        public boolean naturalTeleport = false;
        public double weaverBoots = 0.0;
        public double randomStalkerValue = 0.0;
        public double stalkingCount = 0.0;
        public double stalkWatcherCount = 0.0;
        public boolean noGravity = false;
        public double heartbeatIndicator = 0.0;
        public boolean hasSoulOrb = false;
        public boolean teleportToVoid = false;
        public double weaverRobeCooldown = 0.0;
        public double gatheringAmbience = 0.0;
        public boolean attackedByAnimosity = false;
        public double eyekinCooldown = 0.0;
        public double eyekinDash = 0.0;
        public double wingFlapSound = 0.0;
        public double hookX = 0.0;
        public double hookY = 0.0;
        public double hookZ = 0.0;
        public boolean hooked = false;
        public double voidriumTeleport = 0.0;
        public boolean noEscape = false;
        public double hiveCallX = 0.0;
        public double hiveCallY = 0.0;
        public double hiveCallZ = 0.0;
        public double hunterArmorAbility = 0.0;
        public double mistedRemnantAmbience = 0.0;
        public ItemStack saveArmor3 = ItemStack.EMPTY;
        public ItemStack saveArmor2 = ItemStack.EMPTY;
        public ItemStack saveArmor1 = ItemStack.EMPTY;
        public ItemStack saveArmor0 = ItemStack.EMPTY;
        public double saveArmorPoint = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("StalkerCount", this.StalkerCount);
            nbt.putDouble("ForgottenValleyAmbientSound", this.ForgottenValleyAmbientSound);
            nbt.putBoolean("StalkerSpawn", this.StalkerSpawn);
            nbt.putBoolean("StalkerCountFinish", this.StalkerCountFinish);
            nbt.putDouble("playerX", this.playerX);
            nbt.putDouble("playerY", this.playerY);
            nbt.putDouble("playerZ", this.playerZ);
            nbt.putDouble("RottenArmorAbility", this.RottenArmorAbility);
            nbt.putDouble("hallucinate", this.hallucinate);
            nbt.putDouble("StalkerStalkCount", this.StalkerStalkCount);
            nbt.putDouble("VoidCaveAmbientSound", this.VoidCaveAmbientSound);
            nbt.putDouble("VoidCloakAbility", this.VoidCloakAbility);
            nbt.putBoolean("InCreative", this.InCreative);
            nbt.putBoolean("InAdventure", this.InAdventure);
            nbt.putDouble("cave_tremble", this.cave_tremble);
            nbt.putDouble("darkness_absorption", this.darkness_absorption);
            nbt.putBoolean("seek_light", this.seek_light);
            nbt.putBoolean("playerCallOfTheVoid", this.playerCallOfTheVoid);
            nbt.putBoolean("hallucinating", this.hallucinating);
            nbt.putDouble("deathgrounds_ambience", this.deathgrounds_ambience);
            nbt.putDouble("flesh_roar", this.flesh_roar);
            nbt.putBoolean("armorToggle", this.armorToggle);
            nbt.putDouble("monolithAmbience", this.monolithAmbience);
            nbt.putDouble("hasteAllSeeing", this.hasteAllSeeing);
            nbt.putDouble("allseeingArmor", this.allseeingArmor);
            nbt.putDouble("hallucinateX", this.hallucinateX);
            nbt.putDouble("hallucinateY", this.hallucinateY);
            nbt.putDouble("hallucinateZ", this.hallucinateZ);
            nbt.putDouble("soundHallX", this.soundHallX);
            nbt.putDouble("soundHallY", this.soundHallY);
            nbt.putDouble("soundHallZ", this.soundHallZ);
            nbt.putDouble("hallucinateHurt", this.hallucinateHurt);
            nbt.putDouble("nestAmbience", this.nestAmbience);
            nbt.putBoolean("InSurvival", this.InSurvival);
            nbt.putDouble("breathingHillsAmbience", this.breathingHillsAmbience);
            nbt.putDouble("breathingHillsHeart", this.breathingHillsHeart);
            nbt.putDouble("darknessDamageBuildUp", this.darknessDamageBuildUp);
            nbt.putDouble("motherCallOutCooldown", this.motherCallOutCooldown);
            nbt.putDouble("motherlyCallCooldown", this.motherlyCallCooldown);
            nbt.putBoolean("FallSound", this.FallSound);
            nbt.putDouble("healthBoostLevel", this.healthBoostLevel);
            nbt.putDouble("healthMask", this.healthMask);
            nbt.putBoolean("grimRottenArmorAttack", this.grimRottenArmorAttack);
            nbt.putBoolean("SendToHell", this.SendToHell);
            nbt.putBoolean("naturalTeleport", this.naturalTeleport);
            nbt.putDouble("weaverBoots", this.weaverBoots);
            nbt.putDouble("randomStalkerValue", this.randomStalkerValue);
            nbt.putDouble("stalkingCount", this.stalkingCount);
            nbt.putDouble("stalkWatcherCount", this.stalkWatcherCount);
            nbt.putBoolean("noGravity", this.noGravity);
            nbt.putDouble("heartbeatIndicator", this.heartbeatIndicator);
            nbt.putBoolean("hasSoulOrb", this.hasSoulOrb);
            nbt.putBoolean("teleportToVoid", this.teleportToVoid);
            nbt.putDouble("weaverRobeCooldown", this.weaverRobeCooldown);
            nbt.putDouble("gatheringAmbience", this.gatheringAmbience);
            nbt.putBoolean("attackedByAnimosity", this.attackedByAnimosity);
            nbt.putDouble("eyekinCooldown", this.eyekinCooldown);
            nbt.putDouble("eyekinDash", this.eyekinDash);
            nbt.putDouble("wingFlapSound", this.wingFlapSound);
            nbt.putDouble("hookX", this.hookX);
            nbt.putDouble("hookY", this.hookY);
            nbt.putDouble("hookZ", this.hookZ);
            nbt.putBoolean("hooked", this.hooked);
            nbt.putDouble("voidriumTeleport", this.voidriumTeleport);
            nbt.putBoolean("noEscape", this.noEscape);
            nbt.putDouble("hiveCallX", this.hiveCallX);
            nbt.putDouble("hiveCallY", this.hiveCallY);
            nbt.putDouble("hiveCallZ", this.hiveCallZ);
            nbt.putDouble("hunterArmorAbility", this.hunterArmorAbility);
            nbt.putDouble("mistedRemnantAmbience", this.mistedRemnantAmbience);
            nbt.put("saveArmor3", this.saveArmor3.saveOptional(lookupProvider));
            nbt.put("saveArmor2", this.saveArmor2.saveOptional(lookupProvider));
            nbt.put("saveArmor1", this.saveArmor1.saveOptional(lookupProvider));
            nbt.put("saveArmor0", this.saveArmor0.saveOptional(lookupProvider));
            nbt.putDouble("saveArmorPoint", this.saveArmorPoint);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.StalkerCount = nbt.getDouble("StalkerCount");
            this.ForgottenValleyAmbientSound = nbt.getDouble("ForgottenValleyAmbientSound");
            this.StalkerSpawn = nbt.getBoolean("StalkerSpawn");
            this.StalkerCountFinish = nbt.getBoolean("StalkerCountFinish");
            this.playerX = nbt.getDouble("playerX");
            this.playerY = nbt.getDouble("playerY");
            this.playerZ = nbt.getDouble("playerZ");
            this.RottenArmorAbility = nbt.getDouble("RottenArmorAbility");
            this.hallucinate = nbt.getDouble("hallucinate");
            this.StalkerStalkCount = nbt.getDouble("StalkerStalkCount");
            this.VoidCaveAmbientSound = nbt.getDouble("VoidCaveAmbientSound");
            this.VoidCloakAbility = nbt.getDouble("VoidCloakAbility");
            this.InCreative = nbt.getBoolean("InCreative");
            this.InAdventure = nbt.getBoolean("InAdventure");
            this.cave_tremble = nbt.getDouble("cave_tremble");
            this.darkness_absorption = nbt.getDouble("darkness_absorption");
            this.seek_light = nbt.getBoolean("seek_light");
            this.playerCallOfTheVoid = nbt.getBoolean("playerCallOfTheVoid");
            this.hallucinating = nbt.getBoolean("hallucinating");
            this.deathgrounds_ambience = nbt.getDouble("deathgrounds_ambience");
            this.flesh_roar = nbt.getDouble("flesh_roar");
            this.armorToggle = nbt.getBoolean("armorToggle");
            this.monolithAmbience = nbt.getDouble("monolithAmbience");
            this.hasteAllSeeing = nbt.getDouble("hasteAllSeeing");
            this.allseeingArmor = nbt.getDouble("allseeingArmor");
            this.hallucinateX = nbt.getDouble("hallucinateX");
            this.hallucinateY = nbt.getDouble("hallucinateY");
            this.hallucinateZ = nbt.getDouble("hallucinateZ");
            this.soundHallX = nbt.getDouble("soundHallX");
            this.soundHallY = nbt.getDouble("soundHallY");
            this.soundHallZ = nbt.getDouble("soundHallZ");
            this.hallucinateHurt = nbt.getDouble("hallucinateHurt");
            this.nestAmbience = nbt.getDouble("nestAmbience");
            this.InSurvival = nbt.getBoolean("InSurvival");
            this.breathingHillsAmbience = nbt.getDouble("breathingHillsAmbience");
            this.breathingHillsHeart = nbt.getDouble("breathingHillsHeart");
            this.darknessDamageBuildUp = nbt.getDouble("darknessDamageBuildUp");
            this.motherCallOutCooldown = nbt.getDouble("motherCallOutCooldown");
            this.motherlyCallCooldown = nbt.getDouble("motherlyCallCooldown");
            this.FallSound = nbt.getBoolean("FallSound");
            this.healthBoostLevel = nbt.getDouble("healthBoostLevel");
            this.healthMask = nbt.getDouble("healthMask");
            this.grimRottenArmorAttack = nbt.getBoolean("grimRottenArmorAttack");
            this.SendToHell = nbt.getBoolean("SendToHell");
            this.naturalTeleport = nbt.getBoolean("naturalTeleport");
            this.weaverBoots = nbt.getDouble("weaverBoots");
            this.randomStalkerValue = nbt.getDouble("randomStalkerValue");
            this.stalkingCount = nbt.getDouble("stalkingCount");
            this.stalkWatcherCount = nbt.getDouble("stalkWatcherCount");
            this.noGravity = nbt.getBoolean("noGravity");
            this.heartbeatIndicator = nbt.getDouble("heartbeatIndicator");
            this.hasSoulOrb = nbt.getBoolean("hasSoulOrb");
            this.teleportToVoid = nbt.getBoolean("teleportToVoid");
            this.weaverRobeCooldown = nbt.getDouble("weaverRobeCooldown");
            this.gatheringAmbience = nbt.getDouble("gatheringAmbience");
            this.attackedByAnimosity = nbt.getBoolean("attackedByAnimosity");
            this.eyekinCooldown = nbt.getDouble("eyekinCooldown");
            this.eyekinDash = nbt.getDouble("eyekinDash");
            this.wingFlapSound = nbt.getDouble("wingFlapSound");
            this.hookX = nbt.getDouble("hookX");
            this.hookY = nbt.getDouble("hookY");
            this.hookZ = nbt.getDouble("hookZ");
            this.hooked = nbt.getBoolean("hooked");
            this.voidriumTeleport = nbt.getDouble("voidriumTeleport");
            this.noEscape = nbt.getBoolean("noEscape");
            this.hiveCallX = nbt.getDouble("hiveCallX");
            this.hiveCallY = nbt.getDouble("hiveCallY");
            this.hiveCallZ = nbt.getDouble("hiveCallZ");
            this.hunterArmorAbility = nbt.getDouble("hunterArmorAbility");
            this.mistedRemnantAmbience = nbt.getDouble("mistedRemnantAmbience");
            this.saveArmor3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("saveArmor3"));
            this.saveArmor2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("saveArmor2"));
            this.saveArmor1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("saveArmor1"));
            this.saveArmor0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("saveArmor0"));
            this.saveArmorPoint = nbt.getDouble("saveArmorPoint");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_mapvars";
        public boolean CultTemplePlaced = false;
        public boolean StalkerDespawned = false;
        public boolean WeaverTemplePlaced = false;
        public double stalkerSpawnX = 0.0;
        public double stalkerSpawnZ = 0.0;
        public double weaverFightCount = 0.0;
        public boolean overwritten = false;
        public boolean surfaceOverwritten = false;
        public double apostleFightCount = 0.0;
        public double hivemindFightCount = 0.0;
        public double primordialcrawlerFightCount = 0.0;
        public double hunterSpawnCooldown = 108000.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.CultTemplePlaced = nbt.getBoolean("CultTemplePlaced");
            this.StalkerDespawned = nbt.getBoolean("StalkerDespawned");
            this.WeaverTemplePlaced = nbt.getBoolean("WeaverTemplePlaced");
            this.stalkerSpawnX = nbt.getDouble("stalkerSpawnX");
            this.stalkerSpawnZ = nbt.getDouble("stalkerSpawnZ");
            this.weaverFightCount = nbt.getDouble("weaverFightCount");
            this.overwritten = nbt.getBoolean("overwritten");
            this.surfaceOverwritten = nbt.getBoolean("surfaceOverwritten");
            this.apostleFightCount = nbt.getDouble("apostleFightCount");
            this.hivemindFightCount = nbt.getDouble("hivemindFightCount");
            this.primordialcrawlerFightCount = nbt.getDouble("primordialcrawlerFightCount");
            this.hunterSpawnCooldown = nbt.getDouble("hunterSpawnCooldown");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("CultTemplePlaced", this.CultTemplePlaced);
            nbt.putBoolean("StalkerDespawned", this.StalkerDespawned);
            nbt.putBoolean("WeaverTemplePlaced", this.WeaverTemplePlaced);
            nbt.putDouble("stalkerSpawnX", this.stalkerSpawnX);
            nbt.putDouble("stalkerSpawnZ", this.stalkerSpawnZ);
            nbt.putDouble("weaverFightCount", this.weaverFightCount);
            nbt.putBoolean("overwritten", this.overwritten);
            nbt.putBoolean("surfaceOverwritten", this.surfaceOverwritten);
            nbt.putDouble("apostleFightCount", this.apostleFightCount);
            nbt.putDouble("hivemindFightCount", this.hivemindFightCount);
            nbt.putDouble("primordialcrawlerFightCount", this.primordialcrawlerFightCount);
            nbt.putDouble("hunterSpawnCooldown", this.hunterSpawnCooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.StalkerCount = original.StalkerCount;
            clone.ForgottenValleyAmbientSound = original.ForgottenValleyAmbientSound;
            clone.StalkerSpawn = original.StalkerSpawn;
            clone.StalkerCountFinish = original.StalkerCountFinish;
            clone.hallucinate = original.hallucinate;
            clone.StalkerStalkCount = original.StalkerStalkCount;
            clone.VoidCaveAmbientSound = original.VoidCaveAmbientSound;
            clone.InCreative = original.InCreative;
            clone.InAdventure = original.InAdventure;
            clone.cave_tremble = original.cave_tremble;
            clone.seek_light = original.seek_light;
            clone.playerCallOfTheVoid = original.playerCallOfTheVoid;
            clone.InSurvival = original.InSurvival;
            clone.SendToHell = original.SendToHell;
            clone.randomStalkerValue = original.randomStalkerValue;
            clone.stalkingCount = original.stalkingCount;
            clone.stalkWatcherCount = original.stalkWatcherCount;
            clone.noGravity = original.noGravity;
            clone.teleportToVoid = original.teleportToVoid;
            clone.hiveCallX = original.hiveCallX;
            clone.hiveCallY = original.hiveCallY;
            clone.hiveCallZ = original.hiveCallZ;
            clone.saveArmor3 = original.saveArmor3;
            clone.saveArmor2 = original.saveArmor2;
            clone.saveArmor1 = original.saveArmor1;
            clone.saveArmor0 = original.saveArmor0;
            clone.saveArmorPoint = original.saveArmorPoint;
            if (!event.isWasDeath()) {
                clone.playerX = original.playerX;
                clone.playerY = original.playerY;
                clone.playerZ = original.playerZ;
                clone.RottenArmorAbility = original.RottenArmorAbility;
                clone.VoidCloakAbility = original.VoidCloakAbility;
                clone.darkness_absorption = original.darkness_absorption;
                clone.hallucinating = original.hallucinating;
                clone.deathgrounds_ambience = original.deathgrounds_ambience;
                clone.flesh_roar = original.flesh_roar;
                clone.armorToggle = original.armorToggle;
                clone.monolithAmbience = original.monolithAmbience;
                clone.hasteAllSeeing = original.hasteAllSeeing;
                clone.allseeingArmor = original.allseeingArmor;
                clone.hallucinateX = original.hallucinateX;
                clone.hallucinateY = original.hallucinateY;
                clone.hallucinateZ = original.hallucinateZ;
                clone.soundHallX = original.soundHallX;
                clone.soundHallY = original.soundHallY;
                clone.soundHallZ = original.soundHallZ;
                clone.hallucinateHurt = original.hallucinateHurt;
                clone.nestAmbience = original.nestAmbience;
                clone.breathingHillsAmbience = original.breathingHillsAmbience;
                clone.breathingHillsHeart = original.breathingHillsHeart;
                clone.darknessDamageBuildUp = original.darknessDamageBuildUp;
                clone.motherCallOutCooldown = original.motherCallOutCooldown;
                clone.motherlyCallCooldown = original.motherlyCallCooldown;
                clone.FallSound = original.FallSound;
                clone.healthBoostLevel = original.healthBoostLevel;
                clone.healthMask = original.healthMask;
                clone.grimRottenArmorAttack = original.grimRottenArmorAttack;
                clone.naturalTeleport = original.naturalTeleport;
                clone.weaverBoots = original.weaverBoots;
                clone.heartbeatIndicator = original.heartbeatIndicator;
                clone.hasSoulOrb = original.hasSoulOrb;
                clone.weaverRobeCooldown = original.weaverRobeCooldown;
                clone.gatheringAmbience = original.gatheringAmbience;
                clone.attackedByAnimosity = original.attackedByAnimosity;
                clone.eyekinCooldown = original.eyekinCooldown;
                clone.eyekinDash = original.eyekinDash;
                clone.wingFlapSound = original.wingFlapSound;
                clone.hookX = original.hookX;
                clone.hookY = original.hookY;
                clone.hookZ = original.hookZ;
                clone.hooked = original.hooked;
                clone.voidriumTeleport = original.voidriumTeleport;
                clone.noEscape = original.noEscape;
                clone.hunterArmorAbility = original.hunterArmorAbility;
                clone.mistedRemnantAmbience = original.mistedRemnantAmbience;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

