/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client;

import java.util.Arrays;
import java.util.HashSet;
import me.neznamy.tab.libs.com.rabbitmq.client.SaslConfig;
import me.neznamy.tab.libs.com.rabbitmq.client.SaslMechanism;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.AnonymousMechanism;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.ExternalMechanism;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.PlainMechanism;

public class DefaultSaslConfig
implements SaslConfig {
    private final String mechanism;
    public static final DefaultSaslConfig PLAIN = new DefaultSaslConfig("PLAIN");
    public static final DefaultSaslConfig EXTERNAL = new DefaultSaslConfig("EXTERNAL");
    public static final DefaultSaslConfig ANONYMOUS = new DefaultSaslConfig("ANONYMOUS");

    private DefaultSaslConfig(String mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    public SaslMechanism getSaslMechanism(String[] serverMechanisms) {
        HashSet<String> server = new HashSet<String>(Arrays.asList(serverMechanisms));
        if (server.contains(this.mechanism)) {
            if (this.mechanism.equals("PLAIN")) {
                return new PlainMechanism();
            }
            if (this.mechanism.equals("EXTERNAL")) {
                return new ExternalMechanism();
            }
            if (this.mechanism.equals("ANONYMOUS")) {
                return new AnonymousMechanism();
            }
        }
        return null;
    }
}

