/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.com.rabbitmq.client.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import me.neznamy.tab.libs.com.rabbitmq.client.impl.nio.FrameBuilder;

public class SslEngineFrameBuilder
extends FrameBuilder {
    private final SSLEngine sslEngine;
    private final ByteBuffer cipherBuffer;
    private boolean isUnderflowHandlingEnabled = false;

    public SslEngineFrameBuilder(SSLEngine sslEngine, ByteBuffer plainIn, ByteBuffer cipherIn, ReadableByteChannel channel, int maxPayloadSize) {
        super(channel, plainIn, maxPayloadSize);
        this.sslEngine = sslEngine;
        this.cipherBuffer = cipherIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean somethingToRead() throws IOException {
        if (this.applicationBuffer.hasRemaining() && !this.isUnderflowHandlingEnabled) {
            return true;
        }
        this.applicationBuffer.clear();
        boolean underflowHandling = false;
        try {
            SSLEngineResult result = this.sslEngine.unwrap(this.cipherBuffer, this.applicationBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this.applicationBuffer.flip();
                    if (this.applicationBuffer.hasRemaining()) {
                        boolean bl = true;
                        return bl;
                    }
                    this.applicationBuffer.clear();
                    return false;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("buffer overflow in read");
                }
                case BUFFER_UNDERFLOW: {
                    this.cipherBuffer.compact();
                    underflowHandling = true;
                    boolean bl = false;
                    return bl;
                }
                case CLOSED: {
                    throw new SSLException("closed in read");
                }
                default: {
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
            }
        }
        finally {
            this.isUnderflowHandlingEnabled = underflowHandling;
        }
    }

    @Override
    public boolean isUnderflowHandlingEnabled() {
        return this.isUnderflowHandlingEnabled;
    }
}

