/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.v1_8_R1;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.server.v1_8_R1.EnumNameTagVisibility;
import net.minecraft.server.v1_8_R1.EnumScoreboardHealthDisplay;
import net.minecraft.server.v1_8_R1.IScoreboardCriteria;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_8_R1.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_8_R1.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_8_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R1.Scoreboard;
import net.minecraft.server.v1_8_R1.ScoreboardObjective;
import net.minecraft.server.v1_8_R1.ScoreboardScore;
import net.minecraft.server.v1_8_R1.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;

public class NMSPacketScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static final EnumNameTagVisibility[] visibilities = EnumNameTagVisibility.values();
    private static final Scoreboard dummyScoreboard = new Scoreboard();
    private static final Field TeamPacket_NAME = ReflectionUtils.getFields(PacketPlayOutScoreboardTeam.class, String.class).get(0);
    private static final Field TeamPacket_ACTION = ReflectionUtils.getInstanceFields(PacketPlayOutScoreboardTeam.class, Integer.TYPE).get(1);
    private static final Field TeamPacket_PLAYERS = ReflectionUtils.getOnlyField(PacketPlayOutScoreboardTeam.class, Collection.class);
    private static final Field Objective_OBJECTIVE_NAME = ReflectionUtils.getFields(PacketPlayOutScoreboardObjective.class, String.class).get(0);
    private static final Field Objective_METHOD = ReflectionUtils.getOnlyField(PacketPlayOutScoreboardObjective.class, Integer.TYPE);
    private static final Field DisplayObjective_OBJECTIVE_NAME = ReflectionUtils.getOnlyField(PacketPlayOutScoreboardDisplayObjective.class, String.class);
    private static final Field DisplayObjective_POSITION = ReflectionUtils.getOnlyField(PacketPlayOutScoreboardDisplayObjective.class, Integer.TYPE);

    public NMSPacketScoreboard(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = new ScoreboardObjective(dummyScoreboard, objective.getName(), IScoreboardCriteria.b);
        obj.setDisplayName(this.maybeCut(objective.getTitle().toLegacyText(), 32));
        obj.a(EnumScoreboardHealthDisplay.valueOf((String)objective.getHealthDisplay().name()));
        objective.setPlatformObjective(obj);
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective(obj, 0));
    }

    @Override
    public void setDisplaySlot(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardDisplayObjective(objective.getDisplaySlot().ordinal(), (ScoreboardObjective)objective.getPlatformObjective()));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective((ScoreboardObjective)objective.getPlatformObjective(), 1));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ScoreboardObjective obj = (ScoreboardObjective)objective.getPlatformObjective();
        obj.setDisplayName(this.maybeCut(objective.getTitle().toLegacyText(), 32));
        obj.a(EnumScoreboardHealthDisplay.valueOf((String)objective.getHealthDisplay().name()));
        this.sendPacket((Packet)new PacketPlayOutScoreboardObjective(obj, 2));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        ScoreboardScore s = new ScoreboardScore(dummyScoreboard, (ScoreboardObjective)score.getObjective().getPlatformObjective(), score.getHolder());
        s.setScore(score.getValue());
        this.sendPacket((Packet)new PacketPlayOutScoreboardScore(s));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardScore(score.getHolder()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new ScoreboardTeam(dummyScoreboard, name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.getPlayerNameSet().addAll(team.getPlayers());
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam(t, 0));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam((ScoreboardTeam)team.getPlatformTeam(), 1));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        this.sendPacket((Packet)new PacketPlayOutScoreboardTeam((ScoreboardTeam)team.getPlatformTeam(), 2));
    }

    private void updateTeamProperties(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ScoreboardTeam t = (ScoreboardTeam)team.getPlatformTeam();
        t.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        t.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        t.a(visibilities[team.getVisibility().ordinal()]);
        t.setPrefix(this.maybeCut(team.getPrefix().toLegacyText(), 16));
        t.setSuffix(this.maybeCut(team.getSuffix().toLegacyText(), 16));
    }

    @Override
    @NotNull
    public Object onPacketSend(@NonNull Object packet) {
        int action;
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof PacketPlayOutScoreboardDisplayObjective) {
            TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, DisplayObjective_POSITION.getInt(packet), (String)DisplayObjective_OBJECTIVE_NAME.get(packet));
        }
        if (packet instanceof PacketPlayOutScoreboardObjective) {
            TAB.getInstance().getFeatureManager().onObjective(this.player, Objective_METHOD.getInt(packet), (String)Objective_OBJECTIVE_NAME.get(packet));
        }
        if (packet instanceof PacketPlayOutScoreboardTeam && (action = TeamPacket_ACTION.getInt(packet)) != 2) {
            List<String> players = (List<String>)TeamPacket_PLAYERS.get(packet);
            if (players == null) {
                players = Collections.emptyList();
            }
            TeamPacket_PLAYERS.set(packet, this.onTeamPacket(action, (String)TeamPacket_NAME.get(packet), players));
        }
        return packet;
    }

    private void sendPacket(@NotNull Packet packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().playerConnection.sendPacket(packet);
    }

    @NotNull
    private String maybeCut(@NonNull String string, int length) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (((BukkitTabPlayer)this.player).getVersion().getMinorVersion() < 13 || TAB.getInstance().getConfiguration().getConfig().isPacketEventsCompensation()) {
            return NMSPacketScoreboard.cutTo(string, length);
        }
        return string;
    }
}

