/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.logging.LogUtils;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.fabric.FabricBossBar;
import me.neznamy.tab.platforms.fabric.FabricEventListener;
import me.neznamy.tab.platforms.fabric.FabricPipelineInjector;
import me.neznamy.tab.platforms.fabric.FabricScoreboard;
import me.neznamy.tab.platforms.fabric.FabricTabList;
import me.neznamy.tab.platforms.fabric.FabricTabPlayer;
import me.neznamy.tab.platforms.fabric.hook.FabricTabExpansion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.TabStyle;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.chat.component.TabKeybindComponent;
import me.neznamy.tab.shared.chat.component.TabTextComponent;
import me.neznamy.tab.shared.chat.component.TabTranslatableComponent;
import me.neznamy.tab.shared.chat.component.object.ObjectInfo;
import me.neznamy.tab.shared.chat.component.object.TabAtlasSprite;
import me.neznamy.tab.shared.chat.component.object.TabObjectComponent;
import me.neznamy.tab.shared.chat.component.object.TabPlayerSprite;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11719;
import net.minecraft.class_11723;
import net.minecraft.class_11724;
import net.minecraft.class_11885;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_9296;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FabricPlatform(MinecraftServer server) implements BackendPlatform
{
    private static final UUID NIL_UUID = new UUID(0L, 0L);

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        if (!FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            this.registerDummyPlaceholder(identifier);
            return;
        }
        PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
        manager.registerPlayerPlaceholder(identifier, p -> Placeholders.parseText((class_2561)class_2561.method_43470((String)identifier), (PlaceholderContext)PlaceholderContext.of((class_3222)((class_3222)p.getPlayer()))).getString());
    }

    @Override
    public void loadPlayers() {
        for (class_3222 player : this.getOnlinePlayers()) {
            TAB.getInstance().addPlayer(new FabricTabPlayer(this, player));
        }
    }

    private Collection<class_3222> getOnlinePlayers() {
        return this.server.method_3760() == null ? Collections.emptyList() : this.server.method_3760().method_14571();
    }

    @Override
    @NotNull
    public PipelineInjector createPipelineInjector() {
        return new FabricPipelineInjector();
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            return new FabricTabExpansion();
        }
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        LogUtils.getLogger().info("[TAB] {}", (Object)((class_2561)message.convert()).getString());
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        LogUtils.getLogger().warn("[TAB] {}", (Object)((class_2561)message.convert()).getString());
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Fabric] " + class_155.method_16673().comp_4025();
    }

    @Override
    public void registerListener() {
        new FabricEventListener().register();
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return FabricLoader.getInstance().getConfigDir().resolve("tab").toFile();
    }

    @NotNull
    public class_2561 convertComponent(@NotNull TabComponent component) {
        TabComponent tabComponent = component;
        Objects.requireNonNull(tabComponent);
        TabComponent tabComponent2 = tabComponent;
        int n = 0;
        class_5250 nmsComponent = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TabTextComponent.class, TabTranslatableComponent.class, TabKeybindComponent.class, TabObjectComponent.class}, (Object)tabComponent2, n)) {
            case 0 -> {
                TabTextComponent text = (TabTextComponent)tabComponent2;
                yield class_2561.method_43470((String)text.getText());
            }
            case 1 -> {
                TabTranslatableComponent translatable = (TabTranslatableComponent)tabComponent2;
                yield class_2561.method_43471((String)translatable.getKey());
            }
            case 2 -> {
                TabKeybindComponent keybind = (TabKeybindComponent)tabComponent2;
                yield class_2561.method_43472((String)keybind.getKeybind());
            }
            case 3 -> {
                TabObjectComponent object = (TabObjectComponent)tabComponent2;
                ObjectInfo v2 = object.getContents();
                Objects.requireNonNull(v2);
                ObjectInfo var11_9 = v2;
                int var12_10 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TabAtlasSprite.class, TabPlayerSprite.class}, (Object)var11_9, var12_10)) {
                    case 0: {
                        TabAtlasSprite sprite = (TabAtlasSprite)var11_9;
                        yield class_2561.method_74062((class_11724)new class_11723(class_2960.method_60654((String)sprite.getAtlas()), class_2960.method_60654((String)sprite.getSprite())));
                    }
                    case 1: {
                        TabPlayerSprite sprite = (TabPlayerSprite)var11_9;
                        yield class_2561.method_74062((class_11724)new class_11885(this.spriteToProfile(sprite), sprite.isShowHat()));
                    }
                }
                throw new IllegalStateException("Unexpected object component type: " + object.getContents().getClass().getName());
            }
            default -> throw new IllegalStateException("Unexpected component type: " + component.getClass().getName());
        };
        TabStyle modifier = component.getModifier();
        class_2583 style = class_2583.field_24360.method_27703(modifier.getColor() == null ? null : class_5251.method_27717((int)modifier.getColor().getRgb())).method_10982(modifier.getBold()).method_10978(modifier.getItalic()).method_30938(modifier.getUnderlined()).method_36140(modifier.getStrikethrough()).method_36141(modifier.getObfuscated()).method_27704((class_11719)(modifier.getFont() == null ? null : new class_11719.class_11721(class_2960.method_60654((String)modifier.getFont()))));
        if (modifier.getShadowColor() != null) {
            style = style.method_65302(modifier.getShadowColor().intValue());
        }
        nmsComponent.method_10862(style);
        for (TabComponent extra : component.getExtra()) {
            nmsComponent.method_10855().add(this.convertComponent(extra));
        }
        return nmsComponent;
    }

    @NotNull
    private class_9296 spriteToProfile(@NonNull TabPlayerSprite sprite) {
        if (sprite == null) {
            throw new NullPointerException("sprite is marked non-null but is null");
        }
        if (sprite.getId() != null) {
            return class_9296.method_73312((UUID)sprite.getId());
        }
        if (sprite.getName() != null) {
            return class_9296.method_74889((String)sprite.getName());
        }
        if (sprite.getSkin() != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)"textures", (Object)new Property("textures", sprite.getSkin().getValue(), sprite.getSkin().getSignature()));
            return class_9296.method_73307((GameProfile)new GameProfile(NIL_UUID, "", new PropertyMap((Multimap)builder.build())));
        }
        throw new IllegalStateException("Player head component does not have id, name or skin set");
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new FabricScoreboard((FabricTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new FabricBossBar((FabricTabPlayer)player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new FabricTabList((FabricTabPlayer)player);
    }

    @Override
    public boolean supportsScoreboards() {
        return true;
    }

    @Override
    public double getTPS() {
        double mspt = this.getMSPT();
        if (mspt < 50.0) {
            return 20.0;
        }
        return Math.round(1000.0 / mspt);
    }

    @Override
    public double getMSPT() {
        return (float)this.server.method_54834() / 1000000.0f;
    }
}

