/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.platforms.forge.hook.LuckPermsAPIHook;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ForgeTabCommand {
    public void onRegisterCommands(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)Commands.literal((String)"tab").executes(context -> this.executeCommand((CommandSourceStack)context.getSource(), new String[0]))).build();
        ArgumentCommandNode args = ((RequiredArgumentBuilder)Commands.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> this.getSuggestions((CommandSourceStack)context.getSource(), this.getArguments((CommandContext<CommandSourceStack>)context), builder)).executes(context -> this.executeCommand((CommandSourceStack)context.getSource(), this.getArguments((CommandContext<CommandSourceStack>)context)))).build();
        command.addChild((CommandNode)args);
        dispatcher.getRoot().addChild((CommandNode)command);
    }

    @NotNull
    private String[] getArguments(@NotNull CommandContext<CommandSourceStack> context) {
        String input = context.getInput();
        int firstSpace = input.indexOf(32);
        if (firstSpace == -1) {
            return new String[0];
        }
        String rawArgs = input.substring(firstSpace + 1);
        String[] args = rawArgs.split(" ");
        if (rawArgs.endsWith(" ")) {
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = "";
        }
        return args;
    }

    private int executeCommand(@NotNull CommandSourceStack source, @NotNull String[] args) {
        if (TAB.getInstance().isPluginDisabled()) {
            boolean hasReloadPermission = LuckPermsAPIHook.hasPermission(source, "tab.reload");
            boolean hasAdminPermission = LuckPermsAPIHook.hasPermission(source, "tab.admin");
            for (String message : TAB.getInstance().getDisabledCommand().execute(args, hasReloadPermission, hasAdminPermission)) {
                source.sendSystemMessage((Component)TabComponent.fromColoredText(message).convert());
            }
        } else if (source.getEntity() == null) {
            TAB.getInstance().getCommand().execute(null, args);
        } else {
            TabPlayer player = TAB.getInstance().getPlayer(source.getEntity().getUUID());
            if (player != null) {
                TAB.getInstance().getCommand().execute(player, args);
            }
        }
        return 0;
    }

    @NotNull
    private CompletableFuture<Suggestions> getSuggestions(@NotNull CommandSourceStack source, @NotNull String[] args, @NotNull SuggestionsBuilder builder) {
        TabPlayer player = null;
        if (source.getEntity() != null && (player = TAB.getInstance().getPlayer(source.getEntity().getUUID())) == null) {
            return Suggestions.empty();
        }
        SuggestionsBuilder newBuilder = builder;
        int lastSpace = newBuilder.getRemaining().lastIndexOf(32);
        if (lastSpace != -1) {
            newBuilder = newBuilder.createOffset(lastSpace + 1 + newBuilder.getStart());
        }
        for (String suggestion : TAB.getInstance().getCommand().complete(player, args)) {
            newBuilder.suggest(suggestion);
        }
        return newBuilder.buildFuture();
    }
}

