/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.forge;

import me.neznamy.tab.platforms.forge.ForgePlatform;
import me.neznamy.tab.platforms.forge.ForgeTAB;
import me.neznamy.tab.platforms.forge.hook.LuckPermsAPIHook;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.chat.component.TabComponent;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ForgeTabPlayer
extends BackendTabPlayer {
    public ForgeTabPlayer(@NotNull ForgePlatform platform, @NotNull ServerPlayer player) {
        super(platform, player, player.getUUID(), player.getGameProfile().name(), ForgeTAB.getLevelName((Level)player.level()), SharedConstants.getProtocolVersion());
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return LuckPermsAPIHook.hasPermission(this.getPlayer().createCommandSourceStack(), permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().connection.latency();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendSystemMessage((Component)message.convert());
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return false;
    }

    @Override
    public boolean isDisguised() {
        return false;
    }

    @NotNull
    public ServerPlayer getPlayer() {
        return (ServerPlayer)this.player;
    }

    @Override
    public ForgePlatform getPlatform() {
        return (ForgePlatform)this.platform;
    }

    @Override
    public boolean isVanished0() {
        return false;
    }

    @Override
    public int getDeaths() {
        return this.getPlayer().getStats().getValue(Stats.CUSTOM.get((Object)Stats.DEATHS));
    }

    @Override
    public int getGamemode() {
        return this.getPlayer().gameMode.getGameModeForPlayer().getId();
    }

    @Override
    public double getHealth() {
        return this.getPlayer().getHealth();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.getPlayer().getGameProfile().name();
    }
}

