/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge;

import java.io.File;
import lombok.Generated;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.libs.org.bstats.sponge.Metrics;
import me.neznamy.tab.platforms.sponge.SpongeEventListener;
import me.neznamy.tab.platforms.sponge.SpongeScoreboard;
import me.neznamy.tab.platforms.sponge.SpongeTAB;
import me.neznamy.tab.platforms.sponge.SpongeTabList;
import me.neznamy.tab.platforms.sponge.SpongeTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.impl.AdventureBossBar;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class SpongePlatform
implements BackendPlatform {
    @NotNull
    private final SpongeTAB plugin;
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(Sponge.game().platform().minecraftVersion().name());

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        this.registerDummyPlaceholder(identifier);
    }

    @Override
    public void loadPlayers() {
        for (ServerPlayer player : Sponge.server().onlinePlayers()) {
            TAB.getInstance().addPlayer(new SpongeTabPlayer(this, player));
        }
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return null;
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        Sponge.systemSubject().sendMessage(Component.text((String)"[TAB] ").append(message.toAdventure()));
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        Sponge.systemSubject().sendMessage(Component.text((String)"[TAB] [WARN] ").append(message.toAdventure()));
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Sponge] " + Sponge.platform().minecraftVersion().name();
    }

    @Override
    public void registerListener() {
        Sponge.game().eventManager().registerListeners(this.plugin.getContainer(), (Object)new SpongeEventListener());
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
        Metrics metrics = this.plugin.getMetricsFactory().make(17732);
        metrics.startup(null);
        metrics.addCustomChart(new SimplePie("server_version", this.serverVersion::getFriendlyName));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getConfigDir().toFile();
    }

    @NotNull
    public Component convertComponent(@NotNull TabComponent component) {
        return component.toAdventure();
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new SpongeScoreboard((SpongeTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new AdventureBossBar(player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new SpongeTabList((SpongeTabPlayer)player);
    }

    @Override
    public boolean supportsScoreboards() {
        return true;
    }

    @Override
    public boolean supportsListOrder() {
        return false;
    }

    @Override
    public double getTPS() {
        return Sponge.server().ticksPerSecond();
    }

    @Override
    public double getMSPT() {
        return Sponge.server().averageTickTime();
    }

    @Generated
    public SpongePlatform(@NotNull SpongeTAB plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Generated
    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

