/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.EventContextKeys;

public class SpongeTabCommand
implements Command.Raw {
    @NotNull
    public CommandResult process(@NotNull CommandCause cause, @NotNull ArgumentReader.Mutable arguments) {
        String[] args = arguments.input().split(" ");
        if (TAB.getInstance().isPluginDisabled()) {
            boolean hasReloadPermission = cause.hasPermission("tab.reload");
            boolean hasAdminPermission = cause.hasPermission("tab.admin");
            List<String> messages = TAB.getInstance().getDisabledCommand().execute(args, hasReloadPermission, hasAdminPermission);
            for (String message : messages) {
                cause.sendMessage(Identity.nil(), TabComponent.fromColoredText(message).toAdventure());
            }
            return CommandResult.success();
        }
        TabPlayer player = null;
        if (cause.audience() instanceof Player && (player = TAB.getInstance().getPlayer(((Player)cause.audience()).uniqueId())) == null) {
            return CommandResult.success();
        }
        TAB.getInstance().getCommand().execute(player, args);
        return CommandResult.success();
    }

    @NotNull
    public List<CommandCompletion> complete(@NotNull CommandCause cause, @NotNull ArgumentReader.Mutable arguments) {
        TabPlayer player = null;
        Player source = cause.context().get(EventContextKeys.PLAYER).orElse(null);
        if (source != null && (player = TAB.getInstance().getPlayer(source.uniqueId())) == null) {
            return Collections.emptyList();
        }
        String[] args = arguments.input().split(" ");
        if (arguments.input().endsWith(" ")) {
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = "";
        }
        return TAB.getInstance().getCommand().complete(player, args).stream().map(CommandCompletion::of).collect(Collectors.toList());
    }

    public boolean canExecute(@NotNull CommandCause cause) {
        return true;
    }

    @NotNull
    public Optional<Component> shortDescription(@NotNull CommandCause cause) {
        return Optional.empty();
    }

    @NotNull
    public Optional<Component> extendedDescription(@NotNull CommandCause cause) {
        return Optional.empty();
    }

    @NotNull
    public Component usage(@NotNull CommandCause cause) {
        return Component.empty();
    }
}

