/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge;

import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.sponge.SpongeTabPlayer;
import me.neznamy.tab.shared.chat.component.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SpongeTabList
extends TrackedTabList<SpongeTabPlayer> {
    private static final GameMode[] gameModes = new GameMode[]{(GameMode)GameModes.SURVIVAL.get(), (GameMode)GameModes.CREATIVE.get(), (GameMode)GameModes.ADVENTURE.get(), (GameMode)GameModes.SPECTATOR.get()};

    public SpongeTabList(@NotNull SpongeTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().removeEntry(entry);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable TabComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setDisplayName(displayName == null ? null : displayName.toAdventure()));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setLatency(latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setGameMode(gameModes[gameMode]));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setListed(listed));
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry0(@NonNull TabList.Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        GameProfile profile = GameProfile.of((UUID)entry.getUniqueId(), (String)entry.getName());
        if (entry.getSkin() != null) {
            profile = profile.withProperty(ProfileProperty.of((String)"textures", (String)entry.getSkin().getValue(), (String)entry.getSkin().getSignature()));
        }
        TabListEntry tabListEntry = TabListEntry.builder().list(((SpongeTabPlayer)this.player).getPlayer().tabList()).profile(profile).latency(entry.getLatency()).gameMode(gameModes[entry.getGameMode()]).displayName(entry.getDisplayName() == null ? null : entry.getDisplayName().toAdventure()).listed(entry.isListed()).build();
        ((SpongeTabPlayer)this.player).getPlayer().tabList().addEntry(tabListEntry);
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().setHeaderAndFooter(header.toAdventure(), footer.toAdventure());
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).isPresent();
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        List list = ((SpongeTabPlayer)this.player).getPlayer().profile().properties();
        if (list.isEmpty()) {
            return null;
        }
        for (ProfileProperty property : list) {
            if (!property.name().equals("textures")) continue;
            return new TabList.Skin(property.value(), property.signature().orElse(null));
        }
        return null;
    }

    @Override
    public void checkDisplayNames() {
        for (TabListEntry entry : ((SpongeTabPlayer)this.player).getPlayer().tabList().entries()) {
            TabComponent expectedComponent = this.getForcedDisplayNames().get(entry.profile().uniqueId());
            if (expectedComponent == null || entry.displayName().orElse(null) == expectedComponent.toAdventure()) continue;
            entry.setDisplayName(expectedComponent.toAdventure());
        }
    }

    @Override
    public void checkGameModes() {
        for (TabListEntry entry : ((SpongeTabPlayer)this.player).getPlayer().tabList().entries()) {
            Integer forcedGameMode = this.getForcedGameModes().get(entry.profile().uniqueId());
            if (forcedGameMode == null || this.getGamemode(entry.gameMode()) == forcedGameMode.intValue()) continue;
            entry.setGameMode(gameModes[forcedGameMode]);
        }
    }

    private int getGamemode(@NonNull GameMode gameMode) {
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        if (gameMode == GameModes.CREATIVE.get()) {
            return 1;
        }
        if (gameMode == GameModes.ADVENTURE.get()) {
            return 2;
        }
        if (gameMode == GameModes.SPECTATOR.get()) {
            return 3;
        }
        return 0;
    }
}

