/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge;

import java.util.Collections;
import java.util.Map;
import me.neznamy.tab.platforms.sponge.SpongePlatform;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.chat.component.TabComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ServerConnectionState;
import org.spongepowered.api.statistic.Statistics;

public class SpongeTabPlayer
extends BackendTabPlayer {
    public SpongeTabPlayer(@NotNull SpongePlatform platform, @NotNull ServerPlayer player) {
        super(platform, player, player.uniqueId(), player.name(), player.world().key().value(), platform.getServerVersion().getNetworkId());
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().connection().state().map(c2 -> ((ServerConnectionState.Game)c2).latency()).orElse(0);
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage(message.toAdventure());
    }

    @Override
    public boolean hasInvisibilityPotion() {
        for (PotionEffect effect : this.getPlayer().get(Keys.POTION_EFFECTS).orElse(Collections.emptyList())) {
            if (effect.type() != PotionEffectTypes.INVISIBILITY.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDisguised() {
        return false;
    }

    @NotNull
    public ServerPlayer getPlayer() {
        return (ServerPlayer)this.player;
    }

    @Override
    public SpongePlatform getPlatform() {
        return (SpongePlatform)this.platform;
    }

    @Override
    public boolean isVanished0() {
        return ((VanishState)this.getPlayer().vanishState().get()).invisible();
    }

    @Override
    public int getDeaths() {
        return ((Long)((Map)this.getPlayer().statistics().get()).get(Statistics.DEATHS.get())).intValue();
    }

    @Override
    public int getGamemode() {
        if (this.getPlayer().gameMode().get() == GameModes.CREATIVE.get()) {
            return 1;
        }
        if (this.getPlayer().gameMode().get() == GameModes.ADVENTURE.get()) {
            return 2;
        }
        if (this.getPlayer().gameMode().get() == GameModes.SPECTATOR.get()) {
            return 3;
        }
        return 0;
    }

    @Override
    public double getHealth() {
        return (Double)this.getPlayer().health().get();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return PlainTextComponentSerializer.plainText().serialize((Component)this.getPlayer().displayName().get());
    }
}

